/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.constant;

import com.jxdinfo.hussar.support.exception.HussarException;

public enum EaiDataType {
    DATA_TYPE_BOOLEAN(0, "Boolean", "\u5e03\u5c14\u503c\uff08Boolean\uff09"),
    DATA_TYPE_INTEGER(1, "Integer", "\u6574\u578b\uff08Integer\uff09"),
    DATA_TYPE_LONG(2, "Long", "\u957f\u6574\u578b\uff08Long\uff09"),
    DATA_TYPE_DOUBLE(3, "Double", "\u5c0f\u6570\uff08Double\uff09"),
    DATA_TYPE_STRING(4, "String", "\u5b57\u7b26\u4e32\uff08String\uff09"),
    DATA_TYPE_DATE(5, "Date", "\u65e5\u671f\uff08Date\uff09"),
    DATA_TYPE_LIST(6, "List", "\u6570\u7ec4\uff08List\uff09"),
    DATA_TYPE_STRUCTURE(7, "Structure", "\u6570\u636e\u7ed3\u6784");

    private int type;
    private String code;
    private String msg;

    private EaiDataType(int type, String code, String msg) {
        this.code = code;
        this.type = type;
        this.msg = msg;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeStr() {
        return String.valueOf(this.type);
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public static EaiDataType getEaiDataType(Integer type) {
        for (EaiDataType dataType : EaiDataType.values()) {
            if (dataType.getType() != type.intValue()) continue;
            return dataType;
        }
        throw new HussarException("\u4e0d\u5b58\u5728\u7684\u7c7b\u578b");
    }

    public static EaiDataType getBaseModelType(Integer type) {
        int n = 0;
        EaiDataType[] eaiDataTypeArray = EaiDataType.values();
        int n2 = eaiDataTypeArray.length;
        if (n < n2) {
            EaiDataType dataType = eaiDataTypeArray[n];
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return dataType;
                }
            }
            return null;
        }
        return null;
    }
}

