/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StructureQuoteIdPattern {
    private static final Pattern pattern = Pattern.compile("\"quoteStructureId\":\"\\d+\"");
    private static final Integer QUOTE_STRUCTUREID_LEN = 20;
    private static final String FORMAT_STR = "\"quoteStructureId\":\"%d\"";

    public static List<Long> getIds(String values) {
        ArrayList<Long> list = new ArrayList<Long>();
        Matcher matcher = pattern.matcher(values);
        while (matcher.find()) {
            String result = matcher.group();
            String id = result.substring(QUOTE_STRUCTUREID_LEN, result.length() - 1);
            list.add(Long.valueOf(id));
        }
        return list;
    }

    public static String replaceIds(String values, Map<Long, Long> idMaps) {
        for (Map.Entry<Long, Long> entry : idMaps.entrySet()) {
            String key = String.format(FORMAT_STR, entry.getKey());
            if (!values.contains(key)) continue;
            String value = String.format(FORMAT_STR, entry.getValue());
            values = values.replace(key, value);
        }
        return values;
    }
}

