/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.enums.sys;

import com.jxdinfo.hussar.common.exception.BaseException;

public enum EaiCharsetEnum {
    UTF8(0, "UTF-8"),
    GBK(1, "GBK"),
    ISO_8859_1(2, "ISO-8859-1"),
    GB2312(3, "GB2312"),
    ASCII(4, "US-ASCII");

    private int code;
    private String name;

    private EaiCharsetEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeStr() {
        return String.valueOf(this.code);
    }

    public String getName() {
        return this.name;
    }

    public static EaiCharsetEnum getByName(String name) {
        for (EaiCharsetEnum eaiCharsetEnum : EaiCharsetEnum.values()) {
            if (!eaiCharsetEnum.getName().equals(name)) continue;
            return eaiCharsetEnum;
        }
        throw new BaseException("\u4e0d\u5b58\u5728\u7684\u7c7b\u578b");
    }

    public static EaiCharsetEnum getByCode(int code) {
        for (EaiCharsetEnum eaiCharsetEnum : EaiCharsetEnum.values()) {
            if (eaiCharsetEnum.getCode() != code) continue;
            return eaiCharsetEnum;
        }
        throw new BaseException("\u4e0d\u5b58\u5728\u7684\u7c7b\u578b");
    }
}

