/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiParamsTestConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EaiFormDataParamsConvertUtil {
    public static final int HEADER = 0;
    public static final int BODY = 1;
    public static final int QUERY = 2;
    private static final String ERROR_MSG = "\u5b58\u5728\u91cd\u590d\u4fe1\u606f";

    public static List<EaiParamsItems> getEaiParamsItems(String mappingParams) {
        return EaiFormDataParamsConvertUtil.getEaiParamsItems(EaiFormDataParamsConvertUtil.convertParams(mappingParams));
    }

    public static List<EaiParamsItems> getEaiParamsItems(EaiParamsTestConvertDto paramsConvertDtoV) {
        if (HussarUtils.isNull((Object)paramsConvertDtoV)) {
            return null;
        }
        List<EaiParamsItems> header = EaiFormDataParamsConvertUtil.formatEaiParamsItems(paramsConvertDtoV, 0);
        List<EaiParamsItems> query = EaiFormDataParamsConvertUtil.formatEaiParamsItems(paramsConvertDtoV, 2);
        List<EaiParamsItems> body = EaiFormDataParamsConvertUtil.formatEaiParamsItems(paramsConvertDtoV, 1);
        return EaiFormDataParamsConvertUtil.transForm(header, query, body, false);
    }

    private static List<EaiParamsItems> transForm(List<EaiParamsItems> header, List<EaiParamsItems> query, List<EaiParamsItems> body, boolean autoTransForm) {
        if (ParamsConvertUtil.isNotDistinct(header) || ParamsConvertUtil.isNotDistinct(query) || ParamsConvertUtil.isNotDistinct(body)) {
            throw new BaseException(ERROR_MSG);
        }
        ArrayList<EaiParamsItems> result = new ArrayList<EaiParamsItems>();
        if (header != null) {
            result.addAll(header);
        }
        if (query != null) {
            result.addAll(query);
        }
        if (body != null) {
            result.addAll(body);
        }
        if (autoTransForm) {
            ArrayList keys = new ArrayList();
            result.forEach(eaiParamsItems -> {
                String name = eaiParamsItems.getName();
                if (keys.contains(name)) {
                    String newName = name + eaiParamsItems.getMapping();
                    eaiParamsItems.setMappingName(name + eaiParamsItems.getMapping());
                    keys.add(newName);
                } else {
                    eaiParamsItems.setMappingName(name);
                    keys.add(name);
                }
            });
            keys.clear();
        }
        return result;
    }

    private static List<EaiParamsItems> formatEaiParamsItems(EaiParamsTestConvertDto eaiParamsConvertDto, int pos) {
        if (HussarUtils.isNotEmpty((Object)eaiParamsConvertDto)) {
            switch (pos) {
                case 0: {
                    List<EaiParamsItems> header = eaiParamsConvertDto.getHeader();
                    return EaiFormDataParamsConvertUtil.geEaiParamsItemsList(header, 0);
                }
                case 2: {
                    List<EaiParamsItems> query = eaiParamsConvertDto.getQuery();
                    return EaiFormDataParamsConvertUtil.geEaiParamsItemsList(query, 2);
                }
                case 1: {
                    List<EaiParamsItems> body = eaiParamsConvertDto.getBody();
                    if (body.size() == 1 && "Object".equals(body.get(0).getValue())) {
                        body = body.get(0).getItems();
                    }
                    return EaiFormDataParamsConvertUtil.geEaiParamsItemsList(body, 1);
                }
            }
        }
        return null;
    }

    private static List<EaiParamsItems> geEaiParamsItemsList(List<EaiParamsItems> list, int mapping) {
        if (HussarUtils.isNotEmpty(list)) {
            list.forEach(eaiParamsItems -> eaiParamsItems.setMapping(mapping));
            return list;
        }
        return new ArrayList<EaiParamsItems>();
    }

    public static EaiParamsTestConvertDto convertParams(String mappingParams) {
        return ParamsConvertUtil.toEaiParamsTestConvertDto(mappingParams);
    }

    public static EaiApiParams formDataEaiParamsItems(Map<String, Object> params, List<EaiParamsItems> realParams, boolean isConfiguration) {
        if (HussarUtils.isEmpty(params)) {
            return new EaiApiParams();
        }
        EaiApiParams eaiApiParams = new EaiApiParams();
        Iterator<String> keys = params.keySet().iterator();
        HashMap<String, Object> header = new HashMap<String, Object>();
        HashMap<String, Object> query = new HashMap<String, Object>();
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        block5: while (keys.hasNext()) {
            String key = keys.next();
            for (EaiParamsItems paramsItem : realParams) {
                String realKey = paramsItem.getName();
                HashMap<String, EaiParamsItems> parentMap = new HashMap<String, EaiParamsItems>();
                if (HussarUtils.isNotEmpty((Object)paramsItem.getQuoteStructureId())) {
                    parentMap.put(paramsItem.getQuoteStructureId(), paramsItem);
                }
                boolean finished = false;
                Integer mapKey = paramsItem.getMapping();
                if (paramsItem.getMappingName().equals(key)) {
                    switch (mapKey) {
                        case 0: {
                            if (!params.containsKey(key)) break;
                            header.put(realKey, ParamsConvertUtil.convertValue(paramsItem.getType(), params.get(key), isConfiguration));
                            break;
                        }
                        case 2: {
                            if (!params.containsKey(key)) break;
                            query.put(realKey, ParamsConvertUtil.convertValue(paramsItem.getType(), params.get(key), isConfiguration));
                            break;
                        }
                        case 1: {
                            if (HussarUtils.isNotEmpty((Object)params.get(key))) {
                                if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getType().intValue()) {
                                    List obj = (List)params.get(key);
                                    ArrayList<Object> list = new ArrayList<Object>();
                                    EaiFormDataParamsConvertUtil.bodyListArray(obj, paramsItem, list, isConfiguration);
                                    body.put(realKey, list);
                                    break;
                                }
                                body.put(realKey, ParamsConvertUtil.convertValue(paramsItem.getType(), params.get(key), isConfiguration));
                                break;
                            }
                            body.put(realKey, params.get(key));
                            break;
                        }
                    }
                    finished = true;
                }
                if (!finished) continue;
                continue block5;
            }
        }
        eaiApiParams.setHeader(header);
        eaiApiParams.setQuery(query);
        eaiApiParams.setBody(body);
        return eaiApiParams;
    }

    public static EaiApiParams formDataEaiParamsItems(Map<String, Object> params, String mappingParams, boolean isConfiguration) {
        if (HussarUtils.isEmpty(params)) {
            return new EaiApiParams();
        }
        List<EaiParamsItems> realParams = EaiFormDataParamsConvertUtil.getEaiParamsItems(mappingParams);
        return EaiFormDataParamsConvertUtil.formDataEaiParamsItems(params, realParams, isConfiguration);
    }

    private static void bodyListArray(List<Object> obj, EaiParamsItems paramsItem, List<Object> list, boolean isConfiguration) {
        if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getItemType().intValue()) {
            EaiParamsItems childParamsItems = paramsItem.getItems().get(0);
            ArrayList<Object> childList = new ArrayList<Object>();
            for (Object object : obj) {
                if (HussarUtils.isNotEmpty((Object)object)) {
                    EaiFormDataParamsConvertUtil.bodyListArray((List)object, childParamsItems, childList, isConfiguration);
                }
                childList.add(Collections.EMPTY_LIST);
            }
            list.add(childList);
        } else {
            for (Object object : obj) {
                ParamsConvertUtil.convertValue(paramsItem.getItemType(), object, isConfiguration);
                list.add(object);
            }
        }
    }
}

