/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.enums.api;

import com.jxdinfo.hussar.common.exception.BaseException;

public enum EaiContentType {
    NONE(0, "none"),
    APPLICATION_JSON(1, "application/json"),
    FORM_DATA(2, "multipart/form-data"),
    X_WWW_FORM(3, "application/x-www-form-urlencoded"),
    TEXT_PLAIN(4, "text/plain"),
    APPLICATION_XML(5, "application/xml"),
    TEXT_HTML(6, "text/html"),
    APPLICATION_JAVASCRIPT(7, "application/javascript");

    private int type;
    private String name;

    private EaiContentType(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeStr() {
        return String.valueOf(this.type);
    }

    public String getName() {
        return this.name;
    }

    public static EaiContentType getByName(String name) {
        for (EaiContentType eaiContentType : EaiContentType.values()) {
            if (!eaiContentType.getName().equals(name)) continue;
            return eaiContentType;
        }
        throw new BaseException("\u4e0d\u5b58\u5728\u7684\u7c7b\u578b");
    }

    public static EaiContentType getByType(int type) {
        for (EaiContentType eaiContentType : EaiContentType.values()) {
            if (eaiContentType.getType() != type) continue;
            return eaiContentType;
        }
        throw new BaseException("\u4e0d\u5b58\u5728\u7684\u7c7b\u578b");
    }
}

