/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiOutParamDto;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.EaiParamsTestConvertDto;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamsConvertUtil {
    public static final int CONVERT_LIST = 0;
    public static final int CONVERT_DTO = 2;
    public static final boolean AUTO_TRANS_FORM = false;
    public static final int HEADER = 0;
    public static final int BODY = 1;
    public static final int QUERY = 2;
    public static final String HEADER_STR = "header";
    public static final String BODY_STR = "body";
    public static final String QUERY_STR = "query";
    private static final String ERROR_MSG = "\u5b58\u5728\u91cd\u590d\u4fe1\u606f";
    private static final String TRANS_ERROR_MSG = "\u6570\u636e\u7ed3\u6784\u8f6c\u6362\u5931\u8d25";
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamsConvertUtil.class);
    private static final String DOUBLE_MARK = "\"";
    private static final String ITEMS = "items";
    private static final String TYPE = "type";
    private static final String COLON = ":";
    private static final String BRACE = "{";
    private static final String BRACE_OPPOSITE = "}";
    private static final String MID = "[";
    private static final String MID_OPPOSITE = "]";
    private static final String COMMA = ",";
    private static final String SCHEMA_START = "{\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"properties\":{";

    private ParamsConvertUtil() {
    }

    public static List<EaiParamsItems> toEaiParamsItems(EaiParamsConvertDto paramsConvertDtoV, boolean autoTransForm) {
        if (HussarUtils.isNull((Object)paramsConvertDtoV)) {
            return null;
        }
        EaiParamsConvertDto paramsConvertDto = new EaiParamsConvertDto(paramsConvertDtoV);
        List<EaiParamsItems> header = ParamsConvertUtil.formatEaiParamsItems(paramsConvertDto, 0);
        List<EaiParamsItems> query = ParamsConvertUtil.formatEaiParamsItems(paramsConvertDto, 2);
        EaiParamsItems body = paramsConvertDto.getBody();
        return ParamsConvertUtil.transForm(header, query, body, autoTransForm);
    }

    public static List<EaiParamsItems> toEaiParamsItems(EaiParamsTestConvertDto paramsConvertDtoV, boolean autoTransForm) {
        if (HussarUtils.isNull((Object)paramsConvertDtoV)) {
            return null;
        }
        EaiParamsTestConvertDto paramsConvertDto = new EaiParamsTestConvertDto(paramsConvertDtoV);
        List<EaiParamsItems> header = ParamsConvertUtil.formatEaiParamsItems(paramsConvertDto, 0);
        List<EaiParamsItems> query = ParamsConvertUtil.formatEaiParamsItems(paramsConvertDto, 2);
        List<EaiParamsItems> body = ParamsConvertUtil.formatEaiParamsItems(paramsConvertDto, 1);
        return ParamsConvertUtil.transForm(header, query, body, autoTransForm);
    }

    private static List<EaiParamsItems> transForm(List<EaiParamsItems> header, List<EaiParamsItems> query, List<EaiParamsItems> body, boolean autoTransForm) {
        if (ParamsConvertUtil.isNotDistinct(header) || ParamsConvertUtil.isNotDistinct(query) || ParamsConvertUtil.isNotDistinct(body)) {
            LOGGER.trace(ERROR_MSG);
            throw new BaseException(ERROR_MSG);
        }
        ArrayList<EaiParamsItems> result = new ArrayList<EaiParamsItems>();
        if (header != null) {
            result.addAll(header);
        }
        if (query != null) {
            result.addAll(query);
        }
        if (body != null) {
            result.addAll(body);
        }
        ParamsConvertUtil.setAutoTransForm(autoTransForm, result);
        return result;
    }

    private static void setAutoTransForm(boolean autoTransForm, List<EaiParamsItems> result) {
        if (autoTransForm) {
            ArrayList keys = new ArrayList();
            result.forEach(eaiParamsItems -> {
                String name = eaiParamsItems.getName();
                if (keys.contains(name)) {
                    String newName = name + eaiParamsItems.getMapping();
                    eaiParamsItems.setMappingName(name + eaiParamsItems.getMapping());
                    keys.add(newName);
                } else {
                    eaiParamsItems.setMappingName(name);
                    keys.add(name);
                }
            });
            keys.clear();
        }
    }

    private static List<EaiParamsItems> transForm(List<EaiParamsItems> header, List<EaiParamsItems> query, EaiParamsItems body, boolean autoTransForm) {
        if (ParamsConvertUtil.isNotDistinct(header) || ParamsConvertUtil.isNotDistinct(query) || HussarUtils.isNotEmpty((Object)body) && ParamsConvertUtil.isNotDistinct(body.getItems())) {
            LOGGER.trace(ERROR_MSG);
            throw new BaseException(ERROR_MSG);
        }
        ArrayList<EaiParamsItems> result = new ArrayList<EaiParamsItems>();
        if (header != null) {
            result.addAll(header);
        }
        if (query != null) {
            result.addAll(query);
        }
        if (body != null) {
            body.setMapping(1);
            result.add(body);
        }
        ParamsConvertUtil.setAutoTransForm(autoTransForm, result);
        return result;
    }

    public static boolean isNotDistinct(List<EaiParamsItems> paramsItems) {
        return !ParamsConvertUtil.isDistinct(paramsItems);
    }

    public static boolean isDistinct(List<EaiParamsItems> paramsItems) {
        List newParams;
        return !HussarUtils.isNotEmpty(paramsItems) || (newParams = paramsItems.stream().distinct().collect(Collectors.toList())).size() == paramsItems.size();
    }

    public static String toEaiParamsItemsStr(EaiParamsConvertDto paramsConvertDto, Integer type, boolean autoTransForm) {
        switch (type) {
            case 0: {
                return ParamsConvertUtil.toJSONString(ParamsConvertUtil.toEaiParamsItems(paramsConvertDto, autoTransForm));
            }
            case 2: {
                return ParamsConvertUtil.toJSONString(paramsConvertDto);
            }
        }
        return null;
    }

    public static String toEaiParamsItemsStr(EaiParamsTestConvertDto paramsConvertDto, Integer type, boolean autoTransForm) {
        switch (type) {
            case 0: {
                return ParamsConvertUtil.toJSONString(ParamsConvertUtil.toEaiParamsItems(paramsConvertDto, autoTransForm));
            }
            case 2: {
                return ParamsConvertUtil.toJSONString(paramsConvertDto);
            }
        }
        return null;
    }

    public static List<EaiParamsItems> toEaiParamsItems(String eaiParamsItems) {
        EaiParamsConvertDto eaiParamsConvertDto = ParamsConvertUtil.toEaiParamsConvertDto(eaiParamsItems);
        return ParamsConvertUtil.toEaiParamsItems(eaiParamsConvertDto, false);
    }

    public static EaiApiParams webServiceEaiParamsItems(Object params, String mappingParams) {
        return ParamsConvertUtil.webServiceEaiParamsItems(params, mappingParams, true);
    }

    public static EaiApiParams webServiceEaiParamsItems(Object params, String mappingParams, boolean isConfiguration) {
        if (HussarUtils.isEmpty((Object)params)) {
            return new EaiApiParams();
        }
        String paramsStr = null;
        paramsStr = params instanceof CharSequence ? String.valueOf(params) : HussarIntegrationJsonUtils.toString((Object)params);
        EaiApiParams eaiApiParams = new EaiApiParams();
        JSONObject jsonObject = (JSONObject)HussarIntegrationJsonUtils.parse((String)paramsStr, JSONObject.class);
        Iterator keys = jsonObject.keySet().iterator();
        List<EaiParamsItems> realParams = ParamsConvertUtil.toEaiParamsItems(mappingParams);
        HashMap<String, Object> header = new HashMap<String, Object>();
        Object[] body = new Object[1];
        int num = ParamsConvertUtil.getLastDepNum(jsonObject);
        block4: while (keys.hasNext()) {
            String key = (String)keys.next();
            for (EaiParamsItems paramsItem : realParams) {
                HashMap<String, EaiParamsItems> parentMap = new HashMap<String, EaiParamsItems>();
                if (HussarUtils.isNotEmpty((Object)paramsItem.getQuoteStructureId())) {
                    parentMap.put(paramsItem.getQuoteStructureId(), paramsItem);
                }
                ParamsConvertUtil.initRecursionItems(paramsItem.getItems(), parentMap, paramsItem, num);
                boolean finished = false;
                Integer mapKey = paramsItem.getMapping();
                if (paramsItem.getMappingName().equals(key)) {
                    switch (mapKey) {
                        case 0: {
                            if (!jsonObject.containsKey((Object)key)) break;
                            header.put(paramsItem.getName(), ParamsConvertUtil.convertValue(paramsItem.getType(), jsonObject.get((Object)key), isConfiguration));
                            break;
                        }
                        case 1: {
                            if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)key))) {
                                JSONArray obj;
                                List<EaiParamsItems> bodyList = paramsItem.getItems();
                                if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getType().intValue()) {
                                    bodyList = bodyList.get(0).getItems();
                                    obj = jsonObject.getJSONArray(key);
                                    if (HussarUtils.isNotEmpty((Object)obj) && EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getItemType().intValue()) {
                                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(obj.size());
                                        ParamsConvertUtil.bodyListArray(obj, bodyList, list, false, isConfiguration);
                                        body[0] = list;
                                        break;
                                    }
                                    body[0] = ParamsConvertUtil.convertValue((int)paramsItem.getItemType(), obj, isConfiguration);
                                } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getType().intValue()) {
                                    obj = jsonObject.getJSONObject(key);
                                    if (HussarUtils.isNotEmpty((Object)obj)) {
                                        HashMap<String, Object> map = new HashMap<String, Object>();
                                        ParamsConvertUtil.bodyListMap((JSONObject)obj, bodyList, map, false, isConfiguration);
                                        body[0] = map;
                                        break;
                                    }
                                } else {
                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                    Object value = ParamsConvertUtil.convertValue((int)paramsItem.getItemType(), jsonObject.get((Object)key), isConfiguration);
                                    map.put(paramsItem.getName(), value);
                                    body[0] = map;
                                }
                            }
                            body[0] = jsonObject.get((Object)key);
                            break;
                        }
                    }
                    finished = true;
                }
                if (!finished) continue;
                continue block4;
            }
        }
        eaiApiParams.setHeader(header);
        eaiApiParams.setBody(body[0]);
        return eaiApiParams;
    }

    private static String convertSchemaType(Integer type) {
        return EaiDataType.getEaiDataType(type).getCode().toLowerCase();
    }

    private static void stringRecursion(List<EaiParamsItems> paramsItems, StringBuffer sb, boolean chideren) {
        paramsItems.forEach(param -> {
            if (chideren) {
                sb.append(BRACE);
            }
            sb.append(DOUBLE_MARK).append(param.getMappingName()).append(DOUBLE_MARK).append(COLON).append(BRACE).append(DOUBLE_MARK).append(TYPE).append(DOUBLE_MARK).append(COLON).append(DOUBLE_MARK).append(ParamsConvertUtil.convertSchemaType(param.getType())).append(DOUBLE_MARK);
            List<EaiParamsItems> list = param.getItems();
            if (HussarUtils.isNotEmpty(list)) {
                sb.append(DOUBLE_MARK).append(ITEMS).append(DOUBLE_MARK).append(COLON).append(MID);
                ParamsConvertUtil.stringRecursion(list, sb, true);
                if (COMMA.equals(String.valueOf(sb.charAt(sb.length() - 1)))) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append(MID_OPPOSITE);
            }
            if (chideren) {
                sb.append(BRACE_OPPOSITE);
            }
            sb.append(BRACE_OPPOSITE).append(COMMA);
        });
    }

    public static String toJsonSchemaStr(String str) {
        StringBuffer sb = new StringBuffer(512);
        sb.append(SCHEMA_START);
        EaiParamsConvertDto eaiParamsConvertDto = ParamsConvertUtil.toEaiParamsConvertDto(str);
        if (HussarUtils.isNotEmpty((Object)eaiParamsConvertDto)) {
            EaiParamsItems body;
            List<EaiParamsItems> query;
            List<EaiParamsItems> headers = eaiParamsConvertDto.getHeader();
            if (HussarUtils.isNotEmpty(headers)) {
                ParamsConvertUtil.stringRecursion(headers, sb, false);
            }
            if (HussarUtils.isNotEmpty(query = eaiParamsConvertDto.getQuery())) {
                ParamsConvertUtil.stringRecursion(query, sb, false);
            }
            if (HussarUtils.isNotEmpty((Object)(body = eaiParamsConvertDto.getBody()))) {
                sb.append(DOUBLE_MARK).append(body.getMappingName()).append(DOUBLE_MARK).append(COLON).append(BRACE).append(DOUBLE_MARK).append(TYPE).append(DOUBLE_MARK).append(COLON).append(DOUBLE_MARK).append(ParamsConvertUtil.convertSchemaType(body.getType())).append(DOUBLE_MARK);
                List<EaiParamsItems> bodyItems = body.getItems();
                if (HussarUtils.isNotEmpty(bodyItems)) {
                    sb.append(COMMA).append(DOUBLE_MARK).append(ITEMS).append(DOUBLE_MARK).append(COLON).append(MID);
                    ParamsConvertUtil.stringRecursion(bodyItems, sb, true);
                    if (COMMA.equals(String.valueOf(sb.charAt(sb.length() - 1)))) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    sb.append(MID_OPPOSITE);
                }
                sb.append(BRACE_OPPOSITE);
            }
        }
        sb.append(BRACE_OPPOSITE).append(BRACE_OPPOSITE);
        return sb.toString();
    }

    public static Object parseWebServiceResult(Object params, List<EaiParamsItems> mappings) {
        if (HussarUtils.isNotEmpty(mappings)) {
            String name = mappings.get(0).getMappingName();
            HashMap<String, Object> map = new HashMap<String, Object>();
            int type = mappings.get(0).getType();
            if (EaiDataType.DATA_TYPE_LIST.getType() != type && EaiDataType.DATA_TYPE_STRUCTURE.getType() != type) {
                if (HussarUtils.isNotEmpty(mappings.get(0).getItems())) {
                    mappings.get(0).setType(EaiDataType.DATA_TYPE_STRUCTURE.getType());
                    Object result = ParamsConvertUtil.parseResult(params, JSON.toJSONString(mappings));
                    map.put(name, result);
                } else if (params instanceof Map) {
                    map.put(name, ((Map)params).get(mappings.get(0).getName()));
                } else {
                    map.put(name, params);
                }
            } else {
                return ParamsConvertUtil.parseResult(params, JSON.toJSONString(mappings), true);
            }
            return map;
        }
        return params;
    }

    public static Object parseResult(Object params, String mappings) {
        return ParamsConvertUtil.parseResult(params, mappings, false);
    }

    private static int deepNum(Object params) {
        int num = 0;
        if (params instanceof CharSequence) {
            num = 1;
        } else if (params instanceof List) {
            for (Object param : (List)params) {
                int cNum = ParamsConvertUtil.deepNum(param);
                if (cNum <= num) continue;
                num = cNum;
            }
        } else {
            num = ParamsConvertUtil.getLastDepNum(JSON.parseObject((String)JSON.toJSONString((Object)params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
        }
        return num;
    }

    public static Object parseResult(Object params, String mappings, Boolean withParent) {
        return ParamsConvertUtil.parseResult(params, mappings, withParent, true);
    }

    public static Object parseResult(Object params, String mappings, Boolean withParent, boolean isConfiguration) {
        if (HussarUtils.isEmpty((Object)params)) {
            return params;
        }
        try {
            Integer num = 0;
            JSONObject mappingParams = JSON.parseArray((String)mappings).getJSONObject(0);
            if (HussarUtils.isNotEmpty((Object)params)) {
                num = ParamsConvertUtil.deepNum(params);
                EaiParamsItems paramsItem = (EaiParamsItems)JSON.parseObject((String)JSON.toJSONString((Object)mappingParams), EaiParamsItems.class);
                HashMap<String, EaiParamsItems> parentMap = new HashMap<String, EaiParamsItems>();
                String qid = paramsItem.getQuoteStructureId();
                if (HussarUtils.isNotEmpty((Object)qid)) {
                    parentMap.put(qid, paramsItem);
                }
                ParamsConvertUtil.initRecursionItems(paramsItem.getItems(), parentMap, paramsItem, num);
                mappingParams = JSON.parseObject((String)JSON.toJSONString((Object)paramsItem, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            if (EaiDataType.DATA_TYPE_LIST.getType() == mappingParams.getIntValue(TYPE)) {
                JSONArray array = JSONObject.parseArray((String)JSON.toJSONString((Object)params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                ArrayList result = new ArrayList(array.size());
                JSONObject fparams = mappingParams;
                array.forEach(arr -> {
                    JSONObject item = fparams.getJSONArray(ITEMS).getJSONObject(0);
                    if (EaiDataType.DATA_TYPE_LIST.getType() != item.getIntValue(TYPE) && EaiDataType.DATA_TYPE_STRUCTURE.getType() != item.getIntValue(TYPE)) {
                        result.add(arr);
                    } else {
                        result.add(ParamsConvertUtil.formatBodyResult(arr, item.getString(ITEMS), isConfiguration));
                    }
                });
                return result;
            }
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == mappingParams.getIntValue(TYPE)) {
                Object obj = null;
                if (!withParent.booleanValue()) {
                    obj = ParamsConvertUtil.formatBodyResult(params, mappingParams.getString(ITEMS), isConfiguration);
                } else {
                    ArrayList<JSONObject> list = new ArrayList<JSONObject>(1);
                    list.add(mappingParams);
                    obj = ParamsConvertUtil.formatBodyResult(params, ParamsConvertUtil.toJSONString(list), isConfiguration);
                }
                return obj;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (e instanceof BaseException) {
                throw new BaseException(HussarUtils.isEmpty((Object)e.getMessage()) ? "\u51fa\u53c2\u7ed3\u6784\u8f6c\u6362\u5931\u8d25" : e.getMessage());
            }
            throw new BaseException("\u51fa\u53c2\u7ed3\u6784\u8f6c\u6362\u5931\u8d25");
        }
        throw new BaseException("\u65e0\u6cd5\u89e3\u6790\u51fa\u53c2\u7ed3\u6784\u7c7b\u578b,\u51fa\u53c2\u7ed3\u6784\u53ea\u80fd\u662fLIST\u6216STRUCTURE");
    }

    public static Object formatBodyResult(Object params, String mappingParams, boolean isConfiguration) {
        if (HussarUtils.isEmpty((Object)params)) {
            return new EaiApiParams();
        }
        List realParams = JSON.parseArray((String)mappingParams, EaiParamsItems.class);
        String paramsStr = null;
        try {
            paramsStr = params instanceof CharSequence ? String.valueOf(params) : JSON.toJSONString((Object)params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u683c\u5f0f");
        }
        return ParamsConvertUtil.filResult(realParams, paramsStr, isConfiguration);
    }

    private static Object filResult(List<EaiParamsItems> realParams, String paramsStr, boolean isConfiguration) {
        JSONObject jsonObject = JSON.parseObject((String)paramsStr);
        Iterator keys = jsonObject.keySet().iterator();
        HashMap<String, Object> map = new HashMap<String, Object>();
        block0: while (keys.hasNext()) {
            Object[] body = new Object[1];
            String key = (String)keys.next();
            ParamsConvertUtil.filObj(key, jsonObject, realParams, body, isConfiguration);
            for (EaiParamsItems realParam : realParams) {
                if (!key.equals(realParam.getName())) continue;
                map.put(realParam.getMappingName(), body[0]);
                continue block0;
            }
        }
        return map;
    }

    private static void filObj(String key, JSONObject jsonObject, List<EaiParamsItems> realParams, Object[] body, boolean isConfiguration) {
        for (EaiParamsItems paramsItem : realParams) {
            if (!paramsItem.getName().equals(key)) continue;
            if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)key))) {
                Object convertValue;
                List<EaiParamsItems> bodyList = paramsItem.getItems();
                if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getType().intValue()) {
                    bodyList = bodyList.get(0).getItems();
                    JSONArray obj = jsonObject.getJSONArray(key);
                    if (HussarUtils.isNotEmpty((Object)obj) && EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getItemType().intValue()) {
                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(obj.size());
                        ParamsConvertUtil.bodyListArray(obj, bodyList, list, true, isConfiguration);
                        body[0] = list;
                        break;
                    }
                    body[0] = obj;
                    break;
                }
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getType().intValue()) {
                    JSONObject obj = jsonObject.getJSONObject(key);
                    if (!HussarUtils.isNotEmpty((Object)obj)) break;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    ParamsConvertUtil.bodyListMap(obj, bodyList, map, true, isConfiguration);
                    body[0] = map;
                    break;
                }
                body[0] = convertValue = ParamsConvertUtil.convertValue(paramsItem.getType(), jsonObject.get((Object)key), isConfiguration);
                break;
            }
            body[0] = jsonObject.get((Object)key);
            break;
        }
    }

    public static EaiApiParams openEaiParamsItems(Object params, String mappingParams) {
        return ParamsConvertUtil.oEaiParamsItems(params, mappingParams, true);
    }

    public static EaiApiParams oEaiParamsItems(Object params, String mappingParams) {
        return ParamsConvertUtil.oEaiParamsItems(params, mappingParams, false);
    }

    private static String serializeParams(Object params, boolean isConfiguration) {
        if (isConfiguration) {
            return HussarIntegrationJsonUtils.Contextual.toString((Object)params);
        }
        return HussarIntegrationJsonUtils.toString((Object)params);
    }

    public static EaiApiParams oEaiParamsItems(Object params, String mappingParams, boolean isLogicConvert) {
        return ParamsConvertUtil.oEaiParamsItems(params, mappingParams, isLogicConvert, true);
    }

    public static EaiApiParams oEaiParamsItems(Object params, String mappingParams, boolean isLogicConvert, boolean isConfiguration) {
        if (HussarUtils.isEmpty((Object)params)) {
            return new EaiApiParams();
        }
        String paramsStr = null;
        paramsStr = params instanceof CharSequence ? String.valueOf(params) : ParamsConvertUtil.serializeParams(params, isConfiguration);
        EaiApiParams eaiApiParams = new EaiApiParams();
        JSONObject jsonObject = JSON.parseObject((String)paramsStr);
        Iterator keys = jsonObject.keySet().iterator();
        List realParams = ParamsConvertUtil.toEaiParamsItems(mappingParams);
        if (isLogicConvert) {
            try {
                realParams = JSON.parseArray((String)mappingParams, EaiParamsItems.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HashMap<String, Object> header = new HashMap<String, Object>();
        HashMap<String, Object> query = new HashMap<String, Object>();
        Object[] body = new Object[1];
        int num = ParamsConvertUtil.getLastDepNum(jsonObject);
        block7: while (keys.hasNext()) {
            String key = (String)keys.next();
            for (EaiParamsItems paramsItem : realParams) {
                HashMap<String, EaiParamsItems> parentMap = new HashMap<String, EaiParamsItems>();
                if (HussarUtils.isNotEmpty((Object)paramsItem.getQuoteStructureId())) {
                    parentMap.put(paramsItem.getQuoteStructureId(), paramsItem);
                }
                ParamsConvertUtil.initRecursionItems(paramsItem.getItems(), parentMap, paramsItem, num);
                boolean finished = false;
                Integer mapKey = paramsItem.getMapping();
                if (paramsItem.getMappingName().equals(key)) {
                    switch (mapKey) {
                        case 0: {
                            if (!jsonObject.containsKey((Object)key)) break;
                            header.put(paramsItem.getName(), jsonObject.get((Object)key));
                            break;
                        }
                        case 2: {
                            if (!jsonObject.containsKey((Object)key)) break;
                            query.put(paramsItem.getName(), jsonObject.get((Object)key));
                            break;
                        }
                        case 1: {
                            if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)key))) {
                                JSONArray obj;
                                List<EaiParamsItems> bodyList = paramsItem.getItems();
                                if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getType().intValue()) {
                                    bodyList = bodyList.get(0).getItems();
                                    obj = jsonObject.getJSONArray(key);
                                    if (HussarUtils.isNotEmpty((Object)obj) && EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getItemType().intValue()) {
                                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(obj.size());
                                        ParamsConvertUtil.bodyListArray(obj, bodyList, list, false, isConfiguration);
                                        ParamsConvertUtil.multiResult(isLogicConvert, body, key, list);
                                        break;
                                    }
                                    ParamsConvertUtil.multiResult(isLogicConvert, body, key, obj);
                                }
                                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getType().intValue() && HussarUtils.isNotEmpty((Object)(obj = jsonObject.getJSONObject(key)))) {
                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                    ParamsConvertUtil.bodyListMap((JSONObject)obj, bodyList, map, false, isConfiguration);
                                    ParamsConvertUtil.multiResult(isLogicConvert, body, key, map);
                                    break;
                                }
                            }
                            ParamsConvertUtil.multiResult(isLogicConvert, body, key, jsonObject.get((Object)key));
                            break;
                        }
                    }
                    finished = true;
                }
                if (!finished) continue;
                continue block7;
            }
        }
        eaiApiParams.setHeader(header);
        eaiApiParams.setQuery(query);
        eaiApiParams.setBody(body[0]);
        return eaiApiParams;
    }

    private static void multiResult(boolean isLogicConvert, Object[] body, String key, Object value) {
        if (isLogicConvert) {
            Map<String, Object> map = new HashMap<String, Object>();
            if (HussarUtils.isNotEmpty((Object)body[0])) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)body[0], (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            }
            map.put(key, value);
            body[0] = map;
        } else {
            body[0] = value;
        }
    }

    private static Integer getLastDepNum(JSONObject jsonObject) {
        Integer max = 1;
        for (String key : jsonObject.keySet()) {
            Integer num;
            Object child = jsonObject.get((Object)key);
            if (!HussarUtils.isNotEmpty((Object)child)) continue;
            if (child instanceof JSONObject) {
                num = ParamsConvertUtil.getLastDepNum((JSONObject)child) + 1;
                if (num <= max) continue;
                max = num;
                continue;
            }
            if (!(child instanceof JSONArray) || (num = Integer.valueOf(ParamsConvertUtil.getLastDepNum((JSONArray)child) + 1)) <= max) continue;
            max = num;
        }
        return max;
    }

    private static Integer getLastDepNum(JSONArray jsonArray) {
        Integer max = 1;
        for (Object obj : jsonArray) {
            int curr;
            if (!HussarUtils.isNotEmpty(obj)) continue;
            if (obj instanceof JSONObject) {
                curr = ParamsConvertUtil.getLastDepNum((JSONObject)obj) + 1;
                if (curr <= max) continue;
                max = curr;
                continue;
            }
            if (!(obj instanceof JSONArray) || (curr = ParamsConvertUtil.getLastDepNum((JSONArray)obj) + 1) <= max) continue;
            max = curr;
        }
        return max;
    }

    private static void initRecursionItems(List<EaiParamsItems> paramsItems, Map<String, EaiParamsItems> map, EaiParamsItems realParamItems, int depnum) {
        ArrayList<EaiParamsItems> childItems = new ArrayList<EaiParamsItems>();
        for (EaiParamsItems paramsItem : paramsItems) {
            String qid = paramsItem.getQuoteStructureId();
            if (HussarUtils.isNotEmpty((Object)qid)) {
                if (!map.containsKey(qid)) {
                    map.put(qid, paramsItem);
                } else {
                    paramsItem.setItems(map.get(qid).getItems());
                }
            }
            if (HussarUtils.isNotEmpty(paramsItem.getItems()) && depnum > 0) {
                ParamsConvertUtil.initRecursionItems(paramsItem.getItems(), map, paramsItem, --depnum);
            }
            childItems.add(paramsItem);
        }
        realParamItems.setItems(childItems);
    }

    private static void bodyListMap(JSONObject obj, List<EaiParamsItems> bodyList, Map<String, Object> map, boolean result, boolean isConfiguration) {
        obj.forEach((k, v) -> {
            for (EaiParamsItems paramsItems : bodyList) {
                String name = paramsItems.getMappingName();
                if (result) {
                    name = paramsItems.getName();
                }
                if (!k.equals(name)) continue;
                ParamsConvertUtil.bodyCommon(k, v, paramsItems, map, result, isConfiguration);
            }
        });
    }

    private static void bodyCommon(String k, Object v, EaiParamsItems paramsItems, Map<String, Object> map, boolean result, boolean isConfiguration) {
        if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue()) {
            if (HussarUtils.isNotEmpty((Object)v)) {
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getItemType().intValue()) {
                    ArrayList<Map<String, Object>> child = new ArrayList<Map<String, Object>>();
                    List<EaiParamsItems> bodyList = paramsItems.getItems().get(0).getItems();
                    ParamsConvertUtil.bodyListArray(ParamsConvertUtil.parseJSONArray(v), bodyList, child, result, isConfiguration);
                    ParamsConvertUtil.putValue(map, paramsItems, result, child);
                } else {
                    Object convertValue = ParamsConvertUtil.convertValue(paramsItems.getType(), v, isConfiguration);
                    ParamsConvertUtil.putValue(map, paramsItems, result, convertValue);
                }
            } else {
                ParamsConvertUtil.putValue(map, paramsItems, result, v);
            }
            return;
        }
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
            if (HussarUtils.isNotEmpty((Object)v)) {
                HashMap<String, Object> childMap = new HashMap<String, Object>();
                if (v instanceof JSONArray) {
                    ((JSONArray)v).forEach(item -> ParamsConvertUtil.bodyListMap(ParamsConvertUtil.parseJSONObject(item), paramsItems.getItems(), childMap, result, isConfiguration));
                } else {
                    ParamsConvertUtil.bodyListMap(ParamsConvertUtil.parseJSONObject(v), paramsItems.getItems(), childMap, result, isConfiguration);
                }
                ParamsConvertUtil.putValue(map, paramsItems, result, childMap);
            } else {
                ParamsConvertUtil.putValue(map, paramsItems, result, v);
            }
            return;
        }
        Object convertValue = ParamsConvertUtil.convertValue(paramsItems.getType(), v, isConfiguration);
        ParamsConvertUtil.putValue(map, paramsItems, result, convertValue);
    }

    private static void putValue(Map<String, Object> map, EaiParamsItems paramsItems, boolean result, Object convertValue) {
        if (!result) {
            map.put(paramsItems.getName(), convertValue);
        } else {
            map.put(paramsItems.getMappingName(), convertValue);
        }
    }

    private static Object convertParams(Class clazz, Object value, boolean isConfiguration) {
        if (isConfiguration) {
            return HussarIntegrationJsonUtils.Contextual.convert((Object)value, (Class)clazz);
        }
        return HussarIntegrationJsonUtils.convert((Object)value, (Class)clazz);
    }

    public static Object convertValue(Integer type, Object value, boolean isConfiguration) {
        Object result = value;
        switch (EaiDataType.getEaiDataType(type)) {
            case DATA_TYPE_BOOLEAN: {
                result = ParamsConvertUtil.convertParams(Boolean.class, value, isConfiguration);
                break;
            }
            case DATA_TYPE_INTEGER: {
                result = ParamsConvertUtil.convertParams(Integer.class, value, isConfiguration);
                break;
            }
            case DATA_TYPE_LONG: {
                result = ParamsConvertUtil.convertParams(Long.class, value, isConfiguration);
                break;
            }
            case DATA_TYPE_DOUBLE: {
                result = ParamsConvertUtil.convertParams(Double.class, value, isConfiguration);
                break;
            }
            case DATA_TYPE_STRING: {
                result = ParamsConvertUtil.convertParams(String.class, value, isConfiguration);
                break;
            }
            case DATA_TYPE_DATE: {
                result = ParamsConvertUtil.convertParams(LocalDateTime.class, value, isConfiguration);
                break;
            }
        }
        return result;
    }

    private static void bodyListArray(JSONArray obj, List<EaiParamsItems> bodyList, List<Map<String, Object>> list, boolean result, boolean isConfiguration) {
        for (Object object : obj) {
            HashMap map = new HashMap();
            JSONObject realChild = ParamsConvertUtil.parseJSONObject(object);
            realChild.forEach((k, v) -> {
                for (EaiParamsItems paramsItems : bodyList) {
                    String name = paramsItems.getMappingName();
                    if (result) {
                        name = paramsItems.getName();
                    }
                    if (!k.equals(name)) continue;
                    ParamsConvertUtil.bodyCommon(k, v, paramsItems, map, result, isConfiguration);
                }
            });
            list.add(map);
        }
    }

    public static EaiParamsConvertDto toEaiParamsConvertDto(String eaiParamsItems) {
        if (HussarUtils.isEmpty((Object)eaiParamsItems)) {
            return null;
        }
        if (eaiParamsItems.startsWith(BRACE)) {
            try {
                return (EaiParamsConvertDto)JSON.parseObject((String)eaiParamsItems, EaiParamsConvertDto.class);
            }
            catch (Exception e) {
                LOGGER.trace(TRANS_ERROR_MSG, (Throwable)e);
                throw new BaseException(TRANS_ERROR_MSG);
            }
        }
        JSONArray array = JSON.parseArray((String)eaiParamsItems);
        ArrayList<EaiParamsItems> header = new ArrayList<EaiParamsItems>();
        ArrayList<EaiParamsItems> query = new ArrayList<EaiParamsItems>();
        EaiParamsConvertDto result = new EaiParamsConvertDto();
        array.forEach(obj -> {
            EaiParamsItems paramsItems = (EaiParamsItems)JSON.parseObject((String)ParamsConvertUtil.toJSONString(obj), EaiParamsItems.class);
            Integer map = paramsItems.getMapping();
            if (!HussarUtils.isEmpty((Object)map)) {
                switch (map) {
                    case 0: {
                        header.add(paramsItems);
                        break;
                    }
                    case 2: {
                        query.add(paramsItems);
                        break;
                    }
                    case 1: {
                        result.setBody(paramsItems);
                        break;
                    }
                }
            }
        });
        if (HussarUtils.isNotEmpty(header)) {
            result.setHeader(header);
        }
        if (HussarUtils.isNotEmpty(query)) {
            result.setQuery(query);
        }
        return result;
    }

    public static EaiParamsTestConvertDto toEaiParamsTestConvertDto(String eaiParamsItems) {
        if (HussarUtils.isEmpty((Object)eaiParamsItems)) {
            return null;
        }
        if (eaiParamsItems.startsWith(BRACE)) {
            try {
                return (EaiParamsTestConvertDto)JSON.parseObject((String)eaiParamsItems, EaiParamsTestConvertDto.class);
            }
            catch (Exception e) {
                LOGGER.trace(TRANS_ERROR_MSG, (Throwable)e);
                throw new BaseException(TRANS_ERROR_MSG);
            }
        }
        JSONArray array = JSON.parseArray((String)eaiParamsItems);
        ArrayList<EaiParamsItems> header = new ArrayList<EaiParamsItems>();
        ArrayList<EaiParamsItems> query = new ArrayList<EaiParamsItems>();
        ArrayList<EaiParamsItems> body = new ArrayList<EaiParamsItems>();
        EaiParamsTestConvertDto result = new EaiParamsTestConvertDto();
        array.forEach(obj -> {
            EaiParamsItems paramsItems = (EaiParamsItems)JSON.parseObject((String)ParamsConvertUtil.toJSONString(obj), EaiParamsItems.class);
            Integer map = paramsItems.getMapping();
            if (!HussarUtils.isEmpty((Object)map)) {
                switch (map) {
                    case 0: {
                        header.add(paramsItems);
                        break;
                    }
                    case 2: {
                        query.add(paramsItems);
                        break;
                    }
                    case 1: {
                        body.add(paramsItems);
                        break;
                    }
                }
            }
        });
        if (HussarUtils.isNotEmpty(header)) {
            result.setHeader(header);
        }
        if (HussarUtils.isNotEmpty(query)) {
            result.setQuery(query);
        }
        if (HussarUtils.isNotEmpty(body)) {
            result.setBody(body);
        }
        return result;
    }

    public static String toJSONString(Object t) {
        return JSON.toJSONString((Object)t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    private static JSONObject parseJSONObject(Object t) {
        return JSON.parseObject((String)ParamsConvertUtil.toJSONString(t));
    }

    private static JSONArray parseJSONArray(Object t) {
        return JSON.parseArray((String)ParamsConvertUtil.toJSONString(t));
    }

    private static List<EaiParamsItems> formatEaiParamsItems(EaiParamsConvertDto eaiParamsConvertDto, int pos) {
        if (HussarUtils.isNotEmpty((Object)eaiParamsConvertDto)) {
            switch (pos) {
                case 0: {
                    List<EaiParamsItems> header = eaiParamsConvertDto.getHeader();
                    return ParamsConvertUtil.geEaiParamsItemsList(header, 0);
                }
                case 2: {
                    List<EaiParamsItems> query = eaiParamsConvertDto.getQuery();
                    return ParamsConvertUtil.geEaiParamsItemsList(query, 2);
                }
            }
        }
        return null;
    }

    private static List<EaiParamsItems> formatEaiParamsItems(EaiParamsTestConvertDto eaiParamsConvertDto, int pos) {
        if (HussarUtils.isNotEmpty((Object)eaiParamsConvertDto)) {
            switch (pos) {
                case 0: {
                    List<EaiParamsItems> header = eaiParamsConvertDto.getHeader();
                    return ParamsConvertUtil.geEaiParamsItemsList(header, 0);
                }
                case 2: {
                    List<EaiParamsItems> query = eaiParamsConvertDto.getQuery();
                    return ParamsConvertUtil.geEaiParamsItemsList(query, 2);
                }
                case 1: {
                    List<EaiParamsItems> body = eaiParamsConvertDto.getBody();
                    return ParamsConvertUtil.geEaiParamsItemsList(body, 1);
                }
            }
        }
        return null;
    }

    private static List<EaiParamsItems> geEaiParamsItemsList(List<EaiParamsItems> list, int mapping) {
        if (HussarUtils.isNotEmpty(list)) {
            list.forEach(eaiParamsItems -> eaiParamsItems.setMapping(mapping));
            return list;
        }
        return new ArrayList<EaiParamsItems>();
    }

    public static EaiOutParamDto toEaiOutParamDtoDto(String eaiParamsItems) {
        if (HussarUtils.isEmpty((Object)eaiParamsItems)) {
            return null;
        }
        if (eaiParamsItems.startsWith(BRACE)) {
            try {
                return (EaiOutParamDto)JSON.parseObject((String)eaiParamsItems, EaiOutParamDto.class);
            }
            catch (Exception e) {
                LOGGER.trace(TRANS_ERROR_MSG, (Throwable)e);
                throw new BaseException(TRANS_ERROR_MSG);
            }
        }
        JSONArray array = JSON.parseArray((String)eaiParamsItems);
        ArrayList<EaiParamsItems> body = new ArrayList<EaiParamsItems>();
        EaiOutParamDto result = new EaiOutParamDto();
        array.forEach(obj -> {
            EaiParamsItems paramsItems = (EaiParamsItems)JSON.parseObject((String)ParamsConvertUtil.toJSONString(obj), EaiParamsItems.class);
            body.add(paramsItems);
        });
        if (HussarUtils.isNotEmpty(body)) {
            result.setBody(body);
        }
        return result;
    }

    public static StructureItems toStructureItems(EaiParamsItems item) {
        if (HussarUtils.isNotEmpty((Object)item)) {
            StructureItems structureItems = new StructureItems();
            structureItems.setName(item.getName());
            structureItems.setNickName(item.getName());
            structureItems.setType(item.getType());
            structureItems.setItemType(item.getItemType());
            structureItems.setMark(item.getMark());
            structureItems.setQuoteStructureId("");
            if (HussarUtils.isNotEmpty(item.getItems())) {
                structureItems.setItems(ParamsConvertUtil.toStructureItems(item.getItems()));
            }
            return structureItems;
        }
        return null;
    }

    public static List<StructureItems> toStructureItems(List<EaiParamsItems> items) {
        if (HussarUtils.isNotEmpty(items)) {
            ArrayList<StructureItems> structureItems = new ArrayList<StructureItems>();
            for (EaiParamsItems item : items) {
                StructureItems structureItem = ParamsConvertUtil.toStructureItems(item);
                structureItems.add(structureItem);
            }
            return structureItems;
        }
        return new ArrayList<StructureItems>();
    }

    public static String convertToString(Object value, String type) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            return HussarIntegrationJsonUtils.Contextual.toString((Object)value);
        }
        switch (EaiDataType.getEaiDataType(Integer.parseInt(type))) {
            case DATA_TYPE_BOOLEAN: 
            case DATA_TYPE_INTEGER: 
            case DATA_TYPE_LONG: 
            case DATA_TYPE_DOUBLE: 
            case DATA_TYPE_STRING: 
            case DATA_TYPE_DATE: {
                return (String)HussarIntegrationJsonUtils.Contextual.convert((Object)value, String.class);
            }
        }
        return HussarIntegrationJsonUtils.Contextual.toString((Object)value);
    }

    public static Object parseConstant(String value, String type) {
        if (type == null) {
            return value;
        }
        return ParamsConvertUtil.convertValue(Integer.parseInt(type), value, false);
    }

    public static Object parseDataType(Object value, Integer type, boolean isConfiguration) {
        if (type == null) {
            return value;
        }
        return ParamsConvertUtil.convertValue(type, value, isConfiguration);
    }
}

