/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.common.script.JavaScriptEngine;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Iterator;
import java.util.Optional;
import javax.script.Invocable;

public class EaiFunctionUtil {
    public static final String HTTP_HEADER = "$HEADER.";
    public static final String HTTP_QUERY = "$QUERY.";
    public static final String HTTP_BODY = "$BODY.";
    public static final String HTTP_HEADER_ARRAY = "$HEADER[";
    public static final String HTTP_QUERY_ARRAY = "$QUERY[";
    public static final String HTTP_BODY_ARRAY = "$BODY[";
    private static final String JS_ERROR = "\u89e3\u6790\u5931\u8d25\uff1a";
    private static final String LEFT_L = "[";
    private static final String RIGHT_R = "]";
    private static final String JS_EMPTY = "js\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String JS_FUNC_EMPTY = "\u51fd\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String HEADER = "header";
    private static final String BODY = "body";
    private static final String QUERY = "query";

    public static Object executeJsHttp(String js, Object data) {
        return EaiFunctionUtil.executeJs(js, null, true, data);
    }

    public static Object executeJsFunc(String js, String functionName, Object ... data) {
        return EaiFunctionUtil.executeJs(js, functionName, false, data);
    }

    public static Object executeJs(String js, String functionName, boolean excloudKey, Object ... data) {
        AssertUtil.isNotEmpty((String)js, (String)JS_EMPTY);
        if (js.contains(HTTP_HEADER) || js.contains(HTTP_BODY) || js.contains(HTTP_QUERY)) {
            return EaiFunctionUtil.getHttpValue(js, data[0], excloudKey);
        }
        if (js.contains(HTTP_HEADER_ARRAY) || js.contains(HTTP_BODY_ARRAY) || js.contains(HTTP_QUERY_ARRAY)) {
            return EaiFunctionUtil.getHttpArrayValue(js, data[0], excloudKey);
        }
        if (functionName == null) {
            return js;
        }
        AssertUtil.isNotEmpty((String)functionName, (String)JS_FUNC_EMPTY);
        JavaScriptEngine javaScriptEngine = new JavaScriptEngine();
        try {
            Invocable invocable = (Invocable)javaScriptEngine.eval(js);
            return invocable.invokeFunction(functionName, data);
        }
        catch (Exception e) {
            throw new BaseException(JS_ERROR, (Throwable)e);
        }
    }

    public static Object getHttpArrayValue(String js, Object obj, boolean excloudKey) {
        if (js.startsWith(HTTP_BODY_ARRAY)) {
            return EaiFunctionUtil.getValueFromArray(js, HTTP_BODY_ARRAY, obj, excloudKey);
        }
        if (js.startsWith(HTTP_HEADER_ARRAY)) {
            return EaiFunctionUtil.getValueFromArray(js, HTTP_HEADER_ARRAY, obj, excloudKey);
        }
        if (js.startsWith(HTTP_QUERY_ARRAY)) {
            return EaiFunctionUtil.getValueFromArray(js, HTTP_QUERY_ARRAY, obj, excloudKey);
        }
        throw new BaseException(JS_ERROR);
    }

    private static Object getValueFromArray(String js, String start, Object obj, boolean excloudKey) {
        String index = js.substring(start.length(), js.indexOf(RIGHT_R));
        StringBuilder sb = new StringBuilder(64);
        String method = EaiFunctionUtil.convertMethod(start);
        String position = EaiFunctionUtil.convert(start);
        AssertUtil.isNotEmpty((String)method, (String)JS_ERROR);
        sb.append(method).append(position).append(LEFT_L).append(index).append(js.substring(js.indexOf(RIGHT_R)));
        js = sb.toString();
        JSONObject jsonObject = new JSONObject();
        if (obj instanceof CharSequence) {
            jsonObject.put(position, (Object)JSONArray.parseArray((String)((String)obj)));
        } else {
            jsonObject.put(position, (Object)JSONArray.parseArray((String)JSONObject.toJSONString((Object)obj)));
        }
        return EaiFunctionUtil.getHttpValue(js, jsonObject, excloudKey);
    }

    public static Object getHttpValue(String js, Object obj, boolean excloudKey) {
        JSONObject json;
        if (HussarUtils.isEmpty((Object)obj)) {
            return obj;
        }
        if (obj instanceof CharSequence) {
            try {
                json = JSON.parseObject((String)((String)obj));
            }
            catch (Exception e) {
                throw new BaseException(JS_ERROR);
            }
        }
        try {
            json = JSON.parseObject((String)JSONObject.toJSONString((Object)obj));
        }
        catch (Exception e) {
            throw new BaseException(JS_ERROR);
        }
        return EaiFunctionUtil.getValueFromObject(js, json, excloudKey);
    }

    private static Object getValueFromObject(String js, JSONObject json, boolean excloudKey) {
        if (js.startsWith(HTTP_HEADER)) {
            return EaiFunctionUtil.getObjectPosition(js, HTTP_HEADER, json, excloudKey);
        }
        if (js.startsWith(HTTP_QUERY)) {
            return EaiFunctionUtil.getObjectPosition(js, HTTP_QUERY, json, excloudKey);
        }
        if (js.startsWith(HTTP_BODY)) {
            return EaiFunctionUtil.getObjectPosition(js, HTTP_BODY, json, excloudKey);
        }
        return null;
    }

    private static String convertMethod(String start) {
        switch (start) {
            case "$HEADER[": {
                return HTTP_HEADER;
            }
            case "$QUERY[": {
                return HTTP_QUERY;
            }
            case "$BODY[": {
                return HTTP_BODY;
            }
        }
        throw new BaseException(JS_ERROR);
    }

    private static String convert(String start) {
        switch (start) {
            case "$BODY.": 
            case "$BODY[": {
                return BODY;
            }
            case "$HEADER.": 
            case "$HEADER[": {
                return HEADER;
            }
            case "$QUERY.": 
            case "$QUERY[": {
                return QUERY;
            }
        }
        throw new BaseException(JS_ERROR);
    }

    private static Object getObjectPosition(String js, String start, Object json, boolean excloudKey) {
        if (HussarUtils.isNotEmpty((Object)js) && js.startsWith(start)) {
            if (excloudKey) {
                return EaiFunctionUtil.getObject(js, start, json);
            }
            JSONObject jsonObject = (JSONObject)json;
            if (EaiFunctionUtil.hasKey(jsonObject, start)) {
                try {
                    Object obj = jsonObject.get((Object)EaiFunctionUtil.convert(start));
                    return EaiFunctionUtil.getObject(js, start, obj);
                }
                catch (Exception e) {
                    throw new BaseException(JS_ERROR);
                }
            }
        }
        throw new BaseException(JS_ERROR);
    }

    private static Object getObject(String js, String start, Object obj) {
        if (start != null && js.contains(start)) {
            js = js.substring(start.length());
        }
        String[] jss = js.split("\\.");
        for (int i = 0; i < jss.length; ++i) {
            String key = jss[i];
            if (i < jss.length - 1) {
                if (key.contains(LEFT_L)) {
                    String realKey = key.substring(0, key.indexOf(LEFT_L));
                    String index = key.substring(key.indexOf(LEFT_L) + 1, key.indexOf(RIGHT_R));
                    obj = Optional.of(obj).map(o -> ((JSONObject)o).getJSONArray(realKey)).map(a -> a.get(Integer.valueOf(index).intValue())).orElseThrow(BaseException::new);
                    continue;
                }
                obj = ((JSONObject)obj).getJSONObject(key);
                continue;
            }
            if (!HussarUtils.isNotEmpty((Object)obj)) continue;
            obj = ((JSONObject)obj).get((Object)key);
        }
        return obj;
    }

    private static boolean hasKey(JSONObject json, String start) {
        Iterator<String> keys = json.keySet().iterator();
        switch (start) {
            case "$HEADER.": {
                return EaiFunctionUtil.has(keys, EaiFunctionUtil.convert(HTTP_HEADER));
            }
            case "$QUERY.": {
                return EaiFunctionUtil.has(keys, EaiFunctionUtil.convert(HTTP_QUERY));
            }
            case "$BODY.": {
                return EaiFunctionUtil.has(keys, EaiFunctionUtil.convert(HTTP_BODY));
            }
        }
        return false;
    }

    private static boolean has(Iterator<String> keys, String name) {
        boolean has = false;
        while (keys.hasNext()) {
            if (!name.equals(keys.next().toLowerCase())) continue;
            has = true;
            break;
        }
        return has;
    }
}

