/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.jxdinfo.hussar.platform.core.utils.HexUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.concurrent.atomic.AtomicLong;

public enum EaiCounterUtil {
    INSTANCE;

    private static final String CACHE_KEY = "eai_counter_%s";
    private static final String CACHE_LOCK_KEY = "eai_counter_lock_%s";
    private static final String QUEUE_CACHE_KEY = "eai_queue_%s";
    private static final String QUEUE_CACHE_LOCK_KEY = "eai_queue_lock_%s";

    public static EaiCounterUtil getInstance() {
        return INSTANCE;
    }

    public static long getInstanceCounterNum(String code, long num) {
        return INSTANCE.getCounterNum(code, num);
    }

    public static void getInstanceReduceQueue(String code) {
        INSTANCE.reduceQueue(code);
    }

    private long getCounterNum(String code, long num) {
        code = HexUtil.encodeHexStr((String)code);
        long number = num + 1L;
        boolean locked = false;
        if (!HussarCacheUtil.containKey((String)String.format(CACHE_LOCK_KEY, code), (Object)code)) {
            this.lockCounter(code);
        } else {
            locked = this.getLockCounter(code);
        }
        while (locked) {
            locked = this.getLockCounter(code);
        }
        this.lockCounter(code);
        if (!HussarCacheUtil.containKey((String)String.format(CACHE_KEY, code), (Object)code)) {
            AtomicLong numeric = new AtomicLong(num);
            HussarCacheUtil.put((String)String.format(CACHE_KEY, code), (Object)code, (Object)numeric);
        } else {
            AtomicLong numeric = (AtomicLong)HussarCacheUtil.get((String)String.format(CACHE_KEY, code), (Object)code);
            long increment = numeric.incrementAndGet();
            if (increment < number) {
                numeric = new AtomicLong(number);
            } else {
                number = increment;
            }
            HussarCacheUtil.put((String)String.format(CACHE_KEY, code), (Object)code, (Object)numeric);
        }
        this.unLockCounter(code);
        this.initQueue(code);
        return number;
    }

    private boolean getLockCounter(String code) {
        return (Boolean)HussarCacheUtil.get((String)String.format(CACHE_LOCK_KEY, code), (Object)code);
    }

    private void cleanCounterLock(String code) {
        if (HussarCacheUtil.containKey((String)String.format(CACHE_LOCK_KEY, code), (Object)code)) {
            HussarCacheUtil.evict((String)String.format(CACHE_LOCK_KEY, code), (Object)code);
        }
    }

    private void lockCounter(String code) {
        HussarCacheUtil.put((String)String.format(CACHE_LOCK_KEY, code), (Object)code, (Object)true);
    }

    private void unLockCounter(String code) {
        if (HussarCacheUtil.containKey((String)String.format(CACHE_LOCK_KEY, code), (Object)code)) {
            HussarCacheUtil.put((String)String.format(CACHE_LOCK_KEY, code), (Object)code, (Object)false);
        }
    }

    private boolean getLockQueue(String code) {
        return (Boolean)HussarCacheUtil.get((String)String.format(QUEUE_CACHE_LOCK_KEY, code), (Object)code);
    }

    private void lockQueue(String code) {
        HussarCacheUtil.put((String)String.format(QUEUE_CACHE_LOCK_KEY, code), (Object)code, (Object)true);
    }

    private void unlockQueue(String code) {
        if (HussarCacheUtil.containKey((String)String.format(QUEUE_CACHE_LOCK_KEY, code), (Object)code)) {
            HussarCacheUtil.put((String)String.format(QUEUE_CACHE_LOCK_KEY, code), (Object)code, (Object)false);
        }
    }

    private void cleanQueueLock(String code) {
        if (HussarCacheUtil.containKey((String)String.format(QUEUE_CACHE_LOCK_KEY, code), (Object)code)) {
            HussarCacheUtil.evict((String)String.format(QUEUE_CACHE_LOCK_KEY, code), (Object)code);
        }
    }

    private void initQueue(String code) {
        boolean locked = false;
        if (!HussarCacheUtil.containKey((String)String.format(QUEUE_CACHE_LOCK_KEY, code), (Object)code)) {
            this.lockQueue(code);
        } else {
            locked = this.getLockQueue(code);
        }
        while (locked) {
            locked = this.getLockQueue(code);
        }
        this.lockQueue(code);
        if (!HussarCacheUtil.containKey((String)String.format(QUEUE_CACHE_KEY, code), (Object)code)) {
            AtomicLong numeric = new AtomicLong(1L);
            HussarCacheUtil.put((String)String.format(QUEUE_CACHE_KEY, code), (Object)code, (Object)numeric);
        } else {
            AtomicLong numeric = (AtomicLong)HussarCacheUtil.get((String)String.format(QUEUE_CACHE_KEY, code), (Object)code);
            numeric.incrementAndGet();
            HussarCacheUtil.put((String)String.format(QUEUE_CACHE_KEY, code), (Object)code, (Object)numeric);
        }
        this.unlockQueue(code);
    }

    public void cleanCounter(String code) {
        this.lockCounter(code);
        HussarCacheUtil.evict((String)String.format(CACHE_KEY, code), (Object)code);
        this.cleanCounterLock(code);
    }

    private void reduceQueue(String code) {
        code = HexUtil.encodeHexStr((String)code);
        this.lockQueue(code);
        if (HussarCacheUtil.containKey((String)String.format(QUEUE_CACHE_KEY, code), (Object)code)) {
            AtomicLong numeric = (AtomicLong)HussarCacheUtil.get((String)String.format(QUEUE_CACHE_KEY, code), (Object)code);
            long num = numeric.decrementAndGet();
            if (num <= 0L) {
                HussarCacheUtil.evict((String)String.format(QUEUE_CACHE_KEY, code), (Object)code);
                this.cleanCounter(code);
                this.cleanQueueLock(code);
            } else {
                HussarCacheUtil.put((String)String.format(QUEUE_CACHE_KEY, code), (Object)code, (Object)numeric);
            }
        }
        this.unlockQueue(code);
    }
}

