/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.jxdinfo.hussar.eai.common.util.EaiConvertPinYinUtil;
import com.jxdinfo.hussar.platform.core.utils.CharsetUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EaiCharSetUtil
extends CharsetUtil
implements Serializable {
    public static final String GB2312 = "gb2312";
    public static final String ASCII = "US-ASCII";
    public static final Charset CHARSET_ASCII;
    public static final Charset CHARSET_GB2312;
    private static final Pattern STRUCTURECODE_COMPILE;
    private static final Pattern CHINESE_COMPILE;
    private static final Pattern SPECIAL_SYMBOLS_COMPILE;

    public static String checkConvertStructureCode(String structureCode) {
        if (!STRUCTURECODE_COMPILE.matcher(structureCode).find()) {
            if (CHINESE_COMPILE.matcher(structureCode = structureCode.replaceAll(" ", "")).find()) {
                structureCode = EaiConvertPinYinUtil.convertHanzi2Pinyin(structureCode, false);
            }
            if (SPECIAL_SYMBOLS_COMPILE.matcher(structureCode).find()) {
                Matcher matcher = SPECIAL_SYMBOLS_COMPILE.matcher(structureCode);
                structureCode = matcher.replaceAll("_");
            }
        }
        return structureCode;
    }

    public static String checkConvertMappingName(String mappingName) {
        if (!STRUCTURECODE_COMPILE.matcher(mappingName).find()) {
            if (mappingName.contains("[0]")) {
                mappingName = mappingName.replaceAll("\\[0\\]", "0");
            }
            Matcher m = Pattern.compile("\\.(\\w(?:'\\w)*)").matcher(mappingName);
            StringBuffer stringBuffer = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(stringBuffer, m.group(1).toUpperCase());
            }
            m.appendTail(stringBuffer);
            mappingName = stringBuffer.toString();
            if (SPECIAL_SYMBOLS_COMPILE.matcher(mappingName).find()) {
                Matcher matcher = SPECIAL_SYMBOLS_COMPILE.matcher(mappingName);
                mappingName = matcher.replaceAll("_");
            }
        }
        return mappingName;
    }

    static {
        STRUCTURECODE_COMPILE = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
        CHINESE_COMPILE = Pattern.compile("[\u4e00-\u9fa5]");
        SPECIAL_SYMBOLS_COMPILE = Pattern.compile("[~!/@#$%^&*()\\-=+\\\\|[{}];:\\'\\\",<.>/?\u201c\u201d\u2018\u2019\u301d \"'\uff02\uff07\u00b4\uff07\u3010\u3011\u300a\u300b\uff1c\uff1e\ufe5d\ufe5e<>\u00ab\u00bb]");
        Charset _CHARSET_GB2312 = null;
        Charset _CHARSET_ASCII = null;
        try {
            _CHARSET_GB2312 = Charset.forName(GB2312);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        CHARSET_GB2312 = _CHARSET_GB2312;
        try {
            _CHARSET_ASCII = Charset.forName(ASCII);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        CHARSET_ASCII = _CHARSET_ASCII;
    }
}

