/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.constant.logic;

import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EaiLogicConstant {
    public static final String PACKAGE_PREFIX = "com.jxdinfo.hussar.eai.generated";
    public static final String APP_PREFIX = "app_";
    public static final String TYPE_OPEN = "open";
    public static final String TYPE_INTEGRATION = "integration";
    public static final String DEBUG = "debug";
    public static final String ERROR = "error";
    public static final String EXCEPTION_MESSAGE = "exceptionMessage";
    public static final String JAVA_STACKTRACE = "javaStacktrace";
    private static final Pattern pattern = Pattern.compile("[^a-zA-Z0-9_]");
    private static final Pattern LESS_STRICT_IDENTIFIER = Pattern.compile("^[a-zA-Z_-][a-zA-Z0-9_-]*$");
    private static final Pattern IDENTIFIER_WORDS_SEPARATOR = Pattern.compile("[_-]+");

    private EaiLogicConstant() {
    }

    public static final String getOpenPackageName(String appCode, EaiResourcesEnum resourcesEnum, String code) {
        return EaiLogicConstant.getOpenPackageName(appCode, resourcesEnum, code, null);
    }

    public static String getReplaceCode(String code) {
        Matcher matcher = pattern.matcher(code);
        if (matcher.find()) {
            return matcher.replaceAll("");
        }
        return code;
    }

    public static final String getOpenPackageName(String appCode, EaiResourcesEnum resourcesEnum, String code, String version) {
        String codeName = EaiLogicConstant.identifierToClassName(EaiLogicConstant.getReplaceCode(code));
        String appCodeName = EaiLogicConstant.getReplaceCode(appCode);
        if (HussarUtils.isEmpty((Object)version)) {
            return String.format("%s.%s.%s%s.%s.%s", PACKAGE_PREFIX, TYPE_OPEN, APP_PREFIX, appCodeName.toLowerCase(), resourcesEnum.getType(), codeName);
        }
        return String.format("%s.%s.%s%s.%s.%s.%s", PACKAGE_PREFIX, TYPE_OPEN, APP_PREFIX, appCodeName.toLowerCase(), version, resourcesEnum.getType(), codeName);
    }

    public static final String getIntegrationPackageName(String appCode, EaiResourcesEnum resourcesEnum, String code) {
        String codeName = EaiLogicConstant.identifierToClassName(EaiLogicConstant.getReplaceCode(code));
        String appCodeName = EaiLogicConstant.getReplaceCode(appCode);
        return String.format("%s.%s.%s%s.%s.%s", PACKAGE_PREFIX, TYPE_INTEGRATION, APP_PREFIX, appCodeName, resourcesEnum.getType(), codeName);
    }

    public static final String getAppName(String appCode) {
        return String.format("%s%s", APP_PREFIX, EaiLogicConstant.getReplaceCode(appCode.toLowerCase()));
    }

    public static final String getNameSpace(String className) {
        className = className.substring(0, className.lastIndexOf("."));
        return className.substring(0, className.lastIndexOf("."));
    }

    public static String getType(String className) {
        return className.substring(PACKAGE_PREFIX.length() + 1).split("\\.")[2];
    }

    public static String getCategory(String className) {
        return className.substring(PACKAGE_PREFIX.length() + 1).split("\\.")[0];
    }

    public static String getCategoryByClassify(String classify) {
        if ("0".equals(classify)) {
            return TYPE_OPEN;
        }
        return TYPE_INTEGRATION;
    }

    public static String identifierToClassName(String identifier) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        if (!LESS_STRICT_IDENTIFIER.matcher(identifier).matches()) {
            throw new IllegalArgumentException();
        }
        return Arrays.stream(IDENTIFIER_WORDS_SEPARATOR.split(identifier)).filter(StringUtils::isNotEmpty).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining());
    }
}

