/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EaiApiClassification;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiClassificationService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiClassifyDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiInfoDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppInfoDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsItem;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsOut;
import com.jxdinfo.hussar.eai.sysapi.api.dto.StructureDto;
import com.jxdinfo.hussar.eai.sysapi.api.service.SysImportService;
import com.jxdinfo.hussar.eai.sysapi.server.service.impl.ImportCommonServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.sysapi.server.service.impl.SysImportServiceImpl")
public class SysImportServiceImpl
extends ImportCommonServiceImpl
implements SysImportService {
    @Resource
    IEaiApiClassificationService eaiApiClassificationService;
    @Resource
    ICommonStructureService commonStructureService;
    @Resource
    EaiApiProperties eaiApiProperties;
    @Resource
    IReleaseApiService releaseApiService;

    public Boolean importSys(List<AppInfoDto> appInfoDtos) {
        if (HussarUtils.isNotEmpty(appInfoDtos)) {
            for (AppInfoDto appInfoDto : appInfoDtos) {
                List apiInfos;
                String appCode = appInfoDto.getAppCode();
                this.createNewApp(appCode);
                List structureDtos = appInfoDto.getStructures();
                HashMap<Long, Long> structureIdsMap = new HashMap<Long, Long>();
                if (HussarUtils.isNotEmpty((Object)structureDtos)) {
                    List<CommonStructure> commonStructures = this.toCommonStructure(structureDtos, appCode, structureIdsMap);
                    this.commonStructureService.saveBatch(commonStructures);
                }
                List apiClassifyDtos = appInfoDto.getApiClassificList();
                HashMap<Long, Long> classifyIdsMap = new HashMap<Long, Long>();
                if (HussarUtils.isNotEmpty((Object)apiClassifyDtos)) {
                    List<EaiApiClassification> apiClassifications = this.toClassify(apiClassifyDtos, appCode, classifyIdsMap);
                    this.eaiApiClassificationService.saveBatch(apiClassifications);
                }
                if (!HussarUtils.isNotEmpty((Object)(apiInfos = appInfoDto.getApiInfos()))) continue;
                for (ApiInfoDto apiInfo : apiInfos) {
                    this.saveApi(appCode, apiInfo, structureIdsMap, classifyIdsMap);
                }
            }
        }
        return true;
    }

    private List<CommonStructure> toCommonStructure(List<StructureDto> structureDtos, String appCode, Map<Long, Long> map) {
        ArrayList<CommonStructure> commonStructures = new ArrayList<CommonStructure>();
        for (StructureDto structureDto : structureDtos) {
            Long id;
            CommonStructure commonStructure = new CommonStructure();
            BeanUtil.copyProperties((Object)structureDto, (Object)commonStructure);
            commonStructure.setApplicationCode(appCode);
            if (map.containsKey(structureDto.getId())) {
                id = map.get(structureDto.getId());
            } else {
                id = EngineUtil.getId();
                map.put(structureDto.getId(), id);
            }
            commonStructure.setId(id);
            List<StructureItems> items = this.toStructureItems(structureDto.getItems(), map);
            commonStructure.setStructureValues(JSON.toJSONString(items));
            commonStructures.add(commonStructure);
        }
        return commonStructures;
    }

    private List<StructureItems> toStructureItems(List<com.jxdinfo.hussar.eai.sysapi.api.dto.StructureItems> structureItems, Map<Long, Long> map) {
        ArrayList<StructureItems> structureItemsList = new ArrayList<StructureItems>();
        for (com.jxdinfo.hussar.eai.sysapi.api.dto.StructureItems structureItem : structureItems) {
            Long id;
            StructureItems item = new StructureItems();
            BeanUtil.copyProperties((Object)structureItem, (Object)item);
            String qid = structureItem.getQuoteStructureId();
            if (HussarUtils.isNotEmpty((Object)qid) && !map.containsKey(id = Long.valueOf(qid))) {
                Long newId = EngineUtil.getId();
                map.put(id, newId);
                item.setQuoteStructureId(String.valueOf(newId));
            }
            if (HussarUtils.isNotEmpty((Object)structureItem.getItems())) {
                List<StructureItems> newItems = this.toStructureItems(structureItem.getItems(), map);
                item.setItems(newItems);
            }
            structureItemsList.add(item);
        }
        return structureItemsList;
    }

    private List<EaiApiClassification> toClassify(List<ApiClassifyDto> apiClassifyDtos, String appCode, Map<Long, Long> map) {
        ArrayList<EaiApiClassification> classifications = new ArrayList<EaiApiClassification>();
        for (ApiClassifyDto apiClassifyDto : apiClassifyDtos) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiClassification::getApplicationCode, (Object)appCode)).eq(EaiApiClassification::getClassificName, (Object)apiClassifyDto.getClassificName());
            EaiApiClassification eaiApiClassification = (EaiApiClassification)this.eaiApiClassificationService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)eaiApiClassification)) {
                Long id;
                eaiApiClassification = new EaiApiClassification();
                BeanUtil.copyProperties((Object)apiClassifyDto, (Object)eaiApiClassification);
                if (map.containsKey(apiClassifyDto.getClassificId())) {
                    id = map.get(apiClassifyDto.getClassificId());
                } else {
                    id = EngineUtil.getId();
                    map.put(apiClassifyDto.getClassificId(), id);
                }
                eaiApiClassification.setId(id);
                classifications.add(eaiApiClassification);
                continue;
            }
            map.put(apiClassifyDto.getClassificId(), eaiApiClassification.getId());
        }
        return classifications;
    }

    private void saveApi(String appCode, ApiInfoDto apiInfoDto, Map<Long, Long> structureIdsMap, Map<Long, Long> classifyIdsMap) {
        List<EaiParamsItems> eaiParamsItems;
        AddApiInfoDto addApiInfoDto = new AddApiInfoDto();
        BeanUtil.copyProperties((Object)apiInfoDto, (Object)addApiInfoDto);
        addApiInfoDto.setHttpMethod(this.getMethod(apiInfoDto.getRequestType()));
        Long apiId = EngineUtil.getId();
        addApiInfoDto.setId(String.valueOf(apiId));
        addApiInfoDto.setApiType("0");
        EaiApiParams apiInParams = apiInfoDto.getInParams();
        if (HussarUtils.isNotEmpty((Object)apiInParams)) {
            List query;
            List header;
            ArrayList params = new ArrayList();
            List body = apiInParams.getBody();
            EaiParamsConvertDto eaiParamsConvertDto = new EaiParamsConvertDto();
            if (HussarUtils.isNotEmpty((Object)body)) {
                if (body.size() > 1) {
                    throw new BaseException("Body\u5165\u53c2\u7c7b\u578b\u53ea\u652f\u6301\u6570\u636e\u7ed3\u6784\u6216List");
                }
                eaiParamsItems = this.toParams(1, body, structureIdsMap);
                eaiParamsConvertDto.setBody(eaiParamsItems.get(0));
            }
            if (HussarUtils.isNotEmpty((Object)(header = apiInParams.getHeader()))) {
                List<EaiParamsItems> eaiParamsItems2 = this.toParams(0, header, structureIdsMap);
                eaiParamsConvertDto.setHeader(eaiParamsItems2);
            }
            if (HussarUtils.isNotEmpty((Object)(query = apiInParams.getQuery()))) {
                List<EaiParamsItems> eaiParamsItems3 = this.toParams(2, query, structureIdsMap);
                eaiParamsConvertDto.setQuery(eaiParamsItems3);
            }
            addApiInfoDto.setInParams(eaiParamsConvertDto);
        }
        EaiApiParamsOut apiOutParams = apiInfoDto.getOutParams();
        EaiParamsConvertDto out = new EaiParamsConvertDto();
        List outParams = apiOutParams.getBody();
        if (HussarUtils.isNotEmpty((Object)outParams)) {
            if (outParams.size() > 1) {
                throw new BaseException("\u8fd4\u56de\u53c2\u6570\u7c7b\u578b\u53ea\u652f\u6301\u6570\u636e\u7ed3\u6784\u6216List");
            }
            eaiParamsItems = this.toParams(1, outParams, structureIdsMap);
            out.setBody(eaiParamsItems.get(0));
        }
        addApiInfoDto.setOutParams(out);
        Long classifyId = apiInfoDto.getClassificId();
        if (HussarUtils.isNotEmpty((Object)classifyId) && classifyIdsMap.containsKey(classifyId)) {
            addApiInfoDto.setClassificId(classifyIdsMap.get(classifyId));
        }
        addApiInfoDto.setApplicationCode(appCode);
        addApiInfoDto.setTestState("0");
        addApiInfoDto.setPublicState("1");
        this.releaseApiService.saveApiInfo(addApiInfoDto);
    }

    private List<EaiParamsItems> toParams(Integer mappping, List<EaiApiParamsItem> apiParamsItems, Map<Long, Long> structureIdsMap) {
        ArrayList<EaiParamsItems> eaiApiParams = new ArrayList<EaiParamsItems>();
        if (HussarUtils.isNotEmpty(apiParamsItems)) {
            for (EaiApiParamsItem apiParamsItem : apiParamsItems) {
                EaiParamsItems apiParams = new EaiParamsItems();
                BeanUtil.copyProperties((Object)apiParamsItem, (Object)apiParams);
                apiParams.setMapping(mappping);
                apiParams.setMappingName(apiParamsItem.getName());
                apiParams.setValue(String.valueOf(apiParams.getType()));
                if (HussarUtils.isNotEmpty((Object)apiParamsItem.getQuoteStructureId()) && structureIdsMap.containsKey(apiParamsItem.getQuoteStructureId())) {
                    apiParams.setQuoteStructureId(String.valueOf(structureIdsMap.get(apiParamsItem.getQuoteStructureId())));
                    apiParams.setValue(String.valueOf(structureIdsMap.get(apiParamsItem.getQuoteStructureId())));
                }
                if (HussarUtils.isNotEmpty((Object)apiParamsItem.getItems())) {
                    List<EaiParamsItems> items = this.toParams(mappping, apiParamsItem.getItems(), structureIdsMap);
                    apiParams.setItems(items);
                }
                eaiApiParams.add(apiParams);
            }
        }
        return eaiApiParams;
    }

    private String getMethod(String type) {
        switch (type) {
            case "1": {
                return "GET";
            }
            case "2": {
                return "PUT";
            }
        }
        return "POST";
    }
}

