/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppPublishDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.SwaggerDto;
import com.jxdinfo.hussar.eai.sysapi.api.service.ImportHttpService;
import com.jxdinfo.hussar.eai.sysapi.api.service.SwaggerImportService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.sysapi.server.service.impl.ImportHttpServiceImpl")
public class ImportHttpServiceImpl
implements ImportHttpService {
    private static final Integer SWAGGER_TYPE = 1;
    private static final Integer SWAGGER_TYPE_FILE = 0;
    private static final Integer SWAGGER_TYPE_JSON = 1;
    private static final Integer SYS_TYPE = 2;
    @Resource
    SwaggerImportService swaggerImportService;

    private static final String formatFileErr(String name) {
        return String.format("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u540d:%s", name);
    }

    private static final String formatJsonErr(String name) {
        return String.format("\u5bfc\u5165JSON SCHEMA\u5931\u8d25:%s", name);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> push(AppPublishDto appPublishDto) {
        List swaggerDtoList;
        if (SWAGGER_TYPE.equals(appPublishDto.getImportType()) && HussarUtils.isNotEmpty((Object)(swaggerDtoList = appPublishDto.getSwaggerDtos()))) {
            for (SwaggerDto swaggerDto : swaggerDtoList) {
                boolean b;
                if (SWAGGER_TYPE_FILE.equals(swaggerDto.getSwaggerType())) {
                    b = this.swaggerImportService.importFile(swaggerDto.getAppCode(), swaggerDto.getHussarFile());
                    if (b) continue;
                    throw new BaseException(ImportHttpServiceImpl.formatFileErr(swaggerDto.getHussarFile().getName()));
                }
                if (SWAGGER_TYPE_JSON.equals(swaggerDto.getSwaggerType())) {
                    b = this.swaggerImportService.importJson(swaggerDto.getAppCode(), swaggerDto.getHussarFileJson());
                    if (b) continue;
                    throw new BaseException(ImportHttpServiceImpl.formatJsonErr(String.valueOf(swaggerDto.getHussarFileJson())));
                }
                if (HussarUtils.isNotEmpty((Object)swaggerDto.getHussarFile()) && !(b = this.swaggerImportService.importFile(swaggerDto.getAppCode(), swaggerDto.getHussarFile()).booleanValue())) {
                    throw new BaseException(ImportHttpServiceImpl.formatFileErr(swaggerDto.getHussarFile().getName()));
                }
                if (!HussarUtils.isNotEmpty((Object)swaggerDto.getHussarFileJson()) || (b = this.swaggerImportService.importJson(swaggerDto.getAppCode(), swaggerDto.getHussarFileJson()).booleanValue())) continue;
                throw new BaseException(ImportHttpServiceImpl.formatJsonErr(String.valueOf(swaggerDto.getHussarFileJson())));
            }
            return ApiResponse.fail((String)"\u4e0d\u652f\u6301\u7684\u5bfc\u5165\u7c7b\u578b");
        }
        if (SYS_TYPE.equals(appPublishDto.getImportType())) {
            appPublishDto.getAppInfoDtos();
        }
        return ApiResponse.fail((String)String.format("\u4e0d\u652f\u6301\u7684\u5bfc\u5165\u7c7b\u578b:%s", appPublishDto.getImportType()));
    }
}

