/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiClassificationVersion;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IEaiApiClassificationVersionService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiParamsTestConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiClassifyDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiInfoDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiVersionQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppApiSyncDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppInfoDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppQueryKeyword;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppSyncDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsItem;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsOut;
import com.jxdinfo.hussar.eai.sysapi.api.dto.Page;
import com.jxdinfo.hussar.eai.sysapi.api.dto.StructureDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.StructureItems;
import com.jxdinfo.hussar.eai.sysapi.api.service.EaiAppQueryService;
import com.jxdinfo.hussar.eai.sysapi.server.dao.ApiQueryMapper;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.sysapi.server.service.impl.EaiAppQueryServiceImpl")
public class EaiAppQueryServiceImpl
implements EaiAppQueryService {
    @Resource
    ISysApplicationService sysApplicationService;
    @Resource
    protected IEaiApiClassificationVersionService eaiApiClassificationVersionService;
    @Resource
    protected IApiVersionService apiVersionService;
    @Resource
    protected IStructureVersionService structureVersionService;
    @Resource
    protected IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private ApiQueryMapper apiQueryMapper;
    private static final String CLASSIFIC_ID_KEY = "classificId";
    private static final String CLASSIFIC_NAME_KEY = "classificName";
    private static final Long CLASSIFIC_ID_DEFAULT = 0L;
    private static final String CLASSIFIC_NAME_DEFAULT = "\u9ed8\u8ba4\u7c7b\u578b";
    private static final String APP_STATUS_ENABLED = "1";
    private static final String APP_STATUS_APPLYING = "2";
    @Resource
    private ISysClientModelService sysClientModelService;
    @Resource
    private ISysAppClientService sysAppClientService;
    @Resource
    private ISysClientPermissionService iSysClientPermissionService;
    @Resource
    private ISysResourcesService sysResourcesService;
    private static final String OBJECT_STR = "Object";

    public List<AppInfoDto> getAppDetailList(AppSyncDto apiQuery) {
        ArrayList<AppInfoDto> list = new ArrayList<AppInfoDto>(0);
        List<SysResources> sysResources = this.getResourceList(apiQuery.getClientId());
        List<String> appCodes = this.getAuthedAppByResources(sysResources);
        List<String> queryCodes = this.getQueryAppCodes(appCodes, apiQuery.getAppQueryKeyword());
        Map<String, AppQueryKeyword> queryKeywordMap = this.getAppQueryMap(apiQuery.getAppQueryKeyword());
        Page<AppInfoDto> page = this.getAppInfoPage(queryCodes, apiQuery);
        if (HussarUtils.isNotEmpty((Object)page.getRecords())) {
            List<ApiInfoDto> apiInfoDtoList = this.getApiInfoDtosByResources(sysResources, queryCodes, queryKeywordMap, true);
            List applications = page.getRecords();
            for (AppInfoDto application : applications) {
                String appCode = application.getAppCode();
                ArrayList<ApiInfoDto> apiList = new ArrayList<ApiInfoDto>();
                for (ApiInfoDto apiInfoDto : apiInfoDtoList) {
                    if (!appCode.equals(apiInfoDto.getAppCode())) continue;
                    apiList.add(apiInfoDto);
                }
                application.setApiInfos(apiList);
                list.add(application);
            }
        }
        return list;
    }

    public List<AppInfoDto> getAppDetailListNoParams(AppSyncDto appSyncDto) {
        ArrayList<AppInfoDto> list = new ArrayList<AppInfoDto>(0);
        List<SysResources> sysResources = this.getResourceList(appSyncDto.getClientId());
        List<String> appCodes = this.getAuthedAppByResources(sysResources);
        List<String> queryCodes = this.getQueryAppCodes(appCodes, appSyncDto.getAppQueryKeyword());
        Map<String, AppQueryKeyword> queryKeywordMap = this.getAppQueryMap(appSyncDto.getAppQueryKeyword());
        Page<AppInfoDto> page = this.getAppInfoPage(queryCodes, appSyncDto);
        if (HussarUtils.isNotEmpty((Object)page.getRecords())) {
            List<ApiInfoDto> apiInfoDtoList = this.getApiInfoDtosByResources(sysResources, appCodes, queryKeywordMap, false);
            List applications = page.getRecords();
            for (AppInfoDto application : applications) {
                String appCode = application.getAppCode();
                ArrayList<ApiInfoDto> apiList = new ArrayList<ApiInfoDto>();
                for (ApiInfoDto apiInfoDto : apiInfoDtoList) {
                    if (!appCode.equals(apiInfoDto.getAppCode())) continue;
                    apiList.add(apiInfoDto);
                }
                application.setApiInfos(apiList);
                list.add(application);
            }
        }
        return list;
    }

    public List<AppInfoDto> getAppDetailClassifyListNoParams(AppSyncDto appSyncDto) {
        ArrayList<AppInfoDto> list = new ArrayList<AppInfoDto>(0);
        List<SysResources> sysResources = this.getResourceList(appSyncDto.getClientId());
        List<String> appCodes = this.getAuthedAppByResources(sysResources);
        List<String> queryCodes = this.getQueryAppCodes(appCodes, appSyncDto.getAppQueryKeyword());
        Map<String, AppQueryKeyword> queryKeywordMap = this.getAppQueryMap(appSyncDto.getAppQueryKeyword());
        Page<AppInfoDto> page = this.getAppInfoPage(queryCodes, appSyncDto);
        if (HussarUtils.isNotEmpty((Object)page.getRecords())) {
            List<ApiInfoDto> apiInfoDtoList = this.getApiInfoDtosByResources(sysResources, appCodes, queryKeywordMap, false);
            List<ApiClassifyDto> apiClassifyDtoList = this.getApiClassifyDtosByAppCodes(queryCodes, apiInfoDtoList);
            List applications = page.getRecords();
            for (AppInfoDto application : applications) {
                this.setApplicationClassifics(application, apiInfoDtoList, apiClassifyDtoList);
                list.add(application);
            }
        }
        return list;
    }

    public List<ApiInfoDto> getAppDetailApiList(AppApiSyncDto appSyncDto) {
        List<ApiInfoDto> list = new ArrayList<ApiInfoDto>(0);
        List<SysResources> sysResources = this.getResourceList(appSyncDto.getClientId());
        List<String> appCodes = this.getAuthedAppByResources(sysResources);
        Map<String, AppQueryKeyword> queryKeywordMap = this.getAppQueryMap(appSyncDto.getAppQueryKeyword());
        if (HussarUtils.isNotEmpty((Object)appSyncDto.getApiIds())) {
            list = this.getApiInfoDtosByApiIds(sysResources, appCodes, queryKeywordMap, appSyncDto.getApiIds());
        }
        return list;
    }

    public Page<AppInfoDto> getAppDetailApiPageList(AppSyncDto appSyncDto) {
        List<SysResources> sysResources = this.getResourceList(appSyncDto.getClientId());
        List<String> appCodes = this.getAuthedAppByResources(sysResources);
        List<String> queryCodes = this.getQueryAppCodes(appCodes, appSyncDto.getAppQueryKeyword());
        Map<String, AppQueryKeyword> queryKeywordMap = this.getAppQueryMap(appSyncDto.getAppQueryKeyword());
        Page<AppInfoDto> page = this.getAppInfoPage(queryCodes, appSyncDto);
        if (HussarUtils.isNotEmpty((Object)page.getRecords())) {
            List<ApiInfoDto> apiInfoDtoList = this.getApiInfoDtosByResources(sysResources, appCodes, queryKeywordMap, true);
            List applications = page.getRecords();
            for (AppInfoDto application : applications) {
                String appCode = application.getAppCode();
                ArrayList<ApiInfoDto> apiList = new ArrayList<ApiInfoDto>();
                for (ApiInfoDto apiInfoDto : apiInfoDtoList) {
                    if (!appCode.equals(apiInfoDto.getAppCode())) continue;
                    apiList.add(apiInfoDto);
                }
                application.setApiInfos(apiList);
            }
        }
        return page;
    }

    public Page<AppInfoDto> getAppDetailClassifyPageList(AppSyncDto appSyncDto) {
        List<SysResources> sysResources = this.getResourceList(appSyncDto.getClientId());
        List<String> appCodes = this.getAuthedAppByResources(sysResources);
        List<String> queryCodes = this.getQueryAppCodes(appCodes, appSyncDto.getAppQueryKeyword());
        Map<String, AppQueryKeyword> queryKeywordMap = this.getAppQueryMap(appSyncDto.getAppQueryKeyword());
        Page<AppInfoDto> page = this.getAppInfoPage(queryCodes, appSyncDto);
        if (HussarUtils.isNotEmpty((Object)page.getRecords())) {
            List<ApiInfoDto> apiInfoDtoList = this.getApiInfoDtosByResources(sysResources, appCodes, queryKeywordMap, true);
            List<ApiClassifyDto> apiClassifyDtoList = this.getApiClassifyDtosByAppCodes(queryCodes, apiInfoDtoList);
            List applications = page.getRecords();
            for (AppInfoDto application : applications) {
                this.setApplicationClassifics(application, apiInfoDtoList, apiClassifyDtoList);
            }
        }
        return page;
    }

    private void setApplicationClassifics(AppInfoDto application, List<ApiInfoDto> apiInfoDtoList, List<ApiClassifyDto> apiClassifyDtoList) {
        String appCode = application.getAppCode();
        ArrayList<ApiClassifyDto> classifyDtoList = new ArrayList<ApiClassifyDto>();
        for (ApiClassifyDto classifyDto : apiClassifyDtoList) {
            if (!appCode.equals(classifyDto.getAppCode())) continue;
            classifyDtoList.add(classifyDto);
        }
        ApiClassifyDto defaultClassify = new ApiClassifyDto();
        defaultClassify.setClassificId(CLASSIFIC_ID_DEFAULT);
        defaultClassify.setClassificName(CLASSIFIC_NAME_DEFAULT);
        defaultClassify.setAppCode(appCode);
        ArrayList<ApiInfoDto> defaultApiInfoList = new ArrayList<ApiInfoDto>();
        for (ApiInfoDto apiInfoDto : apiInfoDtoList) {
            if (!CLASSIFIC_ID_DEFAULT.equals(apiInfoDto.getClassificId()) || !appCode.equals(apiInfoDto.getAppCode())) continue;
            defaultApiInfoList.add(apiInfoDto);
        }
        defaultClassify.setApiList(defaultApiInfoList);
        classifyDtoList.add(defaultClassify);
        application.setApiClassificList(classifyDtoList);
    }

    public Page<AppInfoDto> listAppInfos(AppSyncDto appSyncDto) {
        List<String> appCodes = this.getAuthedApp(appSyncDto.getClientId());
        List<String> queryCodes = this.getQueryAppCodes(appCodes, appSyncDto.getAppQueryKeyword());
        return this.getAppInfoPage(queryCodes, appSyncDto);
    }

    private Page<AppInfoDto> getAppInfoPage(List<String> appCodes, AppSyncDto appSyncDto) {
        Page pageDto = new Page();
        if (HussarUtils.isEmpty(appCodes)) {
            return pageDto;
        }
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        if (appSyncDto.getPage().booleanValue()) {
            page.setCurrent(appSyncDto.getCurrent().longValue());
            page.setSize(appSyncDto.getSize().longValue());
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysApplication::getAppCode, appCodes);
        queryWrapper.and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(SysApplication::getAppStatus, (Object)APP_STATUS_ENABLED)).or()).eq(SysApplication::getAppStatus, (Object)APP_STATUS_APPLYING);
        });
        com.baomidou.mybatisplus.extension.plugins.pagination.Page sysApplications = (com.baomidou.mybatisplus.extension.plugins.pagination.Page)this.sysApplicationService.page((IPage)page, (Wrapper)queryWrapper);
        List records = sysApplications.getRecords();
        pageDto.setCurrent(Long.valueOf(sysApplications.getCurrent()));
        pageDto.setSize(Long.valueOf(sysApplications.getSize()));
        pageDto.setTotal(Long.valueOf(sysApplications.getTotal()));
        if (HussarUtils.isNotEmpty((Object)records)) {
            ArrayList<AppInfoDto> list = new ArrayList<AppInfoDto>();
            for (SysApplication application : records) {
                list.add(this.getAppInfoDtoFromApp(application));
            }
            pageDto.setRecords(list);
        }
        return pageDto;
    }

    private AppInfoDto getAppInfoDtoFromApp(SysApplication application) {
        AppInfoDto appInfoDto = new AppInfoDto();
        appInfoDto.setId(String.valueOf(application.getId()));
        appInfoDto.setAppName(application.getAppName());
        appInfoDto.setAppCode(application.getAppCode());
        appInfoDto.setAppIconType(application.getAppIconType());
        appInfoDto.setAppIcon(application.getAppIcon());
        appInfoDto.setAppIconColor(application.getAppIconColor());
        return appInfoDto;
    }

    private List<String> getQueryAppCodes(List<String> appCodes, List<AppQueryKeyword> queryKeywords) {
        if (ToolUtil.isEmpty(queryKeywords) || ToolUtil.isEmpty(appCodes)) {
            return appCodes;
        }
        ArrayList<String> finalAppCodes = new ArrayList<String>();
        List queryAppCodes = queryKeywords.stream().map(AppQueryKeyword::getAppCode).collect(Collectors.toList());
        for (String appCode : appCodes) {
            if (!queryAppCodes.contains(appCode)) continue;
            finalAppCodes.add(appCode);
        }
        return finalAppCodes;
    }

    private Map<String, AppQueryKeyword> getAppQueryMap(List<AppQueryKeyword> queryKeywords) {
        if (ToolUtil.isEmpty(queryKeywords)) {
            return new HashMap<String, AppQueryKeyword>();
        }
        return queryKeywords.stream().collect(Collectors.toMap(AppQueryKeyword::getAppCode, Function.identity()));
    }

    public List<String> getAuthedApp(String clientId) {
        List<SysResources> sysResources = this.getResourceList(clientId);
        return this.getAuthedAppByResources(sysResources);
    }

    private List<String> getAuthedAppByResources(List<SysResources> sysResources) {
        if (HussarUtils.isNotEmpty(sysResources)) {
            List pathList = sysResources.stream().map(SysResources::getUrlNames).collect(Collectors.toList());
            ArrayList<String> list = new ArrayList<String>();
            for (String path : pathList) {
                String appCode = path.split("/")[1];
                if (list.contains(appCode)) continue;
                list.add(appCode);
            }
            return list;
        }
        return null;
    }

    private List<SysResources> getResourceList(String clientId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysClientPermission::getClientId, (Object)clientId);
        List permissions = this.iSysClientPermissionService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)permissions)) {
            List pids = permissions.stream().map(SysClientPermission::getPermissionId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysResources::getId, pids);
            return this.sysResourcesService.list((Wrapper)lambdaQueryWrapper);
        }
        return new ArrayList<SysResources>();
    }

    private List<EaiApiVersion> getApiVersionListByResources(List<SysResources> resourceList, List<String> appCodes, Map<String, AppQueryKeyword> queryKeywordMap) {
        if (ToolUtil.isEmpty(resourceList) || ToolUtil.isEmpty(appCodes)) {
            return new ArrayList<EaiApiVersion>();
        }
        List apiPathList = resourceList.stream().map(SysResources::getUrlNames).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(apiPathList)) {
            ApiVersionQueryDto apiVersionQueryDto = new ApiVersionQueryDto();
            apiVersionQueryDto.setApiPathList(LambdaQueryUtil.getSplitList(apiPathList));
            apiVersionQueryDto.setAppCodes(LambdaQueryUtil.getSplitList(appCodes));
            List<EaiApiVersion> list = this.apiQueryMapper.getApiVersionList(apiVersionQueryDto);
            return this.getApiVersionsFromList(list, true, queryKeywordMap);
        }
        return new ArrayList<EaiApiVersion>();
    }

    private List<EaiApiVersion> getApiVersionListByApiIds(List<SysResources> resourceList, List<String> appCodes, Map<String, AppQueryKeyword> queryKeywordMap, List<Long> apiIds) {
        if (ToolUtil.isEmpty(resourceList) || ToolUtil.isEmpty(appCodes) || ToolUtil.isEmpty(apiIds)) {
            return new ArrayList<EaiApiVersion>();
        }
        List apiPathList = resourceList.stream().map(SysResources::getUrlNames).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(apiPathList)) {
            ApiVersionQueryDto apiVersionQueryDto = new ApiVersionQueryDto();
            apiVersionQueryDto.setApiPathList(LambdaQueryUtil.getSplitList(apiPathList));
            apiVersionQueryDto.setAppCodes(LambdaQueryUtil.getSplitList(appCodes));
            apiVersionQueryDto.setApiVersionIds(LambdaQueryUtil.getSplitList(apiIds));
            List<EaiApiVersion> list = this.apiQueryMapper.getApiVersionList(apiVersionQueryDto);
            return this.getApiVersionsFromList(list, false, queryKeywordMap);
        }
        return new ArrayList<EaiApiVersion>();
    }

    private List<EaiApiVersion> getApiVersionsFromList(List<EaiApiVersion> list, boolean latestFlag, Map<String, AppQueryKeyword> queryKeywordMap) {
        ArrayList<EaiApiVersion> apiVersionList = new ArrayList<EaiApiVersion>();
        HashMap<Long, EaiResourcesInfo> resourcesInfoMap = new HashMap();
        if (latestFlag) {
            resourcesInfoMap = this.getResourceInfoMap(list);
        }
        for (EaiApiVersion apiVersion : list) {
            String appCode;
            AppQueryKeyword queryKeyword;
            boolean flag = this.checkApiVersion(apiVersion, queryKeyword = queryKeywordMap.get(appCode = apiVersion.getApplicationCode()), resourcesInfoMap, latestFlag);
            if (!flag) continue;
            apiVersionList.add(apiVersion);
        }
        return apiVersionList;
    }

    private Map<Long, EaiResourcesInfo> getResourceInfoMap(List<EaiApiVersion> apiVersionList) {
        if (ToolUtil.isEmpty(apiVersionList)) {
            return new HashMap<Long, EaiResourcesInfo>();
        }
        List apiVersionIds = apiVersionList.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList());
        List resourcesInfoList = new ArrayList();
        if (ToolUtil.isNotEmpty(apiVersionIds)) {
            resourcesInfoList = this.eaiResourcesInfoService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiResourcesInfo::getResourceVersionId, apiVersionIds).eq(EaiResourcesInfo::getDeleteState, (Object)"0"));
        }
        return resourcesInfoList.stream().collect(Collectors.toMap(EaiResourcesInfo::getResourceVersionId, Function.identity()));
    }

    private boolean checkApiVersion(EaiApiVersion apiVersion, AppQueryKeyword queryKeyword, Map<Long, EaiResourcesInfo> resourcesInfoMap, boolean latestFlag) {
        boolean flag = true;
        if (ToolUtil.isEmpty((Object)queryKeyword)) {
            if (latestFlag) {
                flag = this.checkLatestVersion(apiVersion, resourcesInfoMap);
            }
            return flag;
        }
        String version = queryKeyword.getAppVersion();
        LocalDateTime startTime = queryKeyword.getStartTime();
        LocalDateTime endTime = queryKeyword.getEndTime();
        if (ToolUtil.isNotEmpty((Object)version)) {
            Integer currentVersionInt;
            String currentVersion = apiVersion.getApiVersion();
            Integer versionInt = Integer.valueOf(version.replaceAll("v", ""));
            if (versionInt.compareTo(currentVersionInt = Integer.valueOf(currentVersion.replaceAll("v", ""))) < 0) {
                flag = false;
            }
        } else if (latestFlag) {
            flag = this.checkLatestVersion(apiVersion, resourcesInfoMap);
        }
        if (ToolUtil.isNotEmpty((Object)startTime) && flag && startTime.isAfter(apiVersion.getCreateTime())) {
            flag = false;
        }
        if (ToolUtil.isNotEmpty((Object)endTime) && flag && endTime.isBefore(apiVersion.getCreateTime())) {
            flag = false;
        }
        return flag;
    }

    private boolean checkLatestVersion(EaiApiVersion apiVersion, Map<Long, EaiResourcesInfo> resourcesInfoMap) {
        EaiResourcesInfo resourcesInfo = resourcesInfoMap.get(apiVersion.getApiVersionId());
        return ToolUtil.isNotEmpty((Object)resourcesInfo);
    }

    private List<ApiInfoDto> getApiInfoDtoListByApiVersions(List<EaiApiVersion> apiVersionList, Map<Long, EaiApiClassificationVersion> classificMap, boolean paramFlag) {
        ArrayList<ApiInfoDto> apiInfoDtoList = new ArrayList<ApiInfoDto>();
        if (ToolUtil.isEmpty(apiVersionList)) {
            return apiInfoDtoList;
        }
        ArrayList structureIds = new ArrayList();
        HashMap structureIdMap = new HashMap();
        for (EaiApiVersion apiVersion : apiVersionList) {
            Long classificId;
            EaiApiClassificationVersion classificInfo;
            ArrayList<Long> apiStructureIds = new ArrayList<Long>();
            ApiInfoDto apiInfoDto = this.getApiInfoDtoFromVersion(apiVersion);
            if (paramFlag) {
                EaiParamsTestConvertDto inparams = ParamsConvertUtil.toEaiParamsTestConvertDto((String)apiVersion.getInParams());
                apiInfoDto.setInParams(this.getEaiApiInParams(apiVersion.getInParams()));
                EaiParamsTestConvertDto outParams = ParamsConvertUtil.toEaiParamsTestConvertDto((String)apiVersion.getOutParams());
                apiInfoDto.setOutParams(this.getEaiApiOutParams(outParams));
                apiStructureIds.addAll(this.getStructureIds(inparams));
                apiStructureIds.addAll(this.getStructureIds(outParams));
                structureIds.addAll(apiStructureIds);
                structureIdMap.put(apiInfoDto.getApiId(), apiStructureIds);
            }
            if (ToolUtil.isNotEmpty((Object)(classificInfo = classificMap.get(classificId = apiVersion.getClassificId())))) {
                apiInfoDto.setClassificId(classificInfo.getId());
                apiInfoDto.setClassificName(classificInfo.getClassificName());
            } else if (CLASSIFIC_ID_DEFAULT.equals(classificId) || classificId == null) {
                apiInfoDto.setClassificId(CLASSIFIC_ID_DEFAULT);
                apiInfoDto.setClassificName(CLASSIFIC_NAME_DEFAULT);
            }
            apiInfoDtoList.add(apiInfoDto);
        }
        if (paramFlag) {
            List structureVersionList = new ArrayList();
            if (ToolUtil.isNotEmpty(structureIds)) {
                structureVersionList = this.structureVersionService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(StructureVersion::getId, structureIds));
            }
            Map<Long, StructureVersion> structureMap = structureVersionList.stream().collect(Collectors.toMap(StructureVersion::getId, Function.identity()));
            for (ApiInfoDto apiInfoDto : apiInfoDtoList) {
                List structureIdList = (List)structureIdMap.get(apiInfoDto.getApiId());
                List<StructureDto> structureDtos = this.getAllStructures(structureIdList, structureMap);
                apiInfoDto.setStructures(structureDtos);
            }
        }
        return apiInfoDtoList;
    }

    private ApiInfoDto getApiInfoDtoFromVersion(EaiApiVersion apiVersion) {
        ApiInfoDto apiInfoDto = new ApiInfoDto();
        apiInfoDto.setApiId(apiVersion.getApiVersionId());
        apiInfoDto.setApiCode(apiVersion.getApiCode());
        apiInfoDto.setApiName(apiVersion.getApiName());
        apiInfoDto.setApiVersion(apiVersion.getApiVersion());
        apiInfoDto.setAppCode(apiVersion.getApplicationCode());
        apiInfoDto.setApiPath(apiVersion.getApiPath());
        apiInfoDto.setCreateTime(apiVersion.getCreateTime());
        apiInfoDto.setDataFormat(apiVersion.getDataFormat());
        apiInfoDto.setEncodingType(apiVersion.getEncodingType());
        apiInfoDto.setRequestType(apiVersion.getRequestType());
        apiInfoDto.setRemark(apiVersion.getRemark());
        return apiInfoDto;
    }

    private Map<Long, EaiApiClassificationVersion> getApiAndClassifyInfoMap(List<EaiApiVersion> apiVersionList) {
        Map<Long, Object> map = new HashMap<Long, EaiApiClassificationVersion>();
        if (ToolUtil.isEmpty(apiVersionList)) {
            return map;
        }
        List classificIdList = apiVersionList.stream().map(EaiApiVersion::getClassificId).distinct().collect(Collectors.toList());
        List apiClassificationList = new ArrayList();
        if (ToolUtil.isNotEmpty(classificIdList)) {
            apiClassificationList = this.eaiApiClassificationVersionService.listByIds(classificIdList);
        }
        map = apiClassificationList.stream().collect(Collectors.toMap(EaiApiClassificationVersion::getId, Function.identity()));
        EaiApiClassificationVersion defaultClassific = new EaiApiClassificationVersion();
        defaultClassific.setId(CLASSIFIC_ID_DEFAULT);
        defaultClassific.setClassificName(CLASSIFIC_NAME_DEFAULT);
        map.put(CLASSIFIC_ID_DEFAULT, defaultClassific);
        return map;
    }

    private List<ApiInfoDto> getApiInfoDtosByResources(List<SysResources> resourceList, List<String> appCodes, Map<String, AppQueryKeyword> queryKeywordMap, boolean paramFlag) {
        List<EaiApiVersion> apiVersionList = this.getApiVersionListByResources(resourceList, appCodes, queryKeywordMap);
        Map<Long, EaiApiClassificationVersion> classificMap = this.getApiAndClassifyInfoMap(apiVersionList);
        return this.getApiInfoDtoListByApiVersions(apiVersionList, classificMap, paramFlag);
    }

    private List<ApiInfoDto> getApiInfoDtosByApiIds(List<SysResources> resourceList, List<String> appCodes, Map<String, AppQueryKeyword> queryKeywordMap, List<Long> apiIds) {
        List<EaiApiVersion> apiVersionList = this.getApiVersionListByApiIds(resourceList, appCodes, queryKeywordMap, apiIds);
        Map<Long, EaiApiClassificationVersion> classificMap = this.getApiAndClassifyInfoMap(apiVersionList);
        return this.getApiInfoDtoListByApiVersions(apiVersionList, classificMap, true);
    }

    private List<ApiClassifyDto> getApiClassifyDtosByAppCodes(List<String> appCodeList, List<ApiInfoDto> apiInfoDtoList) {
        ArrayList<ApiClassifyDto> apiClassifyDtoList = new ArrayList<ApiClassifyDto>();
        List classificationList = new ArrayList();
        List classificIds = apiInfoDtoList.stream().map(ApiInfoDto::getClassificId).distinct().collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(appCodeList) && ToolUtil.isNotEmpty(classificIds)) {
            LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(EaiApiClassificationVersion::getApplicationCode, appCodeList);
            LambdaQueryUtil.wrapperWithMultiQuery((LambdaQueryWrapper)wrapper, EaiApiClassificationVersion::getId, classificIds);
            ((LambdaQueryWrapper)wrapper.orderByAsc(EaiApiClassificationVersion::getApplicationCode)).orderByDesc(HussarBaseEntity::getCreateTime);
            classificationList = this.eaiApiClassificationVersionService.list((Wrapper)wrapper);
        }
        for (EaiApiClassificationVersion classification : classificationList) {
            ApiClassifyDto classifyDto = new ApiClassifyDto();
            classifyDto.setClassificId(classification.getId());
            classifyDto.setClassificName(classification.getClassificName());
            classifyDto.setClassificVersion(classification.getClassificVersion());
            classifyDto.setRemark(classification.getRemark());
            classifyDto.setAppCode(classification.getApplicationCode());
            ArrayList<ApiInfoDto> apiList = new ArrayList<ApiInfoDto>();
            for (ApiInfoDto apiInfoDto : apiInfoDtoList) {
                if (!classification.getId().equals(apiInfoDto.getClassificId())) continue;
                apiList.add(apiInfoDto);
            }
            classifyDto.setApiList(apiList);
            apiClassifyDtoList.add(classifyDto);
        }
        return apiClassifyDtoList;
    }

    private EaiApiParams getEaiApiInParams(String inParam) {
        EaiParamsTestConvertDto inparams = ParamsConvertUtil.toEaiParamsTestConvertDto((String)inParam);
        EaiApiParams eaiApiParams = new EaiApiParams();
        List eaiApiParamsItems = inparams.getBody();
        List items = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)eaiApiParamsItems)) {
            if (eaiApiParamsItems.size() == 1) {
                EaiParamsItems body = (EaiParamsItems)eaiApiParamsItems.get(0);
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == body.getType().intValue() && OBJECT_STR.equals(body.getValue()) && body.getMapping() == 1) {
                    List realBody = body.getItems();
                    if (ToolUtil.isNotEmpty((Object)realBody)) {
                        items = BeanUtil.copyProperties((Collection)realBody, EaiApiParamsItem.class);
                    }
                } else {
                    items = BeanUtil.copyProperties((Collection)eaiApiParamsItems, EaiApiParamsItem.class);
                }
            } else {
                items = BeanUtil.copyProperties((Collection)eaiApiParamsItems, EaiApiParamsItem.class);
            }
        }
        eaiApiParams.setBody(items);
        return eaiApiParams;
    }

    private EaiApiParamsOut getEaiApiOutParams(EaiParamsTestConvertDto outParams) {
        if (HussarUtils.isNotEmpty((Object)outParams)) {
            EaiApiParamsOut eaiApiParamsOut = new EaiApiParamsOut();
            BeanUtil.copyProperties((Object)outParams, (Object)eaiApiParamsOut);
            List<EaiApiParamsItem> body = this.fillBaseOutInfo(eaiApiParamsOut.getBody());
            eaiApiParamsOut.setBody(body);
            return eaiApiParamsOut;
        }
        return null;
    }

    private List<EaiApiParamsItem> fillBaseOutInfo(List<EaiApiParamsItem> outParam) {
        ArrayList<EaiApiParamsItem> result = new ArrayList<EaiApiParamsItem>();
        EaiApiParamsItem code = new EaiApiParamsItem();
        EaiApiParamsItem data = new EaiApiParamsItem();
        EaiApiParamsItem msg = new EaiApiParamsItem();
        EaiApiParamsItem success = new EaiApiParamsItem();
        code.setName("code");
        code.setType(Integer.valueOf(1));
        code.setItemType(null);
        code.setMark("code");
        code.setMapping(APP_STATUS_ENABLED);
        code.setMappingName("code");
        code.setQuoteStructureId(null);
        code.setItems(Collections.emptyList());
        data.setName("data");
        data.setMappingName("data");
        if (HussarUtils.isEmpty(outParam)) {
            data.setType(Integer.valueOf(7));
            data.setItemType(null);
            data.setMark("data");
            data.setMapping(APP_STATUS_ENABLED);
            data.setQuoteStructureId(null);
            data.setItems(Collections.emptyList());
        } else {
            EaiApiParamsItem paramsItem = new EaiApiParamsItem();
            BeanUtil.copyProperties((Object)outParam.get(0), (Object)paramsItem);
            data.setType(paramsItem.getType());
            data.setItemType(paramsItem.getItemType());
            data.setMark(paramsItem.getMark());
            data.setMapping(paramsItem.getMapping());
            data.setQuoteStructureId(paramsItem.getQuoteStructureId());
            data.setItems(BeanUtil.copyProperties((Collection)paramsItem.getItems(), EaiApiParamsItem.class));
        }
        msg.setName("msg");
        msg.setType(Integer.valueOf(4));
        msg.setItemType(null);
        msg.setMark("msg");
        msg.setMapping(APP_STATUS_ENABLED);
        msg.setMappingName("msg");
        msg.setQuoteStructureId(null);
        msg.setItems(Collections.emptyList());
        success.setName("success");
        success.setType(Integer.valueOf(0));
        success.setItemType(null);
        success.setMark("success");
        success.setMapping(APP_STATUS_ENABLED);
        success.setMappingName("success");
        success.setQuoteStructureId(null);
        success.setItems(Collections.emptyList());
        result.add(code);
        result.add(data);
        result.add(msg);
        result.add(success);
        return result;
    }

    private void getStructureIds(List<EaiParamsItems> items, List<Long> list) {
        if (HussarUtils.isNotEmpty(items)) {
            for (EaiParamsItems item : items) {
                Long id;
                if (HussarUtils.isNotEmpty((Object)item.getQuoteStructureId()) && !list.contains(id = Long.valueOf(Long.parseLong(item.getQuoteStructureId())))) {
                    list.add(id);
                }
                if (!HussarUtils.isNotEmpty((Object)item.getItems())) continue;
                this.getStructureIds(item.getItems(), list);
            }
        }
    }

    private List<Long> getStructureIds(EaiParamsTestConvertDto dto) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (ToolUtil.isEmpty((Object)dto)) {
            return list;
        }
        if (ToolUtil.isNotEmpty((Object)dto.getQuery())) {
            this.getStructureIds(dto.getQuery(), list);
        }
        if (ToolUtil.isNotEmpty((Object)dto.getHeader())) {
            this.getStructureIds(dto.getHeader(), list);
        }
        if (ToolUtil.isNotEmpty((Object)dto.getBody())) {
            this.getStructureIds(dto.getBody(), list);
        }
        return list;
    }

    private List<StructureDto> getAllStructures(List<Long> list, Map<Long, StructureVersion> structureMap) {
        ArrayList<StructureDto> structureDtos = new ArrayList<StructureDto>();
        if (HussarUtils.isNotEmpty(list)) {
            for (Long structureId : list) {
                StructureVersion structureVersion = structureMap.get(structureId);
                if (!ToolUtil.isNotEmpty((Object)structureVersion)) continue;
                StructureDto structureDto = this.getStructureDtoFromVersion(structureVersion);
                String values = structureVersion.getStructureValues();
                structureDto.setItems(this.toStructureItems(values));
                structureDtos.add(structureDto);
                this.structureValues(values, list, structureDtos, structureMap);
            }
        }
        return structureDtos;
    }

    private List<StructureItems> toStructureItems(String values) {
        if (HussarUtils.isNotEmpty((Object)values)) {
            return JSON.parseArray((String)values, StructureItems.class);
        }
        return new ArrayList<StructureItems>();
    }

    private void structureValues(String values, List<Long> list, List<StructureDto> versions, Map<Long, StructureVersion> structureMap) {
        List<StructureItems> structureItems = this.strToItemsList(values);
        for (StructureItems structureItem : structureItems) {
            Long id;
            if (!HussarUtils.isNotEmpty((Object)structureItem.getQuoteStructureId()) || list.contains(id = Long.valueOf(structureItem.getQuoteStructureId()))) continue;
            StructureVersion item = structureMap.get(id);
            StructureDto structureDto = this.getStructureDtoFromVersion(item);
            structureDto.setItems(this.toStructureItems(item.getStructureValues()));
            versions.add(structureDto);
            list.add(id);
            if (!HussarUtils.isNotEmpty((Object)item.getStructureValues())) continue;
            this.structureValues(item.getStructureValues(), list, versions, structureMap);
        }
    }

    private List<StructureItems> strToItemsList(String listStr) {
        JSONArray array = JSON.parseArray((String)listStr);
        if (HussarUtils.isEmpty((Object)array)) {
            return Collections.emptyList();
        }
        ArrayList<StructureItems> value = new ArrayList<StructureItems>();
        for (Object arr : array) {
            StructureItems items = (StructureItems)JSON.parseObject((String)JSONObject.toJSONString(arr), StructureItems.class);
            value.add(items);
        }
        return value;
    }

    private StructureDto getStructureDtoFromVersion(StructureVersion structureVersion) {
        StructureDto structureDto = new StructureDto();
        structureDto.setId(structureVersion.getId());
        structureDto.setStructureId(structureVersion.getStructureId());
        structureDto.setParamsType(Integer.valueOf(structureVersion.getParamsType()));
        structureDto.setApplicationCode(structureVersion.getApplicationCode());
        structureDto.setStructureName(structureVersion.getStructureName());
        structureDto.setStructureCode(structureVersion.getStructureCode());
        structureDto.setStructureVersion(structureVersion.getStructureVersion());
        structureDto.setRemark(structureVersion.getRemark());
        structureDto.setStructureClassify(structureVersion.getStructureClassify());
        return structureDto;
    }
}

