/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.sql.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.sysapi.api.bo.PageQueryBo;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiDataSourceDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.Page;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.DataQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.EaiAppSqlResponse;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.EaiSqlFieldDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.EaiSqlTableDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.SqlQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.service.SqlQueryService;
import com.jxdinfo.hussar.eai.sysapi.api.sql.util.EaiSqlUtil;
import com.jxdinfo.hussar.eai.sysapi.server.factory.EaiDbBusinessFactory;
import com.jxdinfo.hussar.eai.sysapi.server.manager.EaiDbBusinessManager;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="com.jxdinfo.hussar.eai.sysapi.server.sql.service.impl.SqlQueryServiceImpl")
public class SqlQueryServiceImpl
implements SqlQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlQueryServiceImpl.class);
    @Resource
    private ICommonConnectionService commonConnectionService;
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ISysAppClientService sysAppClientService;
    @Autowired
    private ISysClientModelService sysClientModelService;
    private static final String ERROR_MSG = "\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERROR_MSG_LINK = "\u8fde\u63a5\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERROR_MSG_TABLE = "\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String SQL = "01";
    private static final String NULL_MSG_LINK = "\u672a\u67e5\u8be2\u5230\u8fde\u63a5\u4fe1\u606f";
    private static final String ERROR_MSG_FIELD = "\u67e5\u8be2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERROR_MSG_PARAMS = "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERROR_MSG_SQL = "sql\u4e0d\u80fd\u4e3a\u7a7a";

    public List<EaiAppSqlResponse> getLinksByAppCode(String appCode) {
        AssertUtil.isNotEmpty((String)appCode, (String)ERROR_MSG);
        this.checkClientSelectPermission(appCode);
        List<CommonConnection> commonConnections = this.getCommonConnection(appCode);
        ArrayList<EaiAppSqlResponse> appSqlResponses = new ArrayList<EaiAppSqlResponse>();
        if (HussarUtils.isEmpty(commonConnections)) {
            return appSqlResponses;
        }
        for (CommonConnection commonConnection : commonConnections) {
            EaiAppSqlResponse eaiAppSqlResponse = new EaiAppSqlResponse();
            eaiAppSqlResponse.setLinkCode(commonConnection.getConnectionNameEn());
            eaiAppSqlResponse.setLinkName(commonConnection.getConnectionName());
            eaiAppSqlResponse.setRemark(commonConnection.getRemark());
            appSqlResponses.add(eaiAppSqlResponse);
        }
        return appSqlResponses;
    }

    private SysApplication getAppFromCode(String appCode) {
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode));
        AssertUtil.isNotNull((Object)sysApplication, (String)"\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5931\u8d25");
        return sysApplication;
    }

    private SysClientModel getClientModelFromHeader() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        AssertUtil.isNotNull((Object)request, (String)"\u83b7\u53d6\u8bf7\u6c42\u4fe1\u606f\u5931\u8d25");
        String clientId = request.getHeader("client-id");
        AssertUtil.isNotEmpty((String)clientId, (String)"\u83b7\u53d6\u5ba2\u6237\u7aefID\u5931\u8d25");
        SysClientModel clientModel = (SysClientModel)this.sysClientModelService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysClientModel::getClientId, (Object)clientId));
        AssertUtil.isNotNull((Object)clientModel, (String)"\u83b7\u53d6\u5ba2\u6237\u7aef\u4fe1\u606f\u5931\u8d25");
        return clientModel;
    }

    private void checkClientSelectPermission(String appCode) {
        SysApplication sysApplication = this.getAppFromCode(appCode);
        SysClientModel clientModel = this.getClientModelFromHeader();
        SysAppClient appClient = (SysAppClient)this.sysAppClientService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getClientModelId, (Object)clientModel.getId()));
        AssertUtil.isNotNull((Object)appClient, (String)"\u83b7\u53d6\u5e94\u7528\u548c\u5ba2\u6237\u7aef\u5173\u8054\u4fe1\u606f\u5931\u8d25");
        if (!appClient.getAppId().equals(sysApplication.getId())) {
            throw new BaseException("\u5ba2\u6237\u7aef\u65e0\u6743\u67e5\u8be2\u5f53\u524d\u5e94\u7528");
        }
    }

    private List<CommonConnection> getCommonConnection(String appCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)appCode)).eq(CommonConnection::getConnectionClassify, (Object)SQL);
        return this.commonConnectionService.list((Wrapper)queryWrapper);
    }

    public List<EaiAppSqlResponse> getSqlSchemaDetails(SqlQueryDto sqlQueryDto) {
        AssertUtil.isNotNull((Object)sqlQueryDto, (String)ERROR_MSG_PARAMS);
        AssertUtil.isNotEmpty((String)sqlQueryDto.getAppCode(), (String)ERROR_MSG);
        this.checkClientSelectPermission(sqlQueryDto.getAppCode());
        ArrayList<EaiAppSqlResponse> appSqlResponses = new ArrayList<EaiAppSqlResponse>();
        List<CommonConnection> commonConnections = this.getCommonConnection(sqlQueryDto.getAppCode());
        if (HussarUtils.isEmpty(commonConnections)) {
            return appSqlResponses;
        }
        for (CommonConnection commonConnection : commonConnections) {
            EaiAppSqlResponse eaiAppSqlResponse = new EaiAppSqlResponse();
            eaiAppSqlResponse.setLinkCode(commonConnection.getConnectionNameEn());
            eaiAppSqlResponse.setLinkName(commonConnection.getConnectionName());
            sqlQueryDto.setLinkCode(commonConnection.getConnectionNameEn());
            List<EaiSqlTableDto> sqlTableDtos = this.getSqlSchemaDetailFromConn(commonConnection, sqlQueryDto);
            if (HussarUtils.isEmpty(sqlTableDtos)) {
                return appSqlResponses;
            }
            eaiAppSqlResponse.setSqlTableDto(sqlTableDtos);
            appSqlResponses.add(eaiAppSqlResponse);
        }
        return appSqlResponses;
    }

    public List<EaiSqlTableDto> getSqlSchemaDetail(SqlQueryDto sqlQueryDto) {
        AssertUtil.isNotNull((Object)sqlQueryDto, (String)ERROR_MSG_PARAMS);
        AssertUtil.isNotEmpty((String)sqlQueryDto.getAppCode(), (String)ERROR_MSG);
        this.checkClientSelectPermission(sqlQueryDto.getAppCode());
        CommonConnection commonConnection = this.getConnection(sqlQueryDto.getLinkCode(), sqlQueryDto.getAppCode());
        return this.getSqlSchemaDetailFromConn(commonConnection, sqlQueryDto);
    }

    private List<EaiSqlTableDto> getSqlSchemaDetailFromConn(CommonConnection commonConnection, SqlQueryDto sqlQueryDto) {
        Connection connection = null;
        try {
            EaiDataSourceDto dataSourceDto = (EaiDataSourceDto)JSON.parseObject((String)commonConnection.getConnectionConfig(), EaiDataSourceDto.class);
            connection = this.createSqlConn(dataSourceDto);
            List<EaiSqlTableDto> list = this.getSqlSchemaDetail(commonConnection, dataSourceDto, connection, sqlQueryDto);
            this.closeConn(connection);
            return list;
        }
        catch (SQLException e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new BaseException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeConn(connection);
                throw throwable;
            }
        }
    }

    private List<EaiSqlTableDto> getSqlSchemaDetail(CommonConnection commonConnection, EaiDataSourceDto dataSourceDto, Connection connection, SqlQueryDto sqlQueryDto) throws SQLException {
        AssertUtil.isNotEmpty((String)sqlQueryDto.getLinkCode(), (String)ERROR_MSG_LINK);
        List<EaiSqlTableDto> tableDtos = this.getTableInfoList(commonConnection, dataSourceDto, connection, sqlQueryDto);
        String dbType = commonConnection.getClassifyChild();
        EaiDbBusinessManager dbBusinessManager = EaiDbBusinessFactory.getByDbType(dbType);
        String schema = dbBusinessManager.getSchemaFromDto((SysDataSourceDto)dataSourceDto);
        List<HashMap<String, Object>> datas = this.getData(connection, EaiSqlUtil.getFieldSchemaSql((String)dbType, (String)schema));
        if (HussarUtils.isNotEmpty(datas)) {
            for (EaiSqlTableDto tableDto : tableDtos) {
                ArrayList<EaiSqlFieldDto> sqlFieldDtos = new ArrayList<EaiSqlFieldDto>();
                for (HashMap<String, Object> data : datas) {
                    if (!tableDto.getTableName().equals(data.getOrDefault(dbBusinessManager.getKeyByDbType("tableName"), null))) continue;
                    EaiSqlFieldDto sqlFieldDto = new EaiSqlFieldDto();
                    sqlFieldDto.setFieldName(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("fieldName"), "")));
                    sqlFieldDto.setFieldType(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("fieldType"), "")));
                    sqlFieldDto.setLength(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("length"), "")));
                    sqlFieldDto.setNotEmpty(EaiSqlUtil.transformNullAble((String)String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("nullAble"), ""))));
                    sqlFieldDto.setDefaultValue(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("defaultVal"), "")));
                    sqlFieldDto.setComment(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("fieldComment"), "")));
                    sqlFieldDtos.add(sqlFieldDto);
                }
                tableDto.setFieldDtoList(sqlFieldDtos);
            }
        }
        return tableDtos;
    }

    public List<EaiSqlTableDto> getTableInfoList(SqlQueryDto sqlQueryDto) {
        AssertUtil.isNotNull((Object)sqlQueryDto, (String)ERROR_MSG_PARAMS);
        AssertUtil.isNotEmpty((String)sqlQueryDto.getAppCode(), (String)ERROR_MSG);
        AssertUtil.isNotEmpty((String)sqlQueryDto.getLinkCode(), (String)ERROR_MSG_LINK);
        this.checkClientSelectPermission(sqlQueryDto.getAppCode());
        Connection connection = null;
        try {
            CommonConnection commonConnection = this.getConnection(sqlQueryDto.getLinkCode(), sqlQueryDto.getAppCode());
            EaiDataSourceDto dataSourceDto = (EaiDataSourceDto)JSON.parseObject((String)commonConnection.getConnectionConfig(), EaiDataSourceDto.class);
            connection = this.createSqlConn(dataSourceDto);
            List<EaiSqlTableDto> list = this.getTableInfoList(commonConnection, dataSourceDto, connection, sqlQueryDto);
            this.closeConn(connection);
            return list;
        }
        catch (SQLException e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new BaseException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeConn(connection);
                throw throwable;
            }
        }
    }

    private List<EaiSqlTableDto> getTableInfoList(CommonConnection commonConnection, EaiDataSourceDto dataSourceDto, Connection connection, SqlQueryDto sqlQueryDto) throws SQLException {
        AssertUtil.isNotEmpty((String)sqlQueryDto.getLinkCode(), (String)ERROR_MSG_LINK);
        ArrayList<EaiSqlTableDto> list = new ArrayList<EaiSqlTableDto>();
        EaiDbBusinessManager dbBusinessManager = EaiDbBusinessFactory.getByDbType(commonConnection.getClassifyChild());
        String schema = dbBusinessManager.getSchemaFromDto((SysDataSourceDto)dataSourceDto);
        List<HashMap<String, Object>> resultSet = this.getData(connection, dbBusinessManager.getTableSchemaSql(schema, dataSourceDto.getPattern()));
        if (HussarUtils.isNotEmpty(resultSet)) {
            for (HashMap<String, Object> result : resultSet) {
                EaiSqlTableDto eaiSqlTableDto = new EaiSqlTableDto();
                eaiSqlTableDto.setTableName(String.valueOf(result.getOrDefault(dbBusinessManager.getKeyByDbType("tableName"), "")));
                eaiSqlTableDto.setComment(String.valueOf(result.getOrDefault(dbBusinessManager.getKeyByDbType("tableComment"), "")));
                eaiSqlTableDto.setEncoding(String.valueOf(result.getOrDefault(dbBusinessManager.getKeyByDbType("encoding"), "")));
                list.add(eaiSqlTableDto);
            }
        }
        return list;
    }

    private CommonConnection getConnection(String linkCode, String appCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)appCode)).eq(CommonConnection::getConnectionNameEn, (Object)linkCode)).eq(CommonConnection::getConnectionClassify, (Object)SQL);
        CommonConnection commonConnection = (CommonConnection)this.commonConnectionService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)commonConnection)) {
            throw new BaseException(NULL_MSG_LINK);
        }
        return commonConnection;
    }

    private Connection createSqlConn(EaiDataSourceDto dataSourceDto) throws SQLException {
        SysDataSourceDto dataSourceById = this.datasourceService.getDataSourceById(dataSourceDto.getId());
        ItemDataSource itemDataSource = this.dynamicDatasourceService.getDatasourceByPoolName(dataSourceById.getConnName());
        return itemDataSource.getConnection();
    }

    private List<HashMap<String, Object>> getData(Connection connection, String sql) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            List<HashMap<String, Object>> list = this.getColumnData(resultSet);
            return list;
        }
        catch (SQLException e) {
            throw new BaseException("SQL_QUERY-SDK-\u6267\u884cSQL\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BaseException("SQL_QUERY-SDK-\u83b7\u53d6\u51fa\u53c2\u6620\u5c04\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("SQL_QUERY-SDK\u3010resultSet\u3011", (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("SQL_QUERY-SDK\u3010statement\u3011", (Throwable)e);
                }
            }
        }
    }

    private List<HashMap<String, Object>> getColumnData(ResultSet resultSet) throws Exception {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        while (resultSet.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ResultSetMetaData data = resultSet.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                String columnName = data.getColumnLabel(i);
                map.put(columnName, resultSet.getObject(columnName));
            }
            list.add(map);
        }
        return list;
    }

    public List<EaiSqlFieldDto> getTableSchemaDetail(SqlQueryDto sqlQueryDto) {
        return this.getTableSchemaDetail(null, sqlQueryDto);
    }

    private List<EaiSqlFieldDto> getTableSchemaDetail(Connection connection, SqlQueryDto sqlQueryDto) {
        List<HashMap<String, Object>> datas;
        AssertUtil.isNotNull((Object)sqlQueryDto, (String)ERROR_MSG_PARAMS);
        AssertUtil.isNotEmpty((String)sqlQueryDto.getLinkCode(), (String)ERROR_MSG_LINK);
        AssertUtil.isNotEmpty((String)sqlQueryDto.getTableName(), (String)ERROR_MSG_TABLE);
        AssertUtil.isNotEmpty((String)sqlQueryDto.getAppCode(), (String)ERROR_MSG);
        this.checkClientSelectPermission(sqlQueryDto.getAppCode());
        CommonConnection commonConnection = this.getConnection(sqlQueryDto.getLinkCode(), sqlQueryDto.getAppCode());
        EaiDataSourceDto dataSourceDto = (EaiDataSourceDto)JSON.parseObject((String)commonConnection.getConnectionConfig(), EaiDataSourceDto.class);
        String dbType = commonConnection.getClassifyChild();
        EaiDbBusinessManager dbBusinessManager = EaiDbBusinessFactory.getByDbType(dbType);
        String schema = dbBusinessManager.getSchemaFromDto((SysDataSourceDto)dataSourceDto);
        try {
            if (connection == null) {
                connection = this.createSqlConn(dataSourceDto);
            }
            datas = this.getData(connection, dbBusinessManager.getFieldSchemaSql(schema, sqlQueryDto.getTableName()));
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BaseException(e.getMessage());
        }
        finally {
            this.closeConn(connection);
        }
        ArrayList<EaiSqlFieldDto> sqlFieldDtos = new ArrayList<EaiSqlFieldDto>();
        if (HussarUtils.isNotEmpty(datas)) {
            for (HashMap<String, Object> data : datas) {
                EaiSqlFieldDto sqlFieldDto = new EaiSqlFieldDto();
                sqlFieldDto.setFieldName(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("fieldName"), "")));
                sqlFieldDto.setFieldType(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("fieldType"), "")));
                sqlFieldDto.setLength(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("length"), "")));
                sqlFieldDto.setNotEmpty(EaiSqlUtil.transformNullAble((String)String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("nullAble"), ""))));
                sqlFieldDto.setDefaultValue(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("defaultVal"), "")));
                sqlFieldDto.setComment(String.valueOf(data.getOrDefault(dbBusinessManager.getKeyByDbType("fieldComment"), "")));
                sqlFieldDtos.add(sqlFieldDto);
            }
        }
        return sqlFieldDtos;
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public Page<HashMap<String, Object>> getSqlData(DataQueryDto dataQueryDto) {
        AssertUtil.isNotNull((Object)dataQueryDto, (String)ERROR_MSG_PARAMS);
        AssertUtil.isNotEmpty((String)dataQueryDto.getLinkCode(), (String)ERROR_MSG_LINK);
        AssertUtil.isNotEmpty((String)dataQueryDto.getTableName(), (String)ERROR_MSG_TABLE);
        AssertUtil.isNotEmpty((Collection)dataQueryDto.getField(), (String)ERROR_MSG_FIELD);
        AssertUtil.isNotEmpty((String)dataQueryDto.getAppCode(), (String)ERROR_MSG);
        this.checkClientSelectPermission(dataQueryDto.getAppCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)dataQueryDto.getAppCode())).eq(CommonConnection::getConnectionNameEn, (Object)dataQueryDto.getLinkCode())).eq(CommonConnection::getConnectionClassify, (Object)SQL);
        CommonConnection commonConnection = (CommonConnection)this.commonConnectionService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)commonConnection)) {
            throw new BaseException(NULL_MSG_LINK);
        }
        String dbType = commonConnection.getClassifyChild();
        EaiDbBusinessManager dbBusinessManager = EaiDbBusinessFactory.getByDbType(dbType);
        String sql = dbBusinessManager.formatSql(dataQueryDto);
        String countSql = EaiSqlUtil.formatCountSql((DataQueryDto)dataQueryDto);
        EaiDataSourceDto dataSourceDto = (EaiDataSourceDto)JSON.parseObject((String)commonConnection.getConnectionConfig(), EaiDataSourceDto.class);
        Connection connection = null;
        Page listPage = new Page();
        try {
            connection = this.createSqlConn(dataSourceDto);
            List<HashMap<String, Object>> datas = this.getData(connection, sql);
            dbBusinessManager.resultDataTypeTransform(datas);
            List<HashMap<String, Object>> count = this.getData(connection, countSql);
            Long total = 0L;
            if (HussarUtils.isNotEmpty(count)) {
                total = Long.valueOf(String.valueOf(count.get(0).getOrDefault(dbBusinessManager.getKeyByDbType("count"), "0")));
            }
            PageQueryBo pageQueryBo = dbBusinessManager.getPageQueryBo(dataQueryDto.getPageQuery());
            listPage.setTotal(total);
            listPage.setCurrent(Long.valueOf(pageQueryBo.getCurrent()));
            listPage.setSize(Long.valueOf(pageQueryBo.getLimit()));
            listPage.setRecords(datas);
        }
        catch (SQLException e) {
            LOGGER.error("SQL_QUERY-SDK\u3010getSqlData\u3011", (Throwable)e);
            throw new BaseException(e.getMessage());
        }
        finally {
            this.closeConn(connection);
        }
        return listPage;
    }

    public Page<HashMap<String, Object>> getSqlDataBySql(DataQueryDto dataQueryDto) {
        AssertUtil.isNotNull((Object)dataQueryDto, (String)ERROR_MSG_PARAMS);
        AssertUtil.isNotEmpty((String)dataQueryDto.getSql(), (String)ERROR_MSG_SQL);
        AssertUtil.isNotEmpty((String)dataQueryDto.getAppCode(), (String)ERROR_MSG);
        AssertUtil.isNotEmpty((String)dataQueryDto.getLinkCode(), (String)ERROR_MSG_LINK);
        this.checkClientSelectPermission(dataQueryDto.getAppCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)dataQueryDto.getAppCode())).eq(CommonConnection::getConnectionNameEn, (Object)dataQueryDto.getLinkCode())).eq(CommonConnection::getConnectionClassify, (Object)SQL);
        CommonConnection commonConnection = (CommonConnection)this.commonConnectionService.getOne((Wrapper)queryWrapper);
        EaiDataSourceDto dataSourceDto = (EaiDataSourceDto)JSON.parseObject((String)commonConnection.getConnectionConfig(), EaiDataSourceDto.class);
        Connection connection = null;
        Page listPage = new Page();
        String realSql = dataQueryDto.getSql();
        realSql = EaiSqlUtil.getQuerySql((String)realSql);
        EaiSqlUtil.pageSqlCheck((String)realSql);
        String sql = EaiSqlUtil.keyWordsCheck((String)realSql);
        try {
            connection = this.createSqlConn(dataSourceDto);
            List<HashMap<String, Object>> datas = this.getData(connection, sql);
            listPage.setTotal(null);
            listPage.setCurrent(dataQueryDto.getPageQuery().getCurrent());
            listPage.setSize(dataQueryDto.getPageQuery().getSize());
            listPage.setRecords(datas);
        }
        catch (SQLException e) {
            LOGGER.error("SQL_QUERY-SDK\u3010getSqlDataBySql\u3011", (Throwable)e);
            throw new BaseException(e.getMessage());
        }
        finally {
            this.closeConn(connection);
        }
        return listPage;
    }
}

