/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.sysapi.api.service.SwaggerImportService;
import com.jxdinfo.hussar.eai.sysapi.server.service.impl.ImportCommonServiceImpl;
import java.io.IOException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.eai.sysapi.server.service.impl.SwaggerImportServiceImpl")
public class SwaggerImportServiceImpl
extends ImportCommonServiceImpl
implements SwaggerImportService {
    private static final Logger logger = LoggerFactory.getLogger(SwaggerImportServiceImpl.class);
    @Resource
    IReleaseApiService iReleaseApiService;

    public Boolean importJson(String appCode, JSONObject json) {
        this.createNewApp(appCode);
        byte[] content = JSONObject.toJSONBytes((Object)json, (SerializerFeature[])new SerializerFeature[0]);
        return this.iReleaseApiService.importSwagger(content, appCode);
    }

    public Boolean importFile(String appCode, MultipartFile multipartFile) {
        this.createNewApp(appCode);
        try {
            byte[] content = multipartFile.getBytes();
            this.iReleaseApiService.importSwagger(content, appCode);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        return true;
    }
}

