/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiClassificationVersion;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IEaiApiClassificationVersionService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiParamsTestConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiClassifyDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiInfoDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsItem;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsOut;
import com.jxdinfo.hussar.eai.sysapi.api.dto.Page;
import com.jxdinfo.hussar.eai.sysapi.api.dto.StructureDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.StructureItems;
import com.jxdinfo.hussar.eai.sysapi.api.service.EaiApiQueryServcie;
import com.jxdinfo.hussar.eai.sysapi.server.dao.ApiQueryMapper;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.sysapi.server.service.impl.EaiApiQueryServcieImpl")
public class EaiApiQueryServcieImpl
implements EaiApiQueryServcie {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiApiQueryServcieImpl.class);
    @Resource
    IApiVersionService apiVersionService;
    @Resource
    IEaiResourcesInfoService eaiResourcesInfoService;
    private static final Long CLASSIFIC_ID_DEFAULT = 0L;
    private static final String CLASSIFIC_NAME_DEFAULT = "\u9ed8\u8ba4\u7c7b\u578b";
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ApiQueryMapper apiQueryMapper;
    @Resource
    IEaiApiClassificationVersionService eaiApiClassificationVersionService;
    private static final String OBJECT_STR = "Object";
    @Resource
    private ISysClientPermissionService iSysClientPermissionService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    IStructureVersionService structureVersionService;

    public ApiResponse<ApiInfoDto> getApiDetailByCode(String appCode, String apiCode) {
        ApiInfoDto apiInfoDto = new ApiInfoDto();
        LambdaQueryWrapper appQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getApplicationCode, (Object)appCode)).eq(EaiResourcesInfo::getResourceCode, (Object)apiCode)).eq(EaiResourcesInfo::getDeleteState, (Object)"0");
        EaiResourcesInfo resourcesInfo = (EaiResourcesInfo)this.eaiResourcesInfoService.getOne((Wrapper)appQueryWrapper);
        EaiApiVersion apiInfo = null;
        if (ToolUtil.isNotEmpty((Object)resourcesInfo)) {
            apiInfo = (EaiApiVersion)this.apiVersionService.getById((Serializable)resourcesInfo.getResourceVersionId());
        }
        EaiParamsTestConvertDto inparams = null;
        EaiParamsTestConvertDto outParams = null;
        if (ToolUtil.isNotEmpty(apiInfo)) {
            inparams = ParamsConvertUtil.toEaiParamsTestConvertDto((String)apiInfo.getInParams());
            outParams = ParamsConvertUtil.toEaiParamsTestConvertDto((String)apiInfo.getOutParams());
            BeanUtil.copyProperties((Object)apiInfo, (Object)apiInfoDto);
        }
        ArrayList<Long> structureIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)inparams)) {
            EaiApiParams eaiApiParams = new EaiApiParams();
            BeanUtil.copyProperties((Object)inparams, (Object)eaiApiParams);
            apiInfoDto.setInParams(eaiApiParams);
            structureIds.addAll(this.getStructureIds(inparams));
        }
        if (HussarUtils.isNotEmpty((Object)outParams)) {
            EaiApiParamsOut eaiApiParamsOut = new EaiApiParamsOut();
            BeanUtil.copyProperties((Object)outParams, (Object)eaiApiParamsOut);
            List<EaiApiParamsItem> body = this.fillBaseOutInfo(eaiApiParamsOut.getBody());
            eaiApiParamsOut.setBody(body);
            apiInfoDto.setOutParams(eaiApiParamsOut);
            structureIds.addAll(this.getStructureIds(outParams));
        }
        apiInfoDto.setStructures(this.getAllStructures(structureIds));
        return ApiResponse.success((Object)apiInfoDto);
    }

    public ApiResponse<Page<ApiClassifyDto>> getClassifyDetailList(ApiQueryDto apiQuery) {
        String appCode = apiQuery.getAppCode();
        List classifyIds = apiQuery.getApiClassifyId();
        Page page = new Page();
        List<EaiApiVersion> apiVersionList = this.getApiVersionsByApiQuery(apiQuery);
        if (HussarUtils.isNotEmpty(apiVersionList)) {
            List<Long> apiIds = apiVersionList.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList());
            List<Long> apiClassifyDtos = this.apiQueryMapper.getClassifyIdList(apiIds);
            if (HussarUtils.isNotEmpty(apiClassifyDtos)) {
                apiClassifyDtos = apiClassifyDtos.stream().distinct().collect(Collectors.toList());
            }
            if (apiQuery.getPage().booleanValue()) {
                com.baomidou.mybatisplus.extension.plugins.pagination.Page page1 = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
                page1.setSize(apiQuery.getSize().longValue());
                page1.setCurrent(apiQuery.getCurrent().longValue());
                if (HussarUtils.isNotEmpty(apiClassifyDtos)) {
                    LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiClassificationVersion::getApplicationCode, (Object)appCode)).in(EaiApiClassificationVersion::getId, apiClassifyDtos)).orderBy(true, false, HussarBaseEntity::getCreateTime);
                    com.baomidou.mybatisplus.extension.plugins.pagination.Page classificationVersions = (com.baomidou.mybatisplus.extension.plugins.pagination.Page)this.eaiApiClassificationVersionService.page((IPage)page1, (Wrapper)lambdaQueryWrapper);
                    List eaiApiClassificationVersions = classificationVersions.getRecords();
                    ArrayList<ApiClassifyDto> list = new ArrayList<ApiClassifyDto>();
                    for (EaiApiClassificationVersion eaiApiClassificationVersion : eaiApiClassificationVersions) {
                        Long id = eaiApiClassificationVersion.getId();
                        ApiClassifyDto apiClassifyDto = new ApiClassifyDto();
                        apiClassifyDto.setAppCode(appCode);
                        apiClassifyDto.setClassificId(id);
                        apiClassifyDto.setClassificVersion(eaiApiClassificationVersion.getClassificVersion());
                        apiClassifyDto.setRemark(eaiApiClassificationVersion.getRemark());
                        apiClassifyDto.setClassificName(eaiApiClassificationVersion.getClassificName());
                        ArrayList<EaiApiVersion> eaiApiVersions = new ArrayList<EaiApiVersion>();
                        for (EaiApiVersion apiVersion : apiVersionList) {
                            if (!id.equals(apiVersion.getClassificId())) continue;
                            eaiApiVersions.add(apiVersion);
                        }
                        if (HussarUtils.isNotEmpty(eaiApiVersions)) {
                            List<ApiInfoDto> apiInfoDtos = this.toApiInfoDto(eaiApiVersions, eaiApiClassificationVersion);
                            apiClassifyDto.setApiList(apiInfoDtos);
                        }
                        list.add(apiClassifyDto);
                    }
                    if ((ToolUtil.isEmpty((Object)classifyIds) || classifyIds.contains(CLASSIFIC_ID_DEFAULT)) && classificationVersions.getTotal() / apiQuery.getSize() <= apiQuery.getCurrent()) {
                        list.add(this.toDefaultApiClassifyDto(apiVersionList, apiQuery.getAppCode()));
                    }
                    page.setRecords(list);
                    page.setTotal(Long.valueOf(classificationVersions.getTotal()));
                    page.setCurrent(Long.valueOf(classificationVersions.getCurrent()));
                    page.setSize(Long.valueOf(classificationVersions.getSize()));
                }
            } else {
                List<ApiClassifyDto> classifyDtoList = this.toApiClassifyDto(apiVersionList);
                if (ToolUtil.isEmpty((Object)classifyIds) || classifyIds.contains(CLASSIFIC_ID_DEFAULT)) {
                    classifyDtoList.add(this.toDefaultApiClassifyDto(apiVersionList, apiQuery.getAppCode()));
                }
                page.setRecords(classifyDtoList);
                Long size = classifyDtoList.size();
                page.setTotal(size);
                page.setCurrent(Long.valueOf(1L));
                page.setSize(size);
            }
        }
        return ApiResponse.success((Object)page);
    }

    private List<EaiApiVersion> getApiVersionsByApiQuery(ApiQueryDto apiQuery) {
        ArrayList<EaiApiVersion> resultList = new ArrayList<EaiApiVersion>();
        LambdaQueryWrapper appQueryWrapper = new LambdaQueryWrapper();
        this.query((LambdaQueryWrapper<EaiApiVersion>)appQueryWrapper, apiQuery);
        List apiVersionList = this.apiVersionService.list((Wrapper)appQueryWrapper);
        Map<Long, EaiResourcesInfo> resourcesInfoMap = this.getResourceInfoMap(apiVersionList);
        for (EaiApiVersion apiVersion : apiVersionList) {
            if (!this.checkApiVersion(apiVersion, apiQuery, resourcesInfoMap)) continue;
            resultList.add(apiVersion);
        }
        return resultList;
    }

    private boolean checkApiVersion(EaiApiVersion apiVersion, ApiQueryDto apiQuery, Map<Long, EaiResourcesInfo> resourcesInfoMap) {
        boolean flag = true;
        String version = apiQuery.getAppVersion();
        if (ToolUtil.isNotEmpty((Object)version)) {
            Integer currentVersionInt;
            String currentVersion = apiVersion.getApiVersion();
            Integer versionInt = Integer.valueOf(version.replaceAll("v", ""));
            if (versionInt.compareTo(currentVersionInt = Integer.valueOf(currentVersion.replaceAll("v", ""))) < 0) {
                flag = false;
            }
        } else {
            flag = this.checkLatestVersion(apiVersion, resourcesInfoMap);
        }
        return flag;
    }

    private boolean checkLatestVersion(EaiApiVersion apiVersion, Map<Long, EaiResourcesInfo> resourcesInfoMap) {
        EaiResourcesInfo resourcesInfo = resourcesInfoMap.get(apiVersion.getApiVersionId());
        return ToolUtil.isNotEmpty((Object)resourcesInfo);
    }

    private Map<Long, EaiResourcesInfo> getResourceInfoMap(List<EaiApiVersion> apiVersionList) {
        if (ToolUtil.isEmpty(apiVersionList)) {
            return new HashMap<Long, EaiResourcesInfo>();
        }
        List apiVersionIds = apiVersionList.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList());
        List resourcesInfoList = new ArrayList();
        if (ToolUtil.isNotEmpty(apiVersionIds)) {
            resourcesInfoList = this.eaiResourcesInfoService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiResourcesInfo::getResourceVersionId, apiVersionIds).eq(EaiResourcesInfo::getDeleteState, (Object)"0"));
        }
        return resourcesInfoList.stream().collect(Collectors.toMap(EaiResourcesInfo::getResourceVersionId, Function.identity()));
    }

    private List<ApiClassifyDto> toApiClassifyDto(List<EaiApiVersion> eaiApiVersions) {
        ArrayList<ApiClassifyDto> apiClassifyDtos = new ArrayList<ApiClassifyDto>();
        List classifiyIds = eaiApiVersions.stream().map(EaiApiVersion::getClassificId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(classifiyIds)) {
            classifiyIds = classifiyIds.stream().distinct().collect(Collectors.toList());
            for (Long classifiyId : classifiyIds) {
                ApiClassifyDto apiClassifyDto = new ApiClassifyDto();
                EaiApiClassificationVersion eaiApiClassificationVersion = (EaiApiClassificationVersion)this.eaiApiClassificationVersionService.getById((Serializable)classifiyId);
                apiClassifyDto.setClassificName(eaiApiClassificationVersion.getClassificName());
                apiClassifyDto.setRemark(eaiApiClassificationVersion.getRemark());
                apiClassifyDto.setClassificId(classifiyId);
                ArrayList<EaiApiVersion> apiVersions = new ArrayList<EaiApiVersion>();
                for (EaiApiVersion eaiApiVersion : eaiApiVersions) {
                    if (!classifiyId.equals(eaiApiVersion.getClassificId())) continue;
                    apiVersions.add(eaiApiVersion);
                }
                apiClassifyDto.setApiList(this.toApiInfoDto(apiVersions, eaiApiClassificationVersion));
                apiClassifyDtos.add(apiClassifyDto);
            }
        }
        return apiClassifyDtos;
    }

    private ApiClassifyDto toDefaultApiClassifyDto(List<EaiApiVersion> apiVersionList, String appCode) {
        EaiApiClassificationVersion defaultClassificationVersion = new EaiApiClassificationVersion();
        defaultClassificationVersion.setId(CLASSIFIC_ID_DEFAULT);
        defaultClassificationVersion.setClassificName(CLASSIFIC_NAME_DEFAULT);
        ApiClassifyDto defaultClassifyDto = new ApiClassifyDto();
        defaultClassifyDto.setAppCode(appCode);
        defaultClassifyDto.setClassificId(CLASSIFIC_ID_DEFAULT);
        defaultClassifyDto.setClassificName(CLASSIFIC_NAME_DEFAULT);
        ArrayList<EaiApiVersion> eaiApiVersions = new ArrayList<EaiApiVersion>();
        for (EaiApiVersion apiVersion : apiVersionList) {
            if (!CLASSIFIC_ID_DEFAULT.equals(apiVersion.getClassificId()) && apiVersion.getClassificId() != null) continue;
            eaiApiVersions.add(apiVersion);
        }
        if (HussarUtils.isNotEmpty(eaiApiVersions)) {
            defaultClassifyDto.setApiList(this.toApiInfoDto(eaiApiVersions, defaultClassificationVersion));
        }
        return defaultClassifyDto;
    }

    public ApiResponse<Page<ApiInfoDto>> getApiDetailList(ApiQueryDto apiQuery) {
        Page page = new Page();
        List<EaiApiVersion> apiVersionList = this.getApiVersionsByApiQuery(apiQuery);
        List apiVersionIds = apiVersionList.stream().map(EaiApiVersion::getApiVersionId).distinct().collect(Collectors.toList());
        if (ToolUtil.isEmpty(apiVersionIds)) {
            page.setRecords(new ArrayList());
            page.setCurrent(Long.valueOf(1L));
            page.setSize(apiQuery.getSize());
            page.setTotal(Long.valueOf(0L));
            return ApiResponse.success((Object)page);
        }
        LambdaQueryWrapper apiVersionQueryWrapper = LambdaQueryUtil.getMultiQueryWrapper(EaiApiVersion::getApiVersionId, apiVersionIds);
        apiVersionQueryWrapper.orderBy(true, ToolUtil.isEmpty((Object)apiQuery.getDesc()) || apiQuery.getDesc() == false, com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity::getCreateTime);
        if (apiQuery.getPage().booleanValue()) {
            com.baomidou.mybatisplus.extension.plugins.pagination.Page page1 = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
            page1.setCurrent(apiQuery.getCurrent().longValue());
            page1.setSize(apiQuery.getSize().longValue());
            com.baomidou.mybatisplus.extension.plugins.pagination.Page apiVersionPages = (com.baomidou.mybatisplus.extension.plugins.pagination.Page)this.apiVersionService.page((IPage)page1, (Wrapper)apiVersionQueryWrapper);
            List versions = apiVersionPages.getRecords();
            if (HussarUtils.isNotEmpty((Object)versions)) {
                page.setRecords(this.toApiInfoDto(versions));
            }
            page.setCurrent(Long.valueOf(apiVersionPages.getCurrent()));
            page.setSize(Long.valueOf(apiVersionPages.getSize()));
            page.setTotal(Long.valueOf(apiVersionPages.getTotal()));
        } else {
            List apiVersions = this.apiVersionService.list((Wrapper)apiVersionQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)apiVersions)) {
                Long size = apiVersions.size();
                page.setRecords(this.toApiInfoDto(apiVersions));
                page.setCurrent(Long.valueOf(1L));
                page.setSize(size);
                page.setTotal(size);
            }
        }
        return ApiResponse.success((Object)page);
    }

    private void query(LambdaQueryWrapper<EaiApiVersion> apiVersionQueryWrapper, ApiQueryDto apiQuery) {
        if (HussarUtils.isNotEmpty((Object)apiQuery.getStartTime())) {
            apiVersionQueryWrapper.ge(com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity::getCreateTime, (Object)apiQuery.getStartTime());
        }
        if (HussarUtils.isNotEmpty((Object)apiQuery.getEndTime())) {
            apiVersionQueryWrapper.le(com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity::getCreateTime, (Object)apiQuery.getEndTime());
        }
        if (HussarUtils.isNotEmpty((Object)apiQuery.getApiName())) {
            apiVersionQueryWrapper.like(EaiApiVersion::getApiName, (Object)apiQuery.getApiName());
        }
        if (HussarUtils.isNotEmpty((Object)apiQuery.getApiClassifyId())) {
            apiVersionQueryWrapper.in(EaiApiVersion::getClassificId, (Collection)apiQuery.getApiClassifyId());
        }
        if (HussarUtils.isNotEmpty((Object)apiQuery.getAppCode())) {
            apiVersionQueryWrapper.eq(EaiApiVersion::getApplicationCode, (Object)apiQuery.getAppCode());
        }
        apiVersionQueryWrapper.orderBy(true, ToolUtil.isEmpty((Object)apiQuery.getDesc()) || apiQuery.getDesc() == false, com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity::getCreateTime);
    }

    private EaiApiParams toInParams(String inParams) {
        EaiParamsTestConvertDto inparam = ParamsConvertUtil.toEaiParamsTestConvertDto((String)inParams);
        EaiApiParams eaiApiParams = new EaiApiParams();
        List eaiApiParamsItems = inparam.getBody();
        List items = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)eaiApiParamsItems)) {
            if (eaiApiParamsItems.size() == 1) {
                EaiParamsItems body = (EaiParamsItems)eaiApiParamsItems.get(0);
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == body.getType().intValue() && OBJECT_STR.equals(body.getValue()) && body.getMapping() == 1) {
                    List realBody = body.getItems();
                    if (ToolUtil.isNotEmpty((Object)realBody)) {
                        items = BeanUtil.copyProperties((Collection)realBody, EaiApiParamsItem.class);
                    }
                } else {
                    items = BeanUtil.copyProperties((Collection)eaiApiParamsItems, EaiApiParamsItem.class);
                }
            } else {
                items = BeanUtil.copyProperties((Collection)eaiApiParamsItems, EaiApiParamsItem.class);
            }
        }
        eaiApiParams.setBody(items);
        return eaiApiParams;
    }

    private EaiApiParamsOut toOutParams(String outParams) {
        EaiApiParamsOut eaiApiParamsOut = new EaiApiParamsOut();
        List eaiApiParamsItems = JSON.parseArray((String)outParams, EaiApiParamsItem.class);
        eaiApiParamsOut.setBody(eaiApiParamsItems);
        return eaiApiParamsOut;
    }

    private List<ApiInfoDto> toApiInfoDto(List<EaiApiVersion> apiVersions, EaiApiClassificationVersion eaiApiClassificationVersion) {
        ArrayList<ApiInfoDto> list = new ArrayList<ApiInfoDto>();
        if (HussarUtils.isNotEmpty(apiVersions)) {
            for (EaiApiVersion apiVersion : apiVersions) {
                ApiInfoDto apiInfoDto = new ApiInfoDto();
                BeanUtil.copyProperties((Object)apiVersion, (Object)apiInfoDto);
                apiInfoDto.setStructures((List)this.getApiDetailList(apiVersion).getData());
                apiInfoDto.setAppCode(apiVersion.getApplicationCode());
                apiInfoDto.setInParams(this.toInParams(apiVersion.getInParams()));
                EaiApiParamsOut apiParamsOut = this.toOutParams(apiVersion.getOutParams());
                List<EaiApiParamsItem> body = this.fillBaseOutInfo(apiParamsOut.getBody());
                apiParamsOut.setBody(body);
                apiInfoDto.setOutParams(apiParamsOut);
                apiInfoDto.setClassificId(eaiApiClassificationVersion.getClassificId());
                apiInfoDto.setClassificName(eaiApiClassificationVersion.getClassificName());
                list.add(apiInfoDto);
            }
        }
        return list;
    }

    private List<ApiInfoDto> toApiInfoDto(List<EaiApiVersion> apiVersions) {
        ArrayList<ApiInfoDto> list = new ArrayList<ApiInfoDto>();
        if (HussarUtils.isNotEmpty(apiVersions)) {
            HashMap<Long, String> map = new HashMap<Long, String>();
            for (EaiApiVersion apiVersion : apiVersions) {
                ApiInfoDto apiInfoDto = new ApiInfoDto();
                BeanUtil.copyProperties((Object)apiVersion, (Object)apiInfoDto);
                apiInfoDto.setStructures((List)this.getApiDetailList(apiVersion).getData());
                apiInfoDto.setAppCode(apiVersion.getApplicationCode());
                apiInfoDto.setInParams(this.toInParams(apiVersion.getInParams()));
                EaiApiParamsOut apiParamsOut = this.toOutParams(apiVersion.getOutParams());
                List<EaiApiParamsItem> body = this.fillBaseOutInfo(apiParamsOut.getBody());
                apiParamsOut.setBody(body);
                apiInfoDto.setOutParams(apiParamsOut);
                apiInfoDto.setClassificId(apiVersion.getClassificId());
                String classificName = "";
                if (!map.containsKey(apiVersion.getClassificId())) {
                    EaiApiClassificationVersion eaiApiClassificationVersion = (EaiApiClassificationVersion)this.eaiApiClassificationVersionService.getById((Serializable)apiVersion.getClassificId());
                    if (ToolUtil.isNotEmpty((Object)eaiApiClassificationVersion)) {
                        classificName = eaiApiClassificationVersion.getClassificName();
                        map.put(apiVersion.getClassificId(), classificName);
                    }
                } else {
                    classificName = (String)map.get(apiVersion.getClassificId());
                }
                apiInfoDto.setClassificName(classificName);
                list.add(apiInfoDto);
            }
        }
        return list;
    }

    public ApiResponse<List<StructureDto>> getApiDetailList(EaiApiVersion apiInfo) {
        EaiParamsTestConvertDto inparams = ParamsConvertUtil.toEaiParamsTestConvertDto((String)apiInfo.getInParams());
        EaiParamsTestConvertDto outParams = ParamsConvertUtil.toEaiParamsTestConvertDto((String)apiInfo.getOutParams());
        ArrayList<Long> structureIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)inparams)) {
            structureIds.addAll(this.getStructureIds(inparams));
        }
        if (HussarUtils.isNotEmpty((Object)outParams)) {
            structureIds.addAll(this.getStructureIds(outParams));
        }
        return ApiResponse.success(this.getAllStructures(structureIds));
    }

    public ApiResponse<List<StructureDto>> getStructureDetailList(Long structureId) {
        StructureVersion structureVersion = (StructureVersion)this.structureVersionService.getById((Serializable)structureId);
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(structureVersion.getId());
        ArrayList<StructureDto> versions = new ArrayList<StructureDto>();
        StructureDto structureDto = new StructureDto();
        BeanUtil.copyProperties((Object)structureVersion, (Object)structureDto);
        if (HussarUtils.isNotEmpty((Object)structureVersion.getStructureValues())) {
            structureDto.setItems(this.toStructureItems(structureVersion.getStructureValues()));
        }
        versions.add(structureDto);
        this.structureValues(structureVersion.getStructureValues(), list, versions);
        return ApiResponse.success(versions);
    }

    public Boolean checkAuthedApi(String clientId, String appCode, String apiCode) {
        List pids;
        LambdaQueryWrapper lambdaQueryWrapper;
        List sysResources;
        LOGGER.debug(StringUtil.format((String)"\u5ba2\u6237\u7aefID:{}, \u5e94\u7528\u6807\u8bc6:{}, \u63a5\u53e3\u6807\u8bc6:{}", (Object[])new Object[]{clientId, appCode, apiCode}));
        AssertUtil.isNotEmpty((String)clientId, (String)"\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)appCode, (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)apiCode, (String)"\u63a5\u53e3\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        String apiPath = String.format("/%s/api/%s", appCode, apiCode);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysClientPermission::getClientId, (Object)clientId);
        List permissions = this.iSysClientPermissionService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)permissions) && HussarUtils.isNotEmpty((Object)(sysResources = this.sysResourcesService.list((Wrapper)(lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysResources::getId, pids = permissions.stream().map(SysClientPermission::getPermissionId).collect(Collectors.toList()))))))) {
            List pathList = sysResources.stream().map(SysResources::getUrlNames).collect(Collectors.toList());
            for (String path : pathList) {
                if (!path.startsWith(apiPath)) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean checkAuthedApi(String clientId, EaiApiVersion apiInfo) {
        return this.checkAuthedApi(clientId, apiInfo.getApplicationCode(), apiInfo.getApiCode());
    }

    private List<StructureDto> getAllStructures(List<Long> list) {
        List structureVersions;
        ArrayList<StructureDto> structureDtos = new ArrayList<StructureDto>();
        if (HussarUtils.isNotEmpty(list) && HussarUtils.isNotEmpty((Object)(structureVersions = this.structureVersionService.listByIds(list)))) {
            for (StructureVersion structureVersion : structureVersions) {
                StructureDto structureDto = new StructureDto();
                BeanUtil.copyProperties((Object)structureVersion, (Object)structureDto);
                String values = structureVersion.getStructureValues();
                structureDto.setItems(this.toStructureItems(values));
                structureDtos.add(structureDto);
                this.structureValues(values, list, structureDtos);
            }
        }
        return structureDtos;
    }

    private List<StructureItems> toStructureItems(String values) {
        if (HussarUtils.isNotEmpty((Object)values)) {
            return JSON.parseArray((String)values, StructureItems.class);
        }
        return new ArrayList<StructureItems>();
    }

    private void structureValues(String values, List<Long> list, List<StructureDto> versions) {
        List<StructureItems> structureItems = this.strToItemsList(values);
        for (StructureItems structureItem : structureItems) {
            Long id;
            if (!HussarUtils.isNotEmpty((Object)structureItem.getQuoteStructureId()) || list.contains(id = Long.valueOf(structureItem.getQuoteStructureId()))) continue;
            StructureVersion item = (StructureVersion)this.structureVersionService.getById((Serializable)id);
            StructureDto structureDto = new StructureDto();
            BeanUtil.copyProperties((Object)item, (Object)structureDto);
            structureDto.setItems(this.toStructureItems(item.getStructureValues()));
            versions.add(structureDto);
            list.add(id);
            if (!HussarUtils.isNotEmpty((Object)item.getStructureValues())) continue;
            this.structureValues(item.getStructureValues(), list, versions);
        }
    }

    private List<StructureItems> strToItemsList(String listStr) {
        JSONArray array = JSON.parseArray((String)listStr);
        if (HussarUtils.isEmpty((Object)array)) {
            return Collections.emptyList();
        }
        ArrayList<StructureItems> value = new ArrayList<StructureItems>();
        for (Object arr : array) {
            StructureItems items = (StructureItems)JSON.parseObject((String)JSONObject.toJSONString(arr), StructureItems.class);
            value.add(items);
        }
        return value;
    }

    private void getStructureIds(List<EaiParamsItems> items, List<Long> list) {
        if (HussarUtils.isNotEmpty(items)) {
            for (EaiParamsItems item : items) {
                Long id;
                if (HussarUtils.isNotEmpty((Object)item.getQuoteStructureId()) && !list.contains(id = Long.valueOf(Long.parseLong(item.getQuoteStructureId())))) {
                    list.add(id);
                }
                if (!HussarUtils.isNotEmpty((Object)item.getItems())) continue;
                this.getStructureIds(item.getItems(), list);
            }
        }
    }

    private List<Long> getStructureIds(EaiParamsTestConvertDto dto) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)dto.getQuery())) {
            this.getStructureIds(dto.getQuery(), list);
        }
        if (HussarUtils.isNotEmpty((Object)dto.getHeader())) {
            this.getStructureIds(dto.getHeader(), list);
        }
        if (HussarUtils.isNotEmpty((Object)dto.getBody())) {
            this.getStructureIds(dto.getBody(), list);
        }
        return list;
    }

    private List<EaiApiParamsItem> fillBaseOutInfo(List<EaiApiParamsItem> outParam) {
        ArrayList<EaiApiParamsItem> result = new ArrayList<EaiApiParamsItem>();
        EaiApiParamsItem code = new EaiApiParamsItem();
        EaiApiParamsItem data = new EaiApiParamsItem();
        EaiApiParamsItem msg = new EaiApiParamsItem();
        EaiApiParamsItem success = new EaiApiParamsItem();
        code.setName("code");
        code.setType(Integer.valueOf(1));
        code.setItemType(null);
        code.setMark("code");
        code.setMapping("1");
        code.setMappingName("code");
        code.setQuoteStructureId(null);
        code.setItems(Collections.emptyList());
        data.setName("data");
        data.setMappingName("data");
        if (HussarUtils.isEmpty(outParam)) {
            data.setType(Integer.valueOf(7));
            data.setItemType(null);
            data.setMark("data");
            data.setMapping("1");
            data.setQuoteStructureId(null);
            data.setItems(Collections.emptyList());
        } else {
            EaiApiParamsItem paramsItem = new EaiApiParamsItem();
            BeanUtil.copyProperties((Object)outParam.get(0), (Object)paramsItem);
            data.setType(paramsItem.getType());
            data.setItemType(paramsItem.getItemType());
            data.setMark(paramsItem.getMark());
            data.setMapping(paramsItem.getMapping());
            data.setQuoteStructureId(paramsItem.getQuoteStructureId());
            data.setItems(BeanUtil.copyProperties((Collection)paramsItem.getItems(), EaiApiParamsItem.class));
        }
        msg.setName("msg");
        msg.setType(Integer.valueOf(4));
        msg.setItemType(null);
        msg.setMark("msg");
        msg.setMapping("1");
        msg.setMappingName("msg");
        msg.setQuoteStructureId(null);
        msg.setItems(Collections.emptyList());
        success.setName("success");
        success.setType(Integer.valueOf(0));
        success.setItemType(null);
        success.setMark("success");
        success.setMapping("1");
        success.setMappingName("success");
        success.setQuoteStructureId(null);
        success.setItems(Collections.emptyList());
        result.add(code);
        result.add(data);
        result.add(msg);
        result.add(success);
        return result;
    }
}

