/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.manager.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.sysapi.api.bo.PageQueryBo;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.DataQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.util.EaiSqlUtil;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiCommonBusinessManager;

public class EaiSqlServerBusinessManagerImpl
extends EaiCommonBusinessManager {
    private static volatile EaiSqlServerBusinessManagerImpl instance;
    private static final String SQLSERVER_SQL = "SELECT o.name AS tableName, CAST(( SELECT DATABASEPROPERTYEX(DB_NAME(), 'Collation') ) AS VARCHAR(64)) AS encoding, CAST(ep.value AS VARCHAR(512)) AS tableComment FROM sys.objects o LEFT JOIN sys.extended_properties ep ON o.object_id = ep.major_id AND ep.minor_id = 0 AND ep.name = 'MS_Description' WHERE o.type = 'U';";
    private static final String SQLSERVER_FIELD_SQL = "SELECT c.name AS fieldName, sc.DATA_TYPE AS fieldType, sc.CHARACTER_MAXIMUM_LENGTH AS length, sc.IS_NULLABLE AS nullAble, sc.COLUMN_DEFAULT AS defaultVal, t.name AS tableName, CAST(ep.value AS VARCHAR(512)) AS fieldComment FROM sys.columns c JOIN sys.objects t ON c.object_id = t.object_id LEFT JOIN sys.extended_properties ep ON c.object_id = ep.major_id AND c.column_id = ep.minor_id AND ep.name = 'MS_Description' LEFT JOIN INFORMATION_SCHEMA.COLUMNS sc on sc.COLUMN_NAME = c.name AND sc.TABLE_NAME = t.name WHERE t.type = 'U' AND t.name = '%s';";

    private EaiSqlServerBusinessManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaiSqlServerBusinessManagerImpl getInstance() {
        if (instance != null) return instance;
        Class<EaiSqlServerBusinessManagerImpl> clazz = EaiSqlServerBusinessManagerImpl.class;
        synchronized (EaiSqlServerBusinessManagerImpl.class) {
            if (instance != null) return instance;
            instance = new EaiSqlServerBusinessManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getTableSchemaSql(String schema, String pattern) {
        return SQLSERVER_SQL;
    }

    @Override
    public String getFieldSchemaSql(String schema, String tableName) {
        return String.format(SQLSERVER_FIELD_SQL, tableName);
    }

    @Override
    public String formatSql(DataQueryDto dataQueryDto) {
        PageQueryBo pageQueryBo = super.getPageQueryBo(dataQueryDto.getPageQuery());
        long limit = pageQueryBo.getLimit();
        long current = pageQueryBo.getCurrent();
        String sql = super.commonFormatSql(dataQueryDto);
        long offset = (current - 1L) * limit;
        StringBuilder sb = new StringBuilder();
        sb.append(sql).append(" ORDER BY ").append(ToolUtil.isNotEmpty((Object)dataQueryDto.getSortColumn()) ? dataQueryDto.getSortColumn() : (String)dataQueryDto.getField().get(0)).append(" OFFSET ").append(offset).append(" ROWS FETCH NEXT ").append(limit).append(" ROWS ONLY");
        return EaiSqlUtil.keyWordsCheck((String)sb.toString());
    }
}

