/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.manager.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.sysapi.api.bo.PageQueryBo;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.DataQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.util.EaiSqlUtil;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiCommonBusinessManager;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public class EaiPostgreBusinessManagerImpl
extends EaiCommonBusinessManager {
    private static volatile EaiPostgreBusinessManagerImpl instance;
    private static final String POSTGRESQL_SQL = "SELECT tb.table_name AS tableName, ( select pg_encoding_to_char(encoding) from pg_database where datname = '%s' ) as encoding, d.description as tableComment FROM information_schema.tables tb LEFT JOIN pg_class c ON c.relname = tb.table_name LEFT JOIN pg_description d ON d.objoid = c.oid AND d.objsubid = '0' WHERE tb.table_schema = '%s' and c.relkind = 'r';";
    private static final String POSTGRESQL_FIELD_SQL = "SELECT A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE C.RELNAME = '%s' AND A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;";

    private EaiPostgreBusinessManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaiPostgreBusinessManagerImpl getInstance() {
        if (instance != null) return instance;
        Class<EaiPostgreBusinessManagerImpl> clazz = EaiPostgreBusinessManagerImpl.class;
        synchronized (EaiPostgreBusinessManagerImpl.class) {
            if (instance != null) return instance;
            instance = new EaiPostgreBusinessManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getKeyByDbType(String key) {
        if (ToolUtil.isEmpty((Object)key)) {
            return null;
        }
        return key.toLowerCase();
    }

    @Override
    public String getTableSchemaSql(String schema, String pattern) {
        return String.format(POSTGRESQL_SQL, schema, pattern);
    }

    @Override
    public String getFieldSchemaSql(String schema, String tableName) {
        return String.format(POSTGRESQL_FIELD_SQL, tableName);
    }

    @Override
    public String formatSql(DataQueryDto dataQueryDto) {
        PageQueryBo pageQueryBo = super.getPageQueryBo(dataQueryDto.getPageQuery());
        long limit = pageQueryBo.getLimit();
        long current = pageQueryBo.getCurrent();
        String sql = super.commonFormatSql(dataQueryDto);
        long offset = (current - 1L) * limit;
        StringBuilder sb = new StringBuilder();
        sb.append(sql);
        if (HussarUtils.isNotEmpty((Object)dataQueryDto.getSortColumn())) {
            sb.append(" ORDER BY ").append(dataQueryDto.getSortColumn());
        }
        sb.append(" LIMIT ").append(limit).append(" OFFSET ").append(offset);
        return EaiSqlUtil.keyWordsCheck((String)sb.toString());
    }
}

