/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.manager.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.DataQueryDto;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiCommonBusinessManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.sql.TIMESTAMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EaiOracleBusinessManagerImpl
extends EaiCommonBusinessManager {
    private static volatile EaiOracleBusinessManagerImpl instance;
    private static final Logger LOGGER;
    private static final String ORACLE_SQL = "SELECT d.TABLE_NAME AS  tableName ,  (SELECT VALUE FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER = 'NLS_CHARACTERSET') AS encoding , a.COMMENTS AS tableComment FROM  DBA_TABLES d LEFT JOIN USER_TAB_COMMENTS a ON d.TABLE_NAME = a.TABLE_NAME WHERE d.OWNER = '%s'";
    private static final String ORACLE_FIELD_SQL = "SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'";

    private EaiOracleBusinessManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaiOracleBusinessManagerImpl getInstance() {
        if (instance != null) return instance;
        Class<EaiOracleBusinessManagerImpl> clazz = EaiOracleBusinessManagerImpl.class;
        synchronized (EaiOracleBusinessManagerImpl.class) {
            if (instance != null) return instance;
            instance = new EaiOracleBusinessManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getSchemaFromDto(SysDataSourceDto dataSourceDto) {
        if (ToolUtil.isEmpty((Object)dataSourceDto)) {
            return null;
        }
        return dataSourceDto.getUserName();
    }

    @Override
    public String getKeyByDbType(String key) {
        if (ToolUtil.isEmpty((Object)key)) {
            return null;
        }
        return key.toUpperCase();
    }

    @Override
    public String getTableSchemaSql(String schema, String pattern) {
        return String.format(ORACLE_SQL, schema);
    }

    @Override
    public String getFieldSchemaSql(String schema, String tableName) {
        return String.format(ORACLE_FIELD_SQL, tableName);
    }

    @Override
    public String formatSql(DataQueryDto dataQueryDto) {
        return super.oracleLikeFormatSql(dataQueryDto);
    }

    @Override
    public void resultDataTypeTransform(List<HashMap<String, Object>> datas) {
        if (ToolUtil.isEmpty(datas)) {
            return;
        }
        for (HashMap<String, Object> data : datas) {
            Set<String> keys = data.keySet();
            for (String key : keys) {
                Object value = data.get(key);
                if (!ToolUtil.isNotEmpty((Object)value) || !(value instanceof TIMESTAMP)) continue;
                try {
                    data.put(key, ((TIMESTAMP)value).toLocalDateTime());
                }
                catch (SQLException e) {
                    LOGGER.error("Oracle\u65f6\u95f4\u7c7b\u578b\u5b57\u6bb5\u8f6c\u6362\u51fa\u9519", (Throwable)e);
                }
            }
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(EaiOracleBusinessManagerImpl.class);
    }
}

