/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.manager.impl;

import com.jxdinfo.hussar.eai.sysapi.api.bo.PageQueryBo;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.DataQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.util.EaiSqlUtil;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiCommonBusinessManager;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public class EaiMysqlBusinessManagerImpl
extends EaiCommonBusinessManager {
    private static volatile EaiMysqlBusinessManagerImpl instance;
    private static final String MYSQL_SQL = "SELECT TABLE_NAME AS  tableName , TABLE_COLLATION AS  encoding , TABLE_COMMENT AS  tableComment  FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '%s' AND TABLE_TYPE = 'BASE TABLE';";
    private static final String MYSQL_FIELD_SQL = "SELECT COLUMN_NAME AS fieldName, COLUMN_TYPE AS fieldType, CHARACTER_MAXIMUM_LENGTH  AS length,IS_NULLABLE AS nullAble, COLUMN_DEFAULT AS defaultVal, COLUMN_COMMENT as fieldComment FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s';";

    private EaiMysqlBusinessManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaiMysqlBusinessManagerImpl getInstance() {
        if (instance != null) return instance;
        Class<EaiMysqlBusinessManagerImpl> clazz = EaiMysqlBusinessManagerImpl.class;
        synchronized (EaiMysqlBusinessManagerImpl.class) {
            if (instance != null) return instance;
            instance = new EaiMysqlBusinessManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getTableSchemaSql(String schema, String pattern) {
        return String.format(MYSQL_SQL, schema);
    }

    @Override
    public String getFieldSchemaSql(String schema, String tableName) {
        return String.format(MYSQL_FIELD_SQL, schema, tableName);
    }

    @Override
    public String formatSql(DataQueryDto dataQueryDto) {
        PageQueryBo pageQueryBo = super.getPageQueryBo(dataQueryDto.getPageQuery());
        long limit = pageQueryBo.getLimit();
        long current = pageQueryBo.getCurrent();
        String sql = super.commonFormatSql(dataQueryDto);
        long offset = (current - 1L) * limit;
        StringBuilder sb = new StringBuilder();
        sb.append(sql);
        if (HussarUtils.isNotEmpty((Object)dataQueryDto.getSortColumn())) {
            sb.append(" ORDER BY ").append(dataQueryDto.getSortColumn());
        }
        sb.append(" LIMIT ").append(limit).append(" OFFSET ").append(offset);
        return EaiSqlUtil.keyWordsCheck((String)sb.toString());
    }
}

