/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.manager.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.DataQueryDto;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiCommonBusinessManager;

public class EaiKingbaseBusinessManagerImpl
extends EaiCommonBusinessManager {
    private static volatile EaiKingbaseBusinessManagerImpl instance;
    private static final String KINGBASE_SQL = "SELECT t1.table_name AS tableName, (SELECT setting FROM pg_settings WHERE name = 'client_encoding') AS encoding, t2.description AS tableComment FROM information_schema.TABLES t1 left join (select * from pg_description where objsubid = 0) t2 on t1.table_name::regclass::oid = t2.objoid WHERE t1.table_schema = 'public' AND t1.table_type = 'BASE TABLE';";
    private static final String KINGBASE_FIELD_SQL = "SELECT t1.COLUMN_NAME AS fieldName, t1.DATA_TYPE AS fieldType, t1.CHARACTER_MAXIMUM_LENGTH  AS length, t1.IS_NULLABLE AS nullAble, t1.COLUMN_DEFAULT AS defaultVal, t2.DESCRIPTION as tableComment FROM INFORMATION_SCHEMA.COLUMNS t1 LEFT JOIN PG_DESCRIPTION t2 on t1.DTD_IDENTIFIER = t2.OBJSUBID::text and t2.OBJOID = t1.TABLE_NAME::regclass::oid WHERE t1.TABLE_NAME = '%s';";

    private EaiKingbaseBusinessManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaiKingbaseBusinessManagerImpl getInstance() {
        if (instance != null) return instance;
        Class<EaiKingbaseBusinessManagerImpl> clazz = EaiKingbaseBusinessManagerImpl.class;
        synchronized (EaiKingbaseBusinessManagerImpl.class) {
            if (instance != null) return instance;
            instance = new EaiKingbaseBusinessManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getSchemaFromDto(SysDataSourceDto dataSourceDto) {
        if (ToolUtil.isEmpty((Object)dataSourceDto)) {
            return null;
        }
        return dataSourceDto.getUserName();
    }

    @Override
    public String getKeyByDbType(String key) {
        if (ToolUtil.isEmpty((Object)key)) {
            return null;
        }
        return key.toLowerCase();
    }

    @Override
    public String getTableSchemaSql(String schema, String pattern) {
        return KINGBASE_SQL;
    }

    @Override
    public String getFieldSchemaSql(String schema, String tableName) {
        return String.format(KINGBASE_FIELD_SQL, tableName);
    }

    @Override
    public String formatSql(DataQueryDto dataQueryDto) {
        return super.oracleLikeFormatSql(dataQueryDto);
    }
}

