/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.manager.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.eai.sysapi.api.bo.PageQueryBo;
import com.jxdinfo.hussar.eai.sysapi.api.dto.PageQuery;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.DataQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.sql.util.EaiSqlUtil;
import com.jxdinfo.hussar.eai.sysapi.server.manager.EaiDbBusinessManager;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;

public abstract class EaiCommonBusinessManager
implements EaiDbBusinessManager {
    @Override
    public String getSchemaFromDto(SysDataSourceDto dataSourceDto) {
        if (ToolUtil.isEmpty((Object)dataSourceDto)) {
            return null;
        }
        return dataSourceDto.getDataBaseName();
    }

    @Override
    public String getKeyByDbType(String key) {
        return key;
    }

    @Override
    public PageQueryBo getPageQueryBo(PageQuery pageQuery) {
        long current;
        long limit;
        if (pageQuery == null) {
            limit = 1000L;
            current = 1L;
        } else {
            long l = limit = HussarUtils.isEmpty((Object)pageQuery.getSize()) ? 10L : pageQuery.getSize();
            if (limit > 1000L) {
                limit = 1000L;
            }
            current = HussarUtils.isEmpty((Object)pageQuery.getCurrent()) ? 1L : pageQuery.getCurrent();
        }
        return new PageQueryBo(current, limit);
    }

    @Override
    public void resultDataTypeTransform(List<HashMap<String, Object>> datas) {
    }

    protected String commonFormatSql(DataQueryDto dataQueryDto) {
        List fields = dataQueryDto.getField();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < fields.size(); ++i) {
            if (i != fields.size() - 1) {
                sb.append((String)fields.get(i)).append(", ");
                continue;
            }
            sb.append((String)fields.get(i));
        }
        sb.append(" FROM ").append(dataQueryDto.getTableName());
        if (HussarUtils.isNotEmpty((Object)dataQueryDto.getWhereField())) {
            EaiSqlUtil.keyWordsCheck((String)dataQueryDto.getWhereField());
            sb.append(" WHERE ").append(dataQueryDto.getWhereField());
        }
        return sb.toString();
    }

    protected String oracleLikeFormatSql(DataQueryDto dataQueryDto) {
        PageQueryBo pageQueryBo = this.getPageQueryBo(dataQueryDto.getPageQuery());
        long limit = pageQueryBo.getLimit();
        long current = pageQueryBo.getCurrent();
        String sql = this.commonFormatSql(dataQueryDto);
        long offset = (current - 1L) * limit;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        List fields = dataQueryDto.getField();
        for (int i = 0; i < fields.size(); ++i) {
            if (i != fields.size() - 1) {
                sb.append((String)fields.get(i)).append(", ");
                continue;
            }
            sb.append((String)fields.get(i));
        }
        sb.append(" FROM ( SELECT ROW_NUMBER() OVER(ORDER BY ").append(ToolUtil.isNotEmpty((Object)dataQueryDto.getSortColumn()) ? dataQueryDto.getSortColumn() : (String)dataQueryDto.getField().get(0)).append(" ) rn,").append(sql.trim().startsWith("SELECT") ? sql.replaceFirst("SELECT", "") : sql).append(" ) EAI_SQL_SDK_Q ").append(" WHERE EAI_SQL_SDK_Q.rn BETWEEN ").append(offset).append(" AND ").append(current * limit);
        return EaiSqlUtil.keyWordsCheck((String)sb.toString());
    }
}

