/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.factory;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.sysapi.server.manager.EaiDbBusinessManager;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiDmBusinessManagerImpl;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiKingbaseBusinessManagerImpl;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiMysqlBusinessManagerImpl;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiOracleBusinessManagerImpl;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiOscarBusinessManagerImpl;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiPostgreBusinessManagerImpl;
import com.jxdinfo.hussar.eai.sysapi.server.manager.impl.EaiSqlServerBusinessManagerImpl;

public class EaiDbBusinessFactory {
    private static final String ERROR_MSG_TYPE = "\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERROR_MSG = "\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b%s";

    public static EaiDbBusinessManager getByDbType(String dbType) {
        if (ToolUtil.isEmpty((Object)dbType)) {
            throw new BaseException(ERROR_MSG_TYPE);
        }
        switch (dbType.toLowerCase()) {
            case "mysql": {
                return EaiMysqlBusinessManagerImpl.getInstance();
            }
            case "postgresql": {
                return EaiPostgreBusinessManagerImpl.getInstance();
            }
            case "sqlserver": {
                return EaiSqlServerBusinessManagerImpl.getInstance();
            }
            case "kingbase8": {
                return EaiKingbaseBusinessManagerImpl.getInstance();
            }
            case "oracle": {
                return EaiOracleBusinessManagerImpl.getInstance();
            }
            case "oscar": {
                return EaiOscarBusinessManagerImpl.getInstance();
            }
            case "dm": {
                return EaiDmBusinessManagerImpl.getInstance();
            }
        }
        throw new BaseException(String.format(ERROR_MSG, dbType));
    }
}

