/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.api.sql.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.sysapi.api.dto.PageQuery;
import com.jxdinfo.hussar.eai.sysapi.api.sql.dto.DataQueryDto;
import com.jxdinfo.hussar.platform.core.utils.HexUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EaiSqlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiSqlUtil.class);
    private static final String MYSQL_SQL = "SELECT TABLE_NAME AS  tableName , TABLE_COLLATION AS  encoding , TABLE_COMMENT AS  tableComment  FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '%s';";
    private static final String ORACLE_SQL = "SELECT d.TABLE_NAME AS  tableName ,  (SELECT VALUE FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER = 'NLS_CHARACTERSET') AS encoding , a.COMMENTS AS tableComment FROM  DBA_TABLES d LEFT JOIN USER_TAB_COMMENTS a ON d.TABLE_NAME = a.TABLE_NAME WHERE d.OWNER = '%s'";
    private static final String POSTGRESQL_SQL = "SELECT tb.table_name AS tableName, ( select pg_encoding_to_char(encoding) from pg_database where datname = '%s' ) as encoding, d.description as tableComment FROM information_schema.tables tb LEFT JOIN pg_class c ON c.relname = tb.table_name LEFT JOIN pg_description d ON d.objoid = c.oid AND d.objsubid = '0' WHERE tb.table_schema = 'public' and c.relkind = 'r';";
    private static final String SQLSERVER_SQL = "SELECT o.name AS tableName, CAST(( SELECT DATABASEPROPERTYEX(DB_NAME(), 'Collation') ) AS VARCHAR(64)) AS encoding, CAST(ep.value AS VARCHAR(512)) AS tableComment FROM sys.objects o LEFT JOIN sys.extended_properties ep ON o.object_id = ep.major_id AND ep.minor_id = 0 AND ep.name = 'MS_Description' WHERE o.type = 'U';";
    private static final String KINGBASE_SQL = "SELECT upper(c.relname) AS tableName, (SELECT current_setting('server_encoding')) AS encoding , a.COMMENTS AS tableComment FROM sys_class c LEFT JOIN all_tab_comments a ON upper(c.relname) = upper(a.table_name) AND a.OWNER = '%s' WHERE c.relkind = 'r' AND c.relnamespace = (SELECT oid FROM sys_namespace WHERE nspname = 'public');";
    private static final String DB2_SQL = "SELECT TABNAME AS tableName, REMARKS AS comment  FROM SYSIBM.SYSTABLES WHERE TABSCHEMA = '%s';";
    private static final String OSCAR_SQL = "SELECT d.TABLE_NAME AS  tableName ,  ( SELECT SYS_ENCODING_TO_CHAR(ENCODING)  FROM V_SYS_DATABASE ) AS encoding , a.COMMENTS AS tableComment FROM  DBA_TABLES d LEFT JOIN USER_TAB_COMMENTS a ON d.TABLE_NAME = a.TABLE_NAME WHERE d.OWNER = '%s'";
    private static final String HIGHGO_SQL = "SELECT tb.table_name AS tableName, ( select pg_encoding_to_char(encoding) from pg_database where datname = '%s' ) as encoding, d.description as tableComment FROM information_schema.tables tb LEFT JOIN pg_class c ON c.relname = tb.table_name LEFT JOIN pg_description d ON d.objoid = c.oid AND d.objsubid = '0' WHERE tb.table_schema = 'public' and c.relkind = 'r'";
    private static final String DM_SQL = "SELECT d.TABLE_NAME AS  tableName ,  ( SELECT DECODE(UNICODE\uff0c'0'\uff0c'GB18030'\uff0c'1'\uff0c'UTF-8'\uff0c'2'\uff0c'EUC-KR') ) AS encoding , a.COMMENTS AS tableComment FROM  DBA_TABLES d LEFT JOIN USER_TAB_COMMENTS a ON d.TABLE_NAME = a.TABLE_NAME WHERE d.OWNER = '%s'";
    private static final String ERROR_MSG = "\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b%s,\u6570\u636e\u5e93\u540d\u79f0%s";
    private static final String ERROR_MSG_TYPE = "\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String MYSQL_FIELD_SQL = "SELECT COLUMN_NAME AS fieldName, COLUMN_TYPE AS fieldType, CHARACTER_MAXIMUM_LENGTH  AS length,IS_NULLABLE AS nullAble, COLUMN_DEFAULT AS defaultVal, COLUMN_COMMENT as fieldComment FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s';";
    private static final String ORACLE_FIELD_SQL = "SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'";
    private static final String POSTGRESQL_FIELD_SQL = "SELECT A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE C.RELNAME = '%s' AND A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;";
    private static final String SQLSERVER_FIELD_SQL = "SELECT c.name AS fieldName, sc.DATA_TYPE AS fieldType, sc.CHARACTER_MAXIMUM_LENGTH AS length, sc.IS_NULLABLE AS nullAble, sc.COLUMN_DEFAULT AS defaultVal, t.name AS tableName, CAST(ep.value AS VARCHAR(512)) AS fieldComment FROM sys.columns c JOIN sys.objects t ON c.object_id = t.object_id LEFT JOIN sys.extended_properties ep ON c.object_id = ep.major_id AND c.column_id = ep.minor_id AND ep.name = 'MS_Description' LEFT JOIN INFORMATION_SCHEMA.COLUMNS sc on sc.COLUMN_NAME = c.name AND sc.TABLE_NAME = t.name WHERE t.type = 'U' AND t.name = '%s';";
    private static final String KINGBASE_FIELD_SQL = "SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'";
    private static final String DB2_FIELD_SQL = "SELECT COLNAME AS fieldName, TYPENAME AS fieldType, LENGTH AS length, NULLS AS nullAble, DEFAULT AS defaultVal, REMARKS AS comment FROM SYSCAT.COLUMNS  WHERE TABSCHEMA ='%s' AND TABNAME = '%s';";
    private static final String OSCAR_FIELD_SQL = "SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'";
    private static final String DM_FIELD_SQL = "SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'";
    private static final String HIGHGO_FIELD_SQL = "SELECT A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE C.RELNAME = '%s' AND A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;";
    private static final String MYSQL_SCHEMA_SQL = "SELECT TABLE_NAME AS tableName, COLUMN_NAME AS fieldName, COLUMN_TYPE AS fieldType, CHARACTER_MAXIMUM_LENGTH  AS length,IS_NULLABLE AS nullAble, COLUMN_DEFAULT AS defaultVal, COLUMN_COMMENT as fieldComment FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '%s';";
    private static final String ORACLE_SCHEMA_SQL = "SELECT A.TABLE_NAME AS tableName,  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ";
    private static final String POSTGRESQL_SCHEMA_SQL = "SELECT C.RELNAME AS tableName, A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE   A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;";
    private static final String SQLSERVER_SCHEMA_SQL = "SELECT c.name AS fieldName, sc.DATA_TYPE AS fieldType, sc.CHARACTER_MAXIMUM_LENGTH AS length, sc.IS_NULLABLE AS nullAble, sc.COLUMN_DEFAULT AS defaultVal, t.name AS tableName, CAST(ep.value AS VARCHAR(512)) AS fieldComment FROM sys.columns c JOIN sys.objects t ON c.object_id = t.object_id LEFT JOIN sys.extended_properties ep ON c.object_id = ep.major_id AND c.column_id = ep.minor_id AND ep.name = 'MS_Description' LEFT JOIN INFORMATION_SCHEMA.COLUMNS sc on sc.COLUMN_NAME = c.name AND sc.TABLE_NAME = t.name WHERE t.type = 'U';";
    private static final String KINGBASE_SCHEMA_SQL = "SELECT A.TABLE_NAME AS tableName,  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ";
    private static final String DB2_SCHEMA_SQL = "SELECT TABNAME AS tableName, COLNAME AS fieldName, TYPENAME AS fieldType, LENGTH AS length, NULLS AS nullAble, DEFAULT AS defaultVal, REMARKS AS comment FROM SYSCAT.COLUMNS  WHERE TABSCHEMA ='%s' ;";
    private static final String OSCAR_SCHEMA_SQL = "SELECT A.TABLE_NAME AS tableName,  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ";
    private static final String DM_SCHEMA_SQL = "SELECT A.TABLE_NAME AS tableName,  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME";
    private static final String HIGHGO_SCHEMA_SQL = "SELECT C.RELNAME AS tableName, A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE   A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;";
    public static final long MAX_QUERY_NUM = 1000L;
    private static final String regex = "\\b(UPDATE|INSERT|DELETE|DROP|TRUNCATE|ALTER)\\b";
    private static final String CHECK_ERROR = "\u5165\u53c2\u5f02\u5e38";

    public static String getTableSchemaSql(String dbType, String schema) {
        if (HussarUtils.isEmpty((Object)dbType) || HussarUtils.isEmpty((Object)schema)) {
            throw new BaseException(ERROR_MSG_TYPE);
        }
        switch (dbType.toLowerCase()) {
            case "mysql": {
                return String.format(MYSQL_SQL, schema);
            }
            case "oracle": {
                return String.format(ORACLE_SQL, schema);
            }
            case "postgresql": {
                return String.format(POSTGRESQL_SQL, schema);
            }
            case "sqlserver": {
                return SQLSERVER_SQL;
            }
            case "kingbase8": {
                return String.format(KINGBASE_SQL, schema);
            }
            case "oscar": {
                return String.format(OSCAR_SQL, schema);
            }
            case "dm": {
                return String.format(DM_SQL, schema);
            }
            case "highgo": {
                return String.format(HIGHGO_SQL, schema);
            }
        }
        throw new BaseException(String.format(ERROR_MSG, dbType, schema));
    }

    public static String getFieldSchemaSql(String dbType, String schema) {
        if (HussarUtils.isEmpty((Object)dbType) || HussarUtils.isEmpty((Object)schema)) {
            throw new BaseException(ERROR_MSG_TYPE);
        }
        switch (dbType.toLowerCase()) {
            case "mysql": {
                return String.format(MYSQL_SCHEMA_SQL, schema);
            }
            case "oracle": {
                return "SELECT A.TABLE_NAME AS tableName,  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ";
            }
            case "postgresql": {
                return "SELECT C.RELNAME AS tableName, A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE   A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;";
            }
            case "sqlserver": {
                return SQLSERVER_SCHEMA_SQL;
            }
            case "kingbase8": {
                return "SELECT A.TABLE_NAME AS tableName,  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ";
            }
            case "oscar": {
                return "SELECT A.TABLE_NAME AS tableName,  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ";
            }
            case "dm": {
                return DM_SCHEMA_SQL;
            }
            case "highgo": {
                return "SELECT C.RELNAME AS tableName, A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE   A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;";
            }
        }
        throw new BaseException(String.format(ERROR_MSG, dbType, schema));
    }

    public static String getFieldSchemaSql(String dbType, String schema, String tableName) {
        if (HussarUtils.isEmpty((Object)dbType) || HussarUtils.isEmpty((Object)schema)) {
            throw new BaseException(ERROR_MSG_TYPE);
        }
        switch (dbType.toLowerCase()) {
            case "mysql": {
                return String.format(MYSQL_FIELD_SQL, schema, tableName);
            }
            case "oracle": {
                return String.format("SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'", tableName);
            }
            case "postgresql": {
                return String.format("SELECT A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE C.RELNAME = '%s' AND A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;", tableName);
            }
            case "sqlserver": {
                return String.format(SQLSERVER_FIELD_SQL, tableName);
            }
            case "kingbase8": {
                return String.format("SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'", tableName);
            }
            case "oscar": {
                return String.format("SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'", tableName);
            }
            case "dm": {
                return String.format("SELECT  A.COLUMN_NAME AS fieldName,  A.DATA_TYPE AS fieldType,  A.DATA_LENGTH AS length,  A.NULLABLE AS nullAble,  A.DATA_DEFAULT  AS defaultVal,B.COMMENTS AS fieldComment FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME  WHERE A.TABLE_NAME = '%s'", tableName);
            }
            case "highgo": {
                return String.format("SELECT A.ATTNAME AS fieldName, FORMAT_TYPE ( A.ATTTYPID, A.ATTTYPMOD ) AS fieldType,  NULLIF(INFORMATION_SCHEMA._PG_CHAR_MAX_LENGTH(A.ATTTYPID, A.ATTTYPMOD), -1) AS length, A.ATTNOTNULL AS nullAble , A.ATTHASDEF  AS defaultVal, COL_DESCRIPTION ( A.ATTRELID, A.ATTNUM ) AS fieldComment FROM PG_CLASS AS C, PG_ATTRIBUTE AS A , PG_TYPE AS T WHERE C.RELNAME = '%s' AND A.ATTRELID = C.OID AND A.ATTTYPID= T.OID AND A.ATTNUM > 0 AND NOT A.ATTISDROPPED;", tableName);
            }
        }
        throw new BaseException(String.format(ERROR_MSG, dbType, schema));
    }

    public static Boolean transformNullAble(String nullAble) {
        switch (nullAble) {
            case "YES": 
            case "Y": {
                return true;
            }
        }
        return false;
    }

    public static String formatSql(String dbType, DataQueryDto dataQueryDto) {
        long current;
        long limit;
        PageQuery pageQuery = dataQueryDto.getPageQuery();
        String sortColumn = dataQueryDto.getSortColumn();
        if (pageQuery == null) {
            limit = 1000L;
            current = 1L;
        } else {
            long l = limit = HussarUtils.isEmpty((Object)pageQuery.getSize()) ? 10L : pageQuery.getSize();
            if (limit > 1000L) {
                limit = 1000L;
            }
            current = HussarUtils.isEmpty((Object)pageQuery.getCurrent()) ? 1L : pageQuery.getCurrent();
        }
        List<String> fields = dataQueryDto.getField();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < fields.size(); ++i) {
            if (i != fields.size() - 1) {
                sb.append(fields.get(i)).append(", ");
                continue;
            }
            sb.append(fields.get(i));
        }
        sb.append(" FROM ").append(dataQueryDto.getTableName());
        if (HussarUtils.isNotEmpty((Object)dataQueryDto.getWhereField())) {
            EaiSqlUtil.keyWordsCheck(dataQueryDto.getWhereField());
            sb.append(" WHERE ").append(dataQueryDto.getWhereField());
        }
        return EaiSqlUtil.pageSql(dbType, sb.toString(), sortColumn, current, limit, fields);
    }

    public static String keyWordsCheck(String sql) {
        return sql.replaceAll(regex, "");
    }

    public static String formatCountSql(DataQueryDto dataQueryDto) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(1) AS count FROM ").append(dataQueryDto.getTableName());
        if (HussarUtils.isNotEmpty((Object)dataQueryDto.getWhereField())) {
            EaiSqlUtil.keyWordsCheck(dataQueryDto.getWhereField());
            sb.append(" WHERE ").append(dataQueryDto.getWhereField());
        }
        return EaiSqlUtil.keyWordsCheck(sb.toString());
    }

    private static String pageSql(String dbType, String sql, String sortColumn, long current, long limit, List<String> fields) {
        long offset = (current - 1L) * limit;
        StringBuilder sb = new StringBuilder();
        switch (dbType) {
            case "mysql": 
            case "postgresql": {
                sb.append(sql);
                if (HussarUtils.isNotEmpty((Object)sortColumn)) {
                    sb.append(" ORDER BY ").append(sortColumn);
                }
                sb.append(" LIMIT ").append(limit).append(" OFFSET ").append(offset);
                return EaiSqlUtil.keyWordsCheck(sb.toString());
            }
            case "kingbase8": 
            case "dm": 
            case "oscar": 
            case "oracle": {
                sb.append("SELECT * FROM ( SELECT ROW_NUMBER() OVER(ORDER BY ").append(ToolUtil.isNotEmpty((Object)sortColumn) ? sortColumn : fields.get(0)).append(" ) rn,").append(sql.trim().startsWith("SELECT") ? sql.replaceFirst("SELECT", "") : sql).append(" ) EAI_SQL_SDK_Q ").append(" WHERE EAI_SQL_SDK_Q.rn BETWEEN ").append(offset).append(" AND ").append(current * limit);
                return EaiSqlUtil.keyWordsCheck(sb.toString());
            }
            case "sqlserver": {
                sb.append(sql).append(" ORDER BY ").append(ToolUtil.isNotEmpty((Object)sortColumn) ? sortColumn : fields.get(0)).append(" OFFSET ").append(offset).append(" ROWS FETCH NEXT ").append(limit).append(" ROWS ONLY");
                return EaiSqlUtil.keyWordsCheck(sb.toString());
            }
        }
        throw new BaseException(String.format(ERROR_MSG, dbType, null));
    }

    public static void pageSqlCheck(String sql) {
        String lowerSql;
        if (HussarUtils.isNotEmpty((Object)sql) && ((lowerSql = sql.toLowerCase()).contains(" limit ") || lowerSql.contains(" rows only ") || lowerSql.contains(" between "))) {
            return;
        }
        throw new BaseException("\u53ea\u652f\u6301\u5206\u9875\u67e5\u8be2");
    }

    public static String getQuerySql(String sql) {
        Map map = (Map)JSON.parseObject((String)sql, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String query = (String)map.get("query");
        String sign = (String)map.get("sign");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String check = HexUtil.encodeHexStr((byte[])messageDigest.digest(query.getBytes(StandardCharsets.UTF_8)));
            if (check.equals(sign)) {
                return HexUtil.decodeHexStr((String)query);
            }
            throw new BaseException(CHECK_ERROR);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BaseException(CHECK_ERROR);
        }
    }
}

