/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.client.sdk.common.service;

import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkInvokeParams;
import com.jxdinfo.hussar.eai.client.sdk.api.service.EaiClientTokenApiSdkService;
import com.jxdinfo.hussar.eai.client.sdk.properties.EaiClientSdkProperties;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiClientAuthDto;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TokenCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenCommonService.class);
    private static final int TOKEN_EXPIRE_CODE = 4100;
    private static final int TOKEN_EXPIRE_MAX_RETRYCOUNT = 2;
    @Resource
    protected EaiClientSdkProperties eaiClientSdkProperties;
    @Resource
    private EaiClientTokenApiSdkService eaiClientTokenApiSdkService;

    protected <T extends EaiClientAuthDto, R> ApiResponse<R> getResponse(Function<T, ApiResponse<R>> function, T clientAuthDto, T dtoOriginal, String url) {
        EaiApiSdkInvokeParams eaiApiInvokeParams = this.getEaiApiSdkInvokeParams(url, clientAuthDto.getClientId(), clientAuthDto.getClientSecret());
        String clientToken = this.eaiClientTokenApiSdkService.getClientToken(eaiApiInvokeParams);
        clientAuthDto.setClientId(eaiApiInvokeParams.getClientId());
        clientAuthDto.setClientToken(clientToken);
        ApiResponse<R> response = function.apply(clientAuthDto);
        BeanUtil.copy(clientAuthDto, dtoOriginal);
        boolean isNewTokenFlag = false;
        if (4100 == response.getCode()) {
            for (int i = 0; i < 2; ++i) {
                if (!isNewTokenFlag) {
                    LOGGER.warn("token\u5df2\u7ecf\u5931\u6548\uff0c\u91cd\u65b0\u83b7\u53d6");
                    clientToken = this.eaiClientTokenApiSdkService.getClientTokenByApi(eaiApiInvokeParams);
                    isNewTokenFlag = true;
                }
                dtoOriginal.setClientToken(clientToken);
                response = function.apply(dtoOriginal);
                if (4100 != response.getCode()) break;
            }
        }
        return response;
    }

    private EaiApiSdkInvokeParams getEaiApiSdkInvokeParams(String url, String clientId, String clientSecret) {
        EaiApiSdkInvokeParams params = new EaiApiSdkInvokeParams();
        params.setServerUrl(url);
        params.setClientId(clientId);
        params.setClientSecret(clientSecret);
        return params;
    }
}

