/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.client.sdk.api.service.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkInvokeParams;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkRequestParams;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkTokenParams;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiClientAuthResponse;
import com.jxdinfo.hussar.eai.client.sdk.api.service.EaiApiSdkInvokService;
import com.jxdinfo.hussar.eai.client.sdk.properties.EaiClientSdkProperties;
import com.jxdinfo.hussar.eai.client.sdk.utils.EaiApiSdkUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.client.sdk.api.service.impl.EaiApiSdkInvokServiceImpl")
public class EaiApiSdkInvokServiceImpl
implements EaiApiSdkInvokService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiApiSdkInvokServiceImpl.class);
    private static final int TOKEN_EXPIRE_CODE = 4100;
    private static final int TOKEN_EXPIRE_MAX_RETRYCOUNT = 2;
    @Resource
    private EaiClientSdkProperties eaiClientSdkProperties;

    public ApiResponse getResponse(EaiApiSdkInvokeParams eaiApiInvokeParams) {
        String serverUrl = this.eaiClientSdkProperties.getEaiUrl();
        if (ToolUtil.isNotEmpty((Object)serverUrl) && ToolUtil.isEmpty((Object)eaiApiInvokeParams.getServerUrl())) {
            eaiApiInvokeParams.setServerUrl(serverUrl);
        }
        String clientToken = this.getClientToken(eaiApiInvokeParams);
        EaiApiSdkRequestParams requestParams = this.convertRequestParams(eaiApiInvokeParams);
        EaiApiSdkRequestParams requestParamsOriginal = new EaiApiSdkRequestParams();
        BeanUtil.copy((Object)requestParams, (Object)requestParamsOriginal);
        ApiResponse response = EaiApiSdkUtil.request((EaiApiSdkRequestParams)requestParams, (String)clientToken);
        boolean isNewTokenFlag = false;
        if (4100 == response.getCode()) {
            for (int i = 0; i < 2; ++i) {
                if (!isNewTokenFlag) {
                    LOGGER.warn("token\u5df2\u7ecf\u5931\u6548\uff0c\u91cd\u65b0\u83b7\u53d6");
                    clientToken = this.getClientTokenByApi(eaiApiInvokeParams);
                    isNewTokenFlag = true;
                }
                if (4100 != (response = EaiApiSdkUtil.request((EaiApiSdkRequestParams)requestParamsOriginal, (String)clientToken)).getCode()) break;
            }
        }
        return response;
    }

    @Override
    public <T> ApiResponse<T> getConvertResponse(EaiApiSdkInvokeParams eaiApiInvokeParams, Class responseClass) {
        String serverUrl = this.eaiClientSdkProperties.getEaiUrl();
        if (ToolUtil.isNotEmpty((Object)serverUrl) && ToolUtil.isEmpty((Object)eaiApiInvokeParams.getServerUrl())) {
            eaiApiInvokeParams.setServerUrl(serverUrl);
        }
        String clientToken = this.getClientToken(eaiApiInvokeParams);
        EaiApiSdkRequestParams requestParams = this.convertRequestParams(eaiApiInvokeParams);
        EaiApiSdkRequestParams requestParamsOriginal = new EaiApiSdkRequestParams();
        BeanUtil.copy((Object)requestParams, (Object)requestParamsOriginal);
        ApiResponse tApiResponse = EaiApiSdkUtil.requestObj((EaiApiSdkRequestParams)requestParams, (Class)responseClass, (String)clientToken);
        boolean isNewTokenFlag = false;
        if (4100 == tApiResponse.getCode()) {
            for (int i = 0; i < 2; ++i) {
                if (!isNewTokenFlag) {
                    LOGGER.warn("token\u5df2\u7ecf\u5931\u6548\uff0c\u91cd\u65b0\u83b7\u53d6");
                    clientToken = this.getClientTokenByApi(eaiApiInvokeParams);
                    isNewTokenFlag = true;
                }
                if (4100 != (tApiResponse = EaiApiSdkUtil.requestObj((EaiApiSdkRequestParams)requestParamsOriginal, (Class)responseClass, (String)clientToken)).getCode()) break;
            }
        }
        return tApiResponse;
    }

    private String getClientToken(EaiApiSdkInvokeParams eaiApiInvokeParams) {
        String clientToken = (String)HussarCacheUtil.get((String)"eai_client_token", (Object)eaiApiInvokeParams.getClientId());
        if (ToolUtil.isNotEmpty((Object)clientToken)) {
            return clientToken;
        }
        EaiClientAuthResponse authResponse = EaiApiSdkUtil.getClientToken((EaiApiSdkTokenParams)this.convertTokenParams(eaiApiInvokeParams));
        if (ToolUtil.isNotEmpty((Object)authResponse)) {
            HussarCacheUtil.put((String)"eai_client_token", (Object)authResponse.getClientId(), (Object)authResponse.getClientToken(), (long)authResponse.getExpiresIn());
            return authResponse.getClientToken();
        }
        return null;
    }

    private String getClientTokenByApi(EaiApiSdkInvokeParams eaiApiInvokeParams) {
        HussarCacheUtil.evict((String)"eai_client_token", (Object)eaiApiInvokeParams.getClientId());
        EaiClientAuthResponse authResponse = EaiApiSdkUtil.getClientToken((EaiApiSdkTokenParams)this.convertTokenParams(eaiApiInvokeParams));
        if (ToolUtil.isNotEmpty((Object)authResponse)) {
            HussarCacheUtil.put((String)"eai_client_token", (Object)authResponse.getClientId(), (Object)authResponse.getClientToken(), (long)authResponse.getExpiresIn());
            return authResponse.getClientToken();
        }
        return null;
    }

    private EaiApiSdkTokenParams convertTokenParams(EaiApiSdkInvokeParams eaiApiInvokeParams) {
        EaiApiSdkTokenParams tokenParams = new EaiApiSdkTokenParams();
        tokenParams.setServerUrl(eaiApiInvokeParams.getServerUrl());
        tokenParams.setClientId(eaiApiInvokeParams.getClientId());
        tokenParams.setClientSecret(eaiApiInvokeParams.getClientSecret());
        return tokenParams;
    }

    private EaiApiSdkRequestParams convertRequestParams(EaiApiSdkInvokeParams eaiApiInvokeParams) {
        EaiApiSdkRequestParams requestParams = new EaiApiSdkRequestParams();
        requestParams.setServerUrl(eaiApiInvokeParams.getServerUrl());
        requestParams.setUri(eaiApiInvokeParams.getUri());
        requestParams.setClientId(eaiApiInvokeParams.getClientId());
        requestParams.setBody(eaiApiInvokeParams.getBody());
        requestParams.setHeader(eaiApiInvokeParams.getHeader());
        requestParams.setQuery(eaiApiInvokeParams.getQuery());
        return requestParams;
    }
}

