/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.api.wrapper;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;

public class EaiQueryWrapper {
    private final List<LinkedHashMap<String, String>> andQuery = new ArrayList<LinkedHashMap<String, String>>();
    private final List<String> groupByFields = new ArrayList<String>();
    private final List<String> orderByFields = new ArrayList<String>();
    private String havingSql = null;
    private String lastSql = null;

    public EaiQueryWrapper eq(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" = ");
        this.appendValue(sb, value);
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper ne(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" != ");
        this.appendValue(sb, value);
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper gt(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" > ");
        this.appendValue(sb, value);
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper ge(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" >= ");
        this.appendValue(sb, value);
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper lt(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" < ");
        this.appendValue(sb, value);
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper le(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" <= ");
        this.appendValue(sb, value);
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper between(String field, Object value1, Object value2) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("BETWEEN").append(" ");
        this.appendValue(sb, value1);
        sb.append(" ").append("AND").append(" ");
        this.appendValue(sb, value2);
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper notBetween(String field, Object value1, Object value2) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("NOT BETWEEN").append(" ");
        this.appendValue(sb, value1);
        sb.append(" ").append("AND").append(" ");
        this.appendValue(sb, value2);
        return this.addAndQuery(sb);
    }

    private void appendValue(StringBuilder sb, Object value) {
        if (value instanceof String) {
            sb.append("'").append(value).append("'");
        } else {
            sb.append(value);
        }
    }

    public EaiQueryWrapper like(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("LIKE").append(" '%").append(value).append("%'");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper notLike(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("NOT LIKE").append(" '%").append(value).append("%'");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper likeLeft(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("LIKE").append(" '%").append(value).append("'");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper likeRight(String field, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("LIKE").append(" '").append(value).append("%'");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper isNull(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("IS NULL").append(" ");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper isNotNull(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("IS NOT NULL").append(" ");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper in(String field, Collection<?> coll) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("IN").append(" (");
        this.addItems(sb, coll, ",");
        sb.append(") ");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper notIn(String field, Collection<?> coll) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("NOT IN").append(" (");
        this.addItems(sb, coll, ",");
        sb.append(") ");
        return this.addAndQuery(sb);
    }

    private void addItems(StringBuilder sb, Collection<?> coll, String join) {
        if (HussarUtils.isNotEmpty(coll)) {
            coll.forEach(item -> sb.append(item).append(join));
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    public EaiQueryWrapper inSql(String field, String sql) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("IN").append(" (").append(sql).append(")");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper notInSql(String field, String sql) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(field).append(" ").append("NOT IN").append(" (").append(sql).append(")");
        return this.addAndQuery(sb);
    }

    public EaiQueryWrapper exists(String sql, Object ... values) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append("EXISTS").append(" (").append(sql).append(")");
        return this.setParamsToString(sb, values);
    }

    public EaiQueryWrapper notExists(String sql, Object ... values) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append("NOT EXISTS").append(" (").append(sql).append(")");
        return this.setParamsToString(sb, values);
    }

    public EaiQueryWrapper groupBy(List<String> fields) {
        if (HussarUtils.isNotEmpty(fields)) {
            this.groupByFields.addAll(fields);
        }
        return this;
    }

    public EaiQueryWrapper groupBy(String field) {
        if (HussarUtils.isNotEmpty((Object)field)) {
            this.groupByFields.add(field);
        }
        return this;
    }

    public EaiQueryWrapper orderByAsc(String field) {
        if (HussarUtils.isNotEmpty((Object)field)) {
            return this.orderByAsc(Collections.singletonList(field));
        }
        return this;
    }

    public EaiQueryWrapper orderByAsc(List<String> fields) {
        if (HussarUtils.isNotEmpty(fields)) {
            fields.forEach(f -> this.orderByFields.add(f + " " + "ASC"));
        }
        return this;
    }

    public EaiQueryWrapper orderByDesc(String field) {
        if (HussarUtils.isNotEmpty((Object)field)) {
            return this.orderByDesc(Collections.singletonList(field));
        }
        return this;
    }

    public EaiQueryWrapper orderByDesc(List<String> fields) {
        if (HussarUtils.isNotEmpty(fields)) {
            fields.forEach(f -> this.orderByFields.add(f + " " + "DESC"));
        }
        return this;
    }

    public EaiQueryWrapper orderBy(boolean isAsc, String field) {
        return isAsc ? this.orderByAsc(field) : this.orderByDesc(field);
    }

    public EaiQueryWrapper orderBy(boolean isAsc, List<String> fields) {
        return isAsc ? this.orderByAsc(fields) : this.orderByDesc(fields);
    }

    public EaiQueryWrapper having(String sql, Object ... params) {
        this.havingSql = String.format(sql, params);
        return this;
    }

    @Deprecated
    public EaiQueryWrapper apply(String sql, Object ... values) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(sql);
        return this.setParamsToString(sb, values);
    }

    @Deprecated
    public EaiQueryWrapper last(String sql) {
        this.lastSql = sql;
        return this;
    }

    public EaiQueryWrapper or() {
        return this.addOrQuery(new StringBuilder());
    }

    public EaiQueryWrapper or(Consumer<EaiQueryWrapper> consumer) {
        EaiQueryWrapper query = new EaiQueryWrapper();
        consumer.accept(query);
        StringBuilder sb = new StringBuilder();
        sb.append(" (").append(query.buildWhere()).append(") ");
        return this.addOrQuery(sb);
    }

    public EaiQueryWrapper and(Consumer<EaiQueryWrapper> consumer) {
        EaiQueryWrapper query = new EaiQueryWrapper();
        consumer.accept(query);
        StringBuilder sb = new StringBuilder();
        sb.append(" (").append(query.buildWhere()).append(") ");
        return this.addAndQuery(sb);
    }

    private EaiQueryWrapper addOrQuery(StringBuilder stringBuilder) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("OR", stringBuilder.toString());
        this.andQuery.add(map);
        return this;
    }

    private EaiQueryWrapper addAndQuery(StringBuilder stringBuilder) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("AND", stringBuilder.toString());
        this.andQuery.add(map);
        return this;
    }

    private EaiQueryWrapper setParamsToString(StringBuilder sb, Object ... params) {
        StringBuilder newSb = new StringBuilder(String.format(sb.toString(), params));
        return this.addAndQuery(newSb);
    }

    public String buildWhere() {
        if (this.andQuery.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean nextIsOr = false;
        for (int i = 0; i < this.andQuery.size(); ++i) {
            LinkedHashMap<String, String> map = this.andQuery.get(i);
            String key = map.keySet().iterator().next();
            String value = map.values().iterator().next();
            if (i != 0 && !nextIsOr) {
                sb.append(" ").append(key).append(" ");
            }
            if ("OR".equals(key) && HussarUtils.isEmpty((Object)value)) {
                nextIsOr = true;
                continue;
            }
            nextIsOr = false;
            sb.append(" ").append(value).append(" ");
        }
        return sb.toString();
    }

    public String buildGroupBy() {
        if (HussarUtils.isEmpty(this.groupByFields)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.addItems(sb, this.groupByFields, ",");
        return sb.toString();
    }

    public String buildSortColumn() {
        if (HussarUtils.isEmpty(this.orderByFields)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.addItems(sb, this.orderByFields, ",");
        return sb.toString();
    }

    public String buildHaving() {
        if (HussarUtils.isEmpty((Object)this.havingSql)) {
            return "";
        }
        return this.havingSql;
    }
}

