/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.businessenhancements.server.apiinfo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.ApiInfoEditVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasApiReleaseService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.service.EaiConvertService;
import com.jxdinfo.hussar.eai.common.util.EaiCanvasParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.businessenhancements.server.apiinfo.service.impl.EaiCanvasApiReleaseServiceImpl")
public class EaiCanvasApiReleaseServiceImpl
implements EaiCanvasApiReleaseService {
    @Resource
    IEaiApiInfoService apiInfoService;
    @Resource
    IEaiEditApiService iEaiEditApiService;
    @Resource
    IEaiCanvaParamsConvertService canvaParamsConvertService;
    @Resource
    ICanvasInfoService eaiCanvasInfoService;
    @Resource
    protected EaiApiProperties eaiApiProperties;
    @Resource
    IReleaseApiService releaseApiService;
    @Resource
    protected EaiConvertService eaiConvertService;

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean saveApiCanvasInfo(AddApiInfoDto addApiInfoDto) {
        AssertUtil.isNotNull((Object)addApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)addApiInfoDto.getId(), (String)"\u63a5\u53e3ID\u4e0d\u80fd\u4e3a\u7a7a");
        ApiInfo oldApiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)addApiInfoDto.getId()));
        if (HussarUtils.isEmpty((Object)oldApiInfo)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u6307\u5b9a\u63a5\u53e3");
        }
        addApiInfoDto.setApplicationCode(oldApiInfo.getApplicationCode());
        addApiInfoDto.setApiCode(oldApiInfo.getApiCode());
        ApiInfo apiInfo = new ApiInfo();
        EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)Long.valueOf(addApiInfoDto.getId())));
        apiInfo.setId(Long.valueOf(addApiInfoDto.getId()));
        apiInfo.setTestState(addApiInfoDto.getTestState());
        apiInfo.setRequestType(EaiRequestTypeEnum.POST.getRequestTypeStr());
        if (null != addApiInfoDto.getCanvasInParams() && CollectionUtil.isNotEmpty((Collection)addApiInfoDto.getCanvasInParams().getBody())) {
            String inParams = this.canvaParamsConvertService.convertInParamsStr(addApiInfoDto.getApplicationCode(), addApiInfoDto.getApiCode(), addApiInfoDto.getCanvasInParams().getBody());
            apiInfo.setInParams(inParams);
            editApi.setInParams(this.canvaParamsConvertService.convertEditOutBodyParamsStr(inParams));
        }
        if (null != addApiInfoDto.getOutParams()) {
            String outParams = this.canvaParamsConvertService.convertOutParams(addApiInfoDto.getOutParams());
            apiInfo.setOutParams(outParams);
            editApi.setOutParams(this.canvaParamsConvertService.convertEditOutBodyParamsStr(outParams));
        }
        editApi.setContentType(addApiInfoDto.getContentType());
        editApi.setHttpMethod(EaiRequestTypeEnum.POST.getRequestTypeStr());
        this.saveCanvas(editApi, addApiInfoDto);
        boolean info = this.apiInfoService.updateById((Object)apiInfo);
        if (!info) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        boolean edit = this.iEaiEditApiService.updateById((Object)editApi);
        if (!edit) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        return true;
    }

    private void saveCanvas(EditApi editApi, AddApiInfoDto addApiInfoDto) {
        if (0 == this.eaiApiProperties.getLogicType()) {
            return;
        }
        if (StringUtil.isNotEmpty((Object)editApi.getCanvasId())) {
            this.eaiCanvasInfoService.removeById((Serializable)editApi.getCanvasId());
        } else {
            editApi.setCanvasId(Long.valueOf(IdWorker.getId((Object)new CanvasInfo())));
        }
        CanvasInfo canvasInfo = new CanvasInfo();
        canvasInfo.setId(editApi.getCanvasId());
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getCanvasInfo())) {
            canvasInfo.setCanvasContent(addApiInfoDto.getCanvasInfo());
        }
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getApiEventrelates())) {
            canvasInfo.setApiCodes(EaiCanvasApiReleaseServiceImpl.toJSONString(addApiInfoDto.getApiEventrelates()));
        }
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getRelateFiles())) {
            canvasInfo.setCanvasResources(EaiCanvasApiReleaseServiceImpl.toJSONString(addApiInfoDto.getRelateFiles()));
        }
        this.eaiCanvasInfoService.save((Object)canvasInfo);
    }

    public ApiInfoEditVo getApiCanvasInfoById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfoEditVo apiInfoEditVo = this.releaseApiService.getById(id);
        if (StringUtil.isEmpty((Object)apiInfoEditVo.getClassificId())) {
            apiInfoEditVo.setClassificId(Long.valueOf(0L));
            apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
        } else if (0L == apiInfoEditVo.getClassificId()) {
            apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
        }
        if (StringUtil.isNotEmpty((Object)apiInfoEditVo.getInParamsStr())) {
            List inParams = this.eaiConvertService.toEaiParamsItems(apiInfoEditVo.getInParamsStr());
            inParams.forEach(itemsT -> this.fillEaiParamsItemsReMark((EaiParamsItems)itemsT));
            EaiCanvasParamsConvertDto convertDto = new EaiCanvasParamsConvertDto();
            convertDto.setBody(inParams);
            apiInfoEditVo.setCanvasInParams(convertDto);
        }
        if (StringUtil.isNotEmpty((Object)apiInfoEditVo.getOutParams())) {
            List outParams = this.eaiConvertService.toEaiParamsItems(apiInfoEditVo.getOutParamsStr());
            EaiParamsItems outParam = (EaiParamsItems)outParams.get(0);
            outParam.setRemark(outParam.getMark());
            if (CollectionUtil.isNotEmpty((Collection)outParam.getItems())) {
                outParam.getItems().forEach(itemsT -> this.fillEaiParamsItemsReMark((EaiParamsItems)itemsT));
            }
            EaiParamsConvertDto canvasOutParam = new EaiParamsConvertDto();
            canvasOutParam.setBody(outParam);
            apiInfoEditVo.setCanvasOutParams(canvasOutParam);
        }
        apiInfoEditVo.setName(apiInfoEditVo.getApiCode());
        apiInfoEditVo.setDesc(apiInfoEditVo.getApiName());
        CanvasInfo canvasInfo = (CanvasInfo)this.eaiCanvasInfoService.getById((Serializable)apiInfoEditVo.getCanvasId());
        if (null != canvasInfo) {
            apiInfoEditVo.setCanvasInfo(canvasInfo.getCanvasContent());
        }
        return apiInfoEditVo;
    }

    private static String toJSONString(Object t) {
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)t));
    }

    private void fillEaiParamsItemsReMark(EaiParamsItems items) {
        items.setRemark(items.getMark());
        if (CollectionUtil.isNotEmpty((Collection)items.getItems())) {
            items.getItems().forEach(itemsT -> this.fillEaiParamsItemsMark((EaiParamsItems)itemsT));
        }
    }

    public void fillEaiParamsItemsMark(EaiParamsItems items) {
        items.setMark(items.getRemark());
        if (CollectionUtil.isNotEmpty((Collection)items.getItems())) {
            items.getItems().forEach(itemsT -> this.fillEaiParamsItemsMark((EaiParamsItems)itemsT));
        }
    }
}

