/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.businessenhancements.server.apiinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EaiApiClassification;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiClassificationService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.ApiInfoVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConnectionVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConstantVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonLogicVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonStructureVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.EaiApiClassificationVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.EaiResourceVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasResourceService;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.businessenhancements.server.apiinfo.service.impl.EaiCanvasResourceServiceImpl")
public class EaiCanvasResourceServiceImpl
implements EaiCanvasResourceService {
    @Resource
    ICommonLogicService commonLogicService;
    @Resource
    ICommonConstantService commonConstantService;
    @Resource
    ICommonStructureService commonStructureService;
    @Resource
    ICommonConnectionService commonConnectionService;
    @Resource
    IEaiApiClassificationService classificationService;
    @Resource
    IReleaseApiService releaseApiService;

    public EaiResourceVo getEaiResource(String applicationCode) {
        List commonLogics;
        List commonConnections;
        List commonStructures;
        List commonConstants;
        EaiResourceVo eaiResourceVo = new EaiResourceVo();
        List apiInfoVos = this.releaseApiService.apiInfosByAppCode(applicationCode);
        if (CollectionUtil.isNotEmpty((Collection)apiInfoVos)) {
            apiInfoVos.forEach(returnApi -> {
                returnApi.setName(returnApi.getApiCode());
                returnApi.setDesc(returnApi.getApiName());
                if (StringUtil.isEmpty((Object)returnApi.getClassificId())) {
                    returnApi.setClassificId(Long.valueOf(0L));
                    returnApi.setParentId(Long.valueOf(0L));
                }
            });
            Map<Long, List<ApiInfoVo>> apiclassifyMap = apiInfoVos.stream().collect(Collectors.groupingBy(ApiInfoVo::getClassificId));
            ArrayList classificationVos = Lists.newArrayListWithCapacity((int)10);
            if (apiclassifyMap.keySet().contains(0L)) {
                EaiApiClassificationVo classificationVo = new EaiApiClassificationVo();
                classificationVo.setId(Long.valueOf(0L));
                classificationVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
                classificationVo.setName("\u9ed8\u8ba4\u7c7b\u578b");
                classificationVo.setDesc("\u9ed8\u8ba4\u7c7b\u578b");
                classificationVo.setRemark("\u9ed8\u8ba4\u7c7b\u578b");
                classificationVos.add(classificationVo);
            }
            Set<Long> classifyIds = apiclassifyMap.keySet();
            classifyIds.remove(0L);
            if (classifyIds.size() > 1) {
                List apiClassifications = this.classificationService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiClassification::getApplicationCode, (Object)applicationCode)).in(EaiApiClassification::getId, (Collection)classifyIds.stream().collect(Collectors.toList())));
                apiClassifications.forEach(apic -> {
                    EaiApiClassificationVo classificationVo = new EaiApiClassificationVo();
                    classificationVo.setId(apic.getId());
                    classificationVo.setName(apic.getClassificName());
                    classificationVo.setDesc(apic.getClassificName());
                    classificationVo.setRemark(apic.getRemark());
                    classificationVos.add(classificationVo);
                });
            }
            eaiResourceVo.setApis(apiInfoVos);
            eaiResourceVo.setApiClassifys((List)classificationVos);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonConstants = this.commonConstantService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)applicationCode))))) {
            ArrayList returnCommonConstants = Lists.newArrayListWithCapacity((int)10);
            commonConstants.forEach(c -> {
                CommonConstantVo constantVo = new CommonConstantVo();
                BeanUtil.copy((Object)c, (Object)constantVo);
                constantVo.setName(c.getConstantNameEn());
                constantVo.setDesc(c.getConstantName());
                returnCommonConstants.add(constantVo);
            });
            eaiResourceVo.setCommonConstants((List)returnCommonConstants);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonStructures = this.commonStructureService.list((Wrapper)new LambdaQueryWrapper().eq(CommonStructure::getApplicationCode, (Object)applicationCode))))) {
            ArrayList returnCommonStructureVos = Lists.newArrayListWithCapacity((int)10);
            commonStructures.forEach(c -> {
                CommonStructureVo structureVo = new CommonStructureVo();
                structureVo.setId(String.valueOf(c.getId()));
                structureVo.setName(c.getStructureCode());
                structureVo.setDesc(c.getStructureName());
                structureVo.setRemark(c.getRemark());
                returnCommonStructureVos.add(structureVo);
            });
            eaiResourceVo.setStructures((List)returnCommonStructureVos);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonConnections = this.commonConnectionService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)applicationCode))))) {
            ArrayList returncommonConnections = Lists.newArrayListWithCapacity((int)10);
            commonConnections.forEach(c -> {
                CommonConnectionVo connectionVo = new CommonConnectionVo();
                connectionVo.setId(c.getId());
                connectionVo.setName(c.getConnectionNameEn());
                connectionVo.setDesc(c.getConnectionName());
                connectionVo.setRemark(c.getRemark());
                returncommonConnections.add(connectionVo);
            });
            eaiResourceVo.setConnects((List)returncommonConnections);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonLogics = this.commonLogicService.list((Wrapper)new LambdaQueryWrapper().eq(CommonLogic::getApplicationCode, (Object)applicationCode))))) {
            ArrayList returncommonLogics = Lists.newArrayListWithCapacity((int)10);
            commonLogics.forEach(c -> {
                CommonLogicVo commonLogicVo = new CommonLogicVo();
                commonLogicVo.setId(c.getId());
                commonLogicVo.setName(c.getLogicCode());
                commonLogicVo.setDesc(c.getLogicName());
                commonLogicVo.setRemark(c.getRemark());
                returncommonLogics.add(commonLogicVo);
            });
            eaiResourceVo.setLogics((List)returncommonLogics);
        }
        return eaiResourceVo;
    }
}

