/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.businessenhancements.server.apiinfo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.ApiInfoEditVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.EaiCanvasService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasApiReleaseService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasInfoService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.service.EaiConvertService;
import com.jxdinfo.hussar.eai.common.util.EaiCanvasParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.businessenhancements.server.apiinfo.service.impl.EaiCanvasApiReleaseServiceImpl")
public class EaiCanvasApiReleaseServiceImpl
implements EaiCanvasApiReleaseService {
    @Resource
    IEaiApiInfoService apiInfoService;
    @Resource
    IEaiEditApiService iEaiEditApiService;
    @Resource
    IEaiCanvaParamsConvertService canvaParamsConvertService;
    @Resource
    ICanvasInfoService canvasInfoService;
    @Resource
    EaiCanvasInfoService eaiCanvasInfoService;
    @Resource
    protected EaiApiProperties eaiApiProperties;
    @Resource
    IReleaseApiService releaseApiService;
    @Resource
    protected EaiConvertService eaiConvertService;
    @Resource
    protected EaiCanvasService eaiCanvasService;
    @Resource
    EaiCanvasApiReleaseService eaiCanvasApiReleaseService;

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean saveApiCanvasInfo(AddApiInfoDto addApiInfoDto) {
        boolean info;
        AssertUtil.isNotNull((Object)addApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)addApiInfoDto.getId(), (String)"\u63a5\u53e3ID\u4e0d\u80fd\u4e3a\u7a7a");
        ApiInfo oldApiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)addApiInfoDto.getId()));
        if (HussarUtils.isEmpty((Object)oldApiInfo)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u6307\u5b9a\u63a5\u53e3");
        }
        addApiInfoDto.setApplicationCode(oldApiInfo.getApplicationCode());
        addApiInfoDto.setApiCode(oldApiInfo.getApiCode());
        ApiInfo apiInfo = new ApiInfo();
        EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)Long.valueOf(addApiInfoDto.getId())));
        apiInfo.setId(Long.valueOf(addApiInfoDto.getId()));
        apiInfo.setTestState(addApiInfoDto.getTestState());
        apiInfo.setDraftState("0");
        apiInfo.setRequestType(EaiRequestTypeEnum.POST.getRequestTypeStr());
        if (null != addApiInfoDto.getCanvasInParams() && CollectionUtil.isNotEmpty((Collection)addApiInfoDto.getCanvasInParams().getBody())) {
            addApiInfoDto.getCanvasInParams().getBody().forEach(items -> this.fillEaiParamsItemsMappingName((EaiParamsItems)items));
            String inParams = this.canvaParamsConvertService.convertInParamsStr(addApiInfoDto.getApplicationCode(), addApiInfoDto.getApiCode(), addApiInfoDto.getCanvasInParams().getBody());
            apiInfo.setInParams(inParams);
            editApi.setInParams(this.canvaParamsConvertService.convertEditOutBodyParamsStr(inParams));
        }
        if (null != addApiInfoDto.getOutParams()) {
            if (null != addApiInfoDto.getOutParams().getBody() && CollectionUtil.isNotEmpty((Collection)addApiInfoDto.getOutParams().getBody().getItems())) {
                addApiInfoDto.getOutParams().getBody().getItems().forEach(items -> this.fillEaiParamsItemsMappingName((EaiParamsItems)items));
            }
            String outParams = this.canvaParamsConvertService.convertOutParams(addApiInfoDto.getOutParams());
            apiInfo.setOutParams(outParams);
            editApi.setOutParams(this.canvaParamsConvertService.convertEditOutBodyParamsStr(outParams));
        }
        apiInfo.setContentType(HussarUtils.isEmpty((Object)addApiInfoDto.getContentType()) ? EaiContentType.APPLICATION_JSON.getTypeStr() : addApiInfoDto.getContentType());
        editApi.setContentType(addApiInfoDto.getContentType());
        editApi.setHttpMethod(EaiRequestTypeEnum.POST.getType());
        this.saveCanvas(editApi, addApiInfoDto);
        if (null == apiInfo.getInParams()) {
            apiInfo.setInParams("[]");
            editApi.setInParams(JSONObject.toJSONString((Object)ParamsConvertUtil.toEaiParamsConvertDto((String)"[]")));
        }
        if (null == apiInfo.getOutParams()) {
            apiInfo.setOutParams("[]");
            editApi.setOutParams(JSON.toJSONString((Object)ParamsConvertUtil.toEaiParamsConvertDto((String)"[]")));
        }
        if (!(info = this.apiInfoService.updateById((Object)apiInfo))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        boolean edit = this.iEaiEditApiService.updateById((Object)editApi);
        if (!edit) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        return true;
    }

    private void saveCanvas(EditApi editApi, AddApiInfoDto addApiInfoDto) {
        if (0 == this.eaiApiProperties.getLogicType()) {
            return;
        }
        if (StringUtil.isNotEmpty((Object)editApi.getCanvasId())) {
            this.eaiCanvasInfoService.deleteApiCanvasInfo(editApi);
        } else {
            editApi.setCanvasId(Long.valueOf(IdWorker.getId((Object)new CanvasInfo())));
        }
        CanvasInfo canvasInfo = new CanvasInfo();
        canvasInfo.setId(editApi.getCanvasId());
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getCanvasInfo())) {
            canvasInfo.setCanvasContent(addApiInfoDto.getCanvasInfo());
        }
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getApiEventrelates())) {
            canvasInfo.setApiCodes(EaiCanvasApiReleaseServiceImpl.toJSONString(addApiInfoDto.getApiEventrelates()));
        }
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getRelateFiles())) {
            canvasInfo.setCanvasResources(EaiCanvasApiReleaseServiceImpl.toJSONString(addApiInfoDto.getRelateFiles()));
        }
        this.canvasInfoService.save((Object)canvasInfo);
    }

    public ApiInfoEditVo getApiCanvasInfoById(String id) {
        List outParams;
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiResponse apiResponse = this.eaiCanvasService.automaticConvertCanvasCheck(Long.valueOf(id));
        if (!apiResponse.isSuccess()) {
            return null;
        }
        ApiInfoEditVo apiInfoEditVo = this.releaseApiService.getById(id);
        if (StringUtil.isEmpty((Object)apiInfoEditVo.getClassificId())) {
            apiInfoEditVo.setClassificId(Long.valueOf(0L));
            apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
        } else if (0L == apiInfoEditVo.getClassificId()) {
            apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
        }
        if (StringUtil.isNotEmpty((Object)apiInfoEditVo.getInParamsStr())) {
            List inParams = this.eaiConvertService.toEaiParamsItems(apiInfoEditVo.getInParamsStr());
            inParams.forEach(itemsT -> this.fillEaiParamsItemsReMark((EaiParamsItems)itemsT));
            EaiCanvasParamsConvertDto convertDto = new EaiCanvasParamsConvertDto();
            convertDto.setBody(inParams);
            apiInfoEditVo.setCanvasInParams(convertDto);
        }
        if (StringUtil.isNotEmpty((Object)apiInfoEditVo.getOutParams()) && CollectionUtil.isNotEmpty((Collection)(outParams = this.eaiConvertService.toEaiParamsItems(apiInfoEditVo.getOutParamsStr())))) {
            EaiParamsItems outParam = (EaiParamsItems)outParams.get(0);
            outParam.setRemark(outParam.getMark());
            if (CollectionUtil.isNotEmpty((Collection)outParam.getItems())) {
                outParam.getItems().forEach(itemsT -> this.fillEaiParamsItemsReMark((EaiParamsItems)itemsT));
            }
            EaiParamsConvertDto canvasOutParam = new EaiParamsConvertDto();
            canvasOutParam.setBody(outParam);
            apiInfoEditVo.setCanvasOutParams(canvasOutParam);
        }
        apiInfoEditVo.setName(apiInfoEditVo.getApiCode());
        apiInfoEditVo.setDesc(apiInfoEditVo.getApiName());
        CanvasInfo canvasInfo = (CanvasInfo)this.canvasInfoService.getById((Serializable)apiInfoEditVo.getCanvasId());
        if (null != canvasInfo) {
            apiInfoEditVo.setCanvasInfo(canvasInfo.getCanvasContent());
        }
        return apiInfoEditVo;
    }

    public CanvasInfo getCanvasInfoById(String id) {
        return (CanvasInfo)this.canvasInfoService.getById((Serializable)((Object)id));
    }

    public Long saveLogicApiBaseInfo(AddApiInfoDto addApiInfoDto) {
        Long apiId = this.releaseApiService.saveApiBaseInfo(addApiInfoDto);
        addApiInfoDto.setId(String.valueOf(apiId));
        addApiInfoDto.setHttpMethod(EaiRequestTypeEnum.POST.getType());
        addApiInfoDto.setContentType(EaiContentType.APPLICATION_JSON.getTypeStr());
        addApiInfoDto.setCanvasInfo("{\n  \"instanceKey\": \"hussar_0\",\n  \"instanceDecoration\": \"hussar_0\",\n  \"temporaryKey\": \"\",\n  \"parentInstanceKey\": \"\",\n  \"slotName\": \"default\",\n  \"name\": \"com.jxdinfo.logic.BackendRoot\",\n  \"label\": \"\",\n  \"alias\": \"\",\n  \"isContainer\": true,\n  \"hasError\": true,\n  \"instanceErrors\": {},\n  \"x\": 0,\n  \"y\": 0,\n  \"top\": 0,\n  \"left\": 0,\n  \"bottom\": \"auto\",\n  \"right\": \"auto\",\n  \"width\": 1146,\n  \"height\": 600,\n  \"_width\": null,\n  \"_height\": null,\n  \"scale\": 1,\n  \"props\": {},\n  \"propsErrors\": {},\n  \"t\": 0,\n  \"tb\": 300,\n  \"b\": 600,\n  \"l\": 0,\n  \"lr\": 573,\n  \"r\": 1146,\n  \"narrowDragInfo\": [{\n    \"slotName\": [\"default\"],\n    \"isFillFloatLeftAndRight\": true\n  }],\n  \"isNarrowContainer\": false,\n  \"offset\": [0, 0, 0, 0],\n  \"zIndex\": 100,\n  \"borderWidth\": [0, 0, 0, 0],\n  \"goInPathes\": [],\n  \"goOutPathes\": [],\n  \"innerStyles\": {},\n  \"layout\": \"relative\",\n  \"position\": \"relative\",\n  \"params\": [],\n  \"variables\": [],\n  \"result\": [],\n  \"referencesIndex\": {},\n  \"resReferencesIndex\": {},\n  \"maxInstanceCount\": 3,\n  \"relateFiles\": {},\n  \"variableSets\": {\n    \"variables\": [],\n    \"params\": [],\n    \"result\": [],\n    \"componentVariables\": []\n  },\n  \"slots\": {\n    \"default\": [{\n      \"instanceKey\": \"backendStart_1\",\n      \"instanceDecoration\": \"backendStart_1\",\n      \"temporaryKey\": \"\",\n      \"parentInstanceKey\": \"hussar_0\",\n      \"slotName\": \"default\",\n      \"name\": \"com.jxdinfo.logic.BackendStart\",\n      \"label\": \"\",\n      \"alias\": \"\",\n      \"isContainer\": false,\n      \"hasError\": false,\n      \"instanceErrors\": {},\n      \"x\": 532,\n      \"y\": 45,\n      \"top\": 45,\n      \"left\": 532,\n      \"bottom\": \"auto\",\n      \"right\": \"auto\",\n      \"width\": 82,\n      \"height\": 40,\n      \"_width\": null,\n      \"_height\": null,\n      \"scale\": 1,\n      \"props\": {\n        \"notAllowDelete\": true,\n        \"notAllowCopy\": true,\n        \"topLevel\": true\n      },\n      \"propsErrors\": {},\n      \"t\": 45,\n      \"tb\": 65,\n      \"b\": 85,\n      \"l\": 532,\n      \"lr\": 573,\n      \"r\": 614,\n      \"narrowDragInfo\": [{\n        \"slotName\": [\"default\"],\n        \"isFillFloatLeftAndRight\": true\n      }],\n      \"isNarrowContainer\": false,\n      \"offset\": [0, 0, 0, 0],\n      \"zIndex\": 101,\n      \"borderWidth\": [0, 0, 0, 0],\n      \"goInPathes\": [],\n      \"goOutPathes\": [\"hussar_path_3\"],\n      \"innerStyles\": {},\n      \"layout\": \"absolute\",\n      \"position\": \"absolute\",\n      \"isStart\": true\n    }, {\n      \"instanceKey\": \"backendEnd_2\",\n      \"instanceDecoration\": \"backendEnd_2\",\n      \"temporaryKey\": \"\",\n      \"parentInstanceKey\": \"hussar_0\",\n      \"slotName\": \"default\",\n      \"name\": \"com.jxdinfo.logic.BackendEnd\",\n      \"label\": \"\",\n      \"alias\": \"\",\n      \"isContainer\": false,\n      \"hasError\": false,\n      \"instanceErrors\": {},\n      \"x\": 532,\n      \"y\": 175,\n      \"top\": 175,\n      \"left\": 532,\n      \"bottom\": \"auto\",\n      \"right\": \"auto\",\n      \"width\": 82,\n      \"height\": 40,\n      \"_width\": null,\n      \"_height\": null,\n      \"scale\": 1,\n      \"props\": {\n        \"notAllowDelete\": true,\n        \"notAllowCopy\": true,\n        \"topLevel\": true\n      },\n      \"propsErrors\": {},\n      \"t\": 175,\n      \"tb\": 195,\n      \"b\": 215,\n      \"l\": 532,\n      \"lr\": 573,\n      \"r\": 614,\n      \"narrowDragInfo\": [{\n        \"slotName\": [\"default\"],\n        \"isFillFloatLeftAndRight\": true\n      }],\n      \"isNarrowContainer\": false,\n      \"offset\": [0, 0, 0, 0],\n      \"zIndex\": 102,\n      \"borderWidth\": [0, 0, 0, 0],\n      \"goInPathes\": [\"hussar_path_3\"],\n      \"goOutPathes\": [],\n      \"innerStyles\": {},\n      \"layout\": \"absolute\",\n      \"position\": \"absolute\",\n      \"isEnd\": true\n    }],\n    \"path\": [{\n      \"instanceKey\": \"hussar_path_3\",\n      \"instanceDecoration\": \"hussar_path_3\",\n      \"temporaryKey\": \"\",\n      \"parentInstanceKey\": \"hussar_0\",\n      \"slotName\": \"path\",\n      \"name\": \"com.jxdinfo.logic.JxdLogicPath\",\n      \"label\": \"\",\n      \"alias\": \"\",\n      \"isContainer\": false,\n      \"hasError\": false,\n      \"instanceErrors\": {},\n      \"x\": 0,\n      \"y\": 0,\n      \"top\": 0,\n      \"left\": 0,\n      \"bottom\": \"auto\",\n      \"right\": \"auto\",\n      \"width\": null,\n      \"height\": null,\n      \"_width\": null,\n      \"_height\": null,\n      \"scale\": 1,\n      \"props\": {},\n      \"propsErrors\": {},\n      \"t\": 0,\n      \"tb\": 0,\n      \"b\": 0,\n      \"l\": 0,\n      \"lr\": 0,\n      \"r\": 0,\n      \"narrowDragInfo\": [{\n        \"slotName\": [\"default\"],\n        \"isFillFloatLeftAndRight\": true\n      }],\n      \"isNarrowContainer\": false,\n      \"offset\": [0, 0, 0, 0],\n      \"zIndex\": 100,\n      \"borderWidth\": [0, 0, 0, 0],\n      \"goInPathes\": [],\n      \"goOutPathes\": [],\n      \"innerStyles\": {},\n      \"layout\": \"absolute\",\n      \"position\": \"absolute\",\n      \"start\": {\n        \"key\": \"backendStart_1\",\n        \"port\": \"B\"\n      },\n      \"end\": {\n        \"key\": \"backendEnd_2\",\n        \"port\": \"T\"\n      },\n      \"points\": [{\n        \"x\": 573,\n        \"y\": 85,\n        \"type\": \"start\"\n      }, {\n        \"x\": 573,\n        \"y\": 175,\n        \"type\": \"end\"\n      }],\n      \"d\": \"M573 85 L573 175 \",\n      \"pathSlotName\": \"default\",\n      \"transform\": \"\"\n    }]\n  }\n}");
        this.eaiCanvasApiReleaseService.saveApiCanvasInfo(addApiInfoDto);
        return apiId;
    }

    private static String toJSONString(Object t) {
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)t));
    }

    private void fillEaiParamsItemsReMark(EaiParamsItems items) {
        items.setRemark(items.getMark());
        if (CollectionUtil.isNotEmpty((Collection)items.getItems())) {
            items.getItems().forEach(itemsT -> this.fillEaiParamsItemsMark((EaiParamsItems)itemsT));
        }
    }

    public void fillEaiParamsItemsMark(EaiParamsItems items) {
        items.setMark(items.getRemark());
        if (CollectionUtil.isNotEmpty((Collection)items.getItems())) {
            items.getItems().forEach(itemsT -> this.fillEaiParamsItemsMark((EaiParamsItems)itemsT));
        }
    }

    public void fillEaiParamsItemsMappingName(EaiParamsItems items) {
        if (StringUtil.isEmpty((Object)items.getMappingName())) {
            items.setMappingName(items.getName());
        }
        if (CollectionUtil.isNotEmpty((Collection)items.getItems())) {
            items.getItems().forEach(itemsT -> this.fillEaiParamsItemsMappingName((EaiParamsItems)itemsT));
        }
    }
}

