/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlogic.dto.AddCommonLogicDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlogic.dto.EditCommonLogicDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlogic.dto.PageCommonLogicDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlogic.vo.CommonLogicInfoVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlogic.vo.PageCommonLogicVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCommonLogicService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.info.dao.EaiCommonLogicMapper;
import com.jxdinfo.hussar.eai.common.service.EaiConvertService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl")
public class EaiCommonLogicServiceImpl
implements EaiCommonLogicService {
    @Resource
    private ICommonLogicService commonLogicService;
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    IEaiCanvaParamsConvertService eaiCanvaParamsConvertService;
    @Resource
    EaiCommonLogicMapper eaiCommonLogicMapper;
    @Resource
    protected EaiConvertService eaiConvertService;

    public Long saveLogic(AddCommonLogicDto addCommonLogicDto) {
        CommonLogic commonLogic = this.addDtoToModel(addCommonLogicDto);
        this.checkCommonLogic(commonLogic);
        if (this.commonLogicService.save((Object)commonLogic)) {
            return commonLogic.getId();
        }
        throw new HussarException("\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    public CommonLogicInfoVo getLogicInfo(Long id) {
        CommonLogic commonLogic = (CommonLogic)this.commonLogicService.getById((Serializable)id);
        if (ToolUtil.isEmpty((Object)commonLogic)) {
            throw new HussarException("\u516c\u5171\u903b\u8f91\u83b7\u53d6\u5931\u8d25");
        }
        CanvasInfo canvasInfo = (CanvasInfo)this.canvasInfoService.getById((Serializable)Long.valueOf(commonLogic.getCanvasId()));
        return this.getLogicInfoVo(commonLogic, canvasInfo);
    }

    @HussarTransactional
    public Boolean editLogic(EditCommonLogicDto editCommonLogicDto) {
        CommonLogic commonLogic;
        if (ToolUtil.isNotEmpty((Object)editCommonLogicDto.getId())) {
            editCommonLogicDto.setLogicId(editCommonLogicDto.getId());
        }
        if (ToolUtil.isEmpty((Object)(commonLogic = (CommonLogic)this.commonLogicService.getById((Serializable)editCommonLogicDto.getLogicId())))) {
            throw new HussarException("\u516c\u5171\u903b\u8f91\u83b7\u53d6\u5931\u8d25");
        }
        this.editDtoToModel(editCommonLogicDto, commonLogic);
        this.checkCommonLogic(commonLogic);
        return this.commonLogicService.updateById((Object)commonLogic);
    }

    public Page<PageCommonLogicVo> listLogic(Page<PageCommonLogicVo> pageInfo, PageCommonLogicDto pageCommonLogicDto) {
        if (ToolUtil.isNotEmpty((Object)pageCommonLogicDto.getDesc())) {
            pageCommonLogicDto.setLogicName(pageCommonLogicDto.getDesc());
        }
        return this.eaiCommonLogicMapper.listLogic(pageInfo, pageCommonLogicDto);
    }

    private CommonLogic addDtoToModel(AddCommonLogicDto addCommonLogicDto) {
        CommonLogic commonLogic = new CommonLogic();
        if (ToolUtil.isNotEmpty((Object)addCommonLogicDto.getName())) {
            addCommonLogicDto.setLogicCode(addCommonLogicDto.getName());
        }
        if (ToolUtil.isNotEmpty((Object)addCommonLogicDto.getDesc())) {
            addCommonLogicDto.setLogicName(addCommonLogicDto.getDesc());
        }
        commonLogic.setId(addCommonLogicDto.getId());
        commonLogic.setLogicCode(addCommonLogicDto.getLogicCode());
        commonLogic.setLogicName(addCommonLogicDto.getLogicName());
        commonLogic.setApplicationCode(addCommonLogicDto.getApplicationCode());
        commonLogic.setLogicTest(ToolUtil.isNotEmpty((Object)addCommonLogicDto.getLogicTest()) ? addCommonLogicDto.getLogicTest() : "0");
        commonLogic.setRemark(addCommonLogicDto.getRemark());
        return commonLogic;
    }

    private void editDtoToModel(EditCommonLogicDto editCommonLogicDto, CommonLogic commonLogic) {
        if (ToolUtil.isNotEmpty((Object)editCommonLogicDto.getName())) {
            editCommonLogicDto.setLogicCode(editCommonLogicDto.getName());
        }
        if (ToolUtil.isNotEmpty((Object)editCommonLogicDto.getDesc())) {
            editCommonLogicDto.setLogicName(editCommonLogicDto.getDesc());
        }
        commonLogic.setId(editCommonLogicDto.getLogicId());
        commonLogic.setLogicCode(editCommonLogicDto.getLogicCode());
        commonLogic.setLogicName(editCommonLogicDto.getLogicName());
        commonLogic.setLogicTest(editCommonLogicDto.getLogicTest());
        commonLogic.setRemark(editCommonLogicDto.getRemark());
    }

    private CommonLogicInfoVo getLogicInfoVo(CommonLogic commonLogic, CanvasInfo canvasInfo) {
        CommonLogicInfoVo commonLogicInfoVo = new CommonLogicInfoVo();
        commonLogicInfoVo.setLogicId(commonLogic.getId());
        commonLogicInfoVo.setLogicCode(commonLogic.getLogicCode());
        commonLogicInfoVo.setLogicName(commonLogic.getLogicName());
        commonLogicInfoVo.setLogicTest(commonLogic.getLogicTest());
        commonLogicInfoVo.setCanvasId(commonLogic.getCanvasId());
        commonLogicInfoVo.setApplicationCode(commonLogic.getApplicationCode());
        commonLogicInfoVo.setInParams(this.eaiConvertService.toEaiParamsConvertDto(commonLogic.getInParams()));
        commonLogicInfoVo.setOutParams(this.eaiConvertService.toEaiParamsConvertDto(commonLogic.getOutParams()));
        commonLogicInfoVo.setRemark(commonLogic.getRemark());
        if (ToolUtil.isNotEmpty((Object)canvasInfo)) {
            commonLogicInfoVo.setCanvasInfo(canvasInfo.getCanvasContent());
        }
        return commonLogicInfoVo;
    }

    private void checkCommonLogic(CommonLogic commonLogic) {
        long count;
        String logicCode = commonLogic.getLogicCode();
        Long id = commonLogic.getId();
        String applicationCode = commonLogic.getApplicationCode();
        if (ToolUtil.isNotEmpty((Object)logicCode) && (count = this.commonLogicService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonLogic::getLogicCode, (Object)logicCode)).eq(CommonLogic::getApplicationCode, (Object)applicationCode)).ne(ToolUtil.isNotEmpty((Object)id), CommonLogic::getId, (Object)id))) > 0L) {
            throw new HussarException("\u903b\u8f91\u6807\u8bc6\u5df2\u5b58\u5728");
        }
    }
}

