/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.appinfo.api.service.IAppStateService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConnectionVo;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiAppStatusBaseService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.dto.CommonConnectionDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCommonConnectionService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.factory.EaiConnectionClassifyFactory;
import com.jxdinfo.hussar.eai.atomicenhancements.server.info.dao.EaiCommonConnectionMapper;
import com.jxdinfo.hussar.eai.common.enums.resources.EaiConnectionClassifyEnum;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl.EaiCommonConnectionServiceImpl")
public class EaiCommonConnectionServiceImpl
implements EaiCommonConnectionService {
    @Resource
    ICommonConnectionService commonConnectionService;
    @Resource
    private EaiAppStatusBaseService eaiAppStatusService;
    @Resource
    private IApplicationManagementService applicationManagementService;
    @Autowired
    EaiCommonConnectionMapper commonConnectionMapper;
    @Resource
    private IAppStateService appStateService;

    public Boolean addConnection(CommonConnectionDto commonConnectionDto) {
        AssertUtil.isNotNull((Object)commonConnectionDto, (String)"\u8fde\u63a5\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        AssertUtil.isNotNull((Object)commonConnectionDto.getName(), (String)"\u8fde\u63a5\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        this.checkUniqueConnectionNameEn(commonConnectionDto.getName(), null);
        commonConnectionDto.setCreateBy(BaseSecurityUtil.getUser().getUserName());
        CommonConnection commonConnection = this.getCommonConnection(commonConnectionDto);
        this.commonConnectionService.save((Object)commonConnection);
        return true;
    }

    public Boolean updateConnection(CommonConnectionDto commonConnectionDto) {
        AssertUtil.isNotNull((Object)commonConnectionDto, (String)"\u8fde\u63a5\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        AssertUtil.isNotNull((Object)commonConnectionDto.getId(), (String)"\u8fde\u63a5\u4fe1\u606fId\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        AssertUtil.isNotNull((Object)commonConnectionDto.getApplicationCode(), (String)"\u6240\u5c5e\u5e94\u7528\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        AssertUtil.isNotNull((Object)commonConnectionDto.getName(), (String)"\u8fde\u63a5\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        this.appStateService.checkAppStatus(commonConnectionDto.getApplicationCode(), "\u516c\u5171\u8fde\u63a5");
        this.checkUniqueConnectionNameEn(commonConnectionDto.getName(), commonConnectionDto.getId());
        commonConnectionDto.setEditBy(BaseSecurityUtil.getUser().getUserName());
        CommonConnection commonConnection = this.getCommonConnection(commonConnectionDto);
        this.commonConnectionService.updateById((Object)commonConnection);
        return true;
    }

    private CommonConnection getCommonConnection(CommonConnectionDto commonConnectionDto) {
        CommonConnection commonConnection = new CommonConnection();
        if (HussarUtils.isNotEmpty((Object)commonConnectionDto)) {
            BeanUtil.copy((Object)commonConnectionDto, (Object)commonConnection);
            if (HussarUtils.isNotEmpty((Object)commonConnectionDto.getConnectionConfigMap())) {
                commonConnection.setConnectionConfig(EaiCommonConnectionServiceImpl.toJSONString(commonConnectionDto.getConnectionConfigMap()));
            }
            commonConnection.setConnectionName(commonConnectionDto.getDesc());
            commonConnection.setConnectionNameEn(commonConnectionDto.getName());
        }
        return commonConnection;
    }

    public CommonConnectionVo getConnectionById(Long connectionId) {
        AssertUtil.isNotNull((Object)connectionId, (String)"\u8fde\u63a5\u4fe1\u606fId\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        CommonConnection commonConnection = (CommonConnection)this.commonConnectionService.getById((Serializable)connectionId);
        CommonConnectionVo connectionVo = this.getCommonConnectionVo(commonConnection);
        return connectionVo;
    }

    private CommonConnectionVo getCommonConnectionVo(CommonConnection commonConnection) {
        CommonConnectionVo connectionVo = new CommonConnectionVo();
        if (HussarUtils.isNotEmpty((Object)commonConnection)) {
            BeanUtil.copy((Object)commonConnection, (Object)connectionVo);
            if (HussarUtils.isNotEmpty((Object)commonConnection.getConnectionConfig())) {
                connectionVo.setConnectionConfigMap((Map)JSONObject.parseObject((String)commonConnection.getConnectionConfig(), Map.class));
            }
            connectionVo.setName(connectionVo.getConnectionNameEn());
            connectionVo.setDesc(connectionVo.getConnectionName());
        }
        return connectionVo;
    }

    public List<CommonConnectionVo> getConnectionsByAppCode(String appCode) {
        ArrayList commonConnectionVos = Lists.newArrayListWithCapacity((int)10);
        List commonConnections = this.commonConnectionService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)appCode));
        if (CollectionUtil.isNotEmpty((Collection)commonConnections)) {
            commonConnections.forEach(c -> {
                CommonConnectionVo vo = this.getCommonConnectionVo((CommonConnection)c);
                commonConnectionVos.add(vo);
            });
        }
        return commonConnectionVos;
    }

    private static String toJSONString(Object t) {
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)t));
    }

    public Page<CommonConnectionVo> connectionListPage(Page<CommonConnectionVo> pageInfo, CommonConnectionDto commonConnectionDto) {
        Page<CommonConnectionVo> pageConnetion = this.commonConnectionMapper.connectionListPage(pageInfo, commonConnectionDto);
        if (pageConnetion.getSize() > 0L) {
            List records = pageConnetion.getRecords();
            records.forEach(c -> {
                ApplicationManageVo byAppCode;
                c.setName(c.getConnectionNameEn());
                c.setDesc(c.getConnectionName());
                c.setConnectionConfigMap((Map)JSONObject.parseObject((String)c.getConnectionConfig(), Map.class));
                if (EaiConnectionClassifyEnum.CLASSIFY_APP.getClassifyCode().equals(c.getConnectionClassify()) && null != (byAppCode = this.applicationManagementService.getByAppCode(c.getClassifyChild()))) {
                    c.setAppName(byAppCode.getAppName());
                }
            });
        }
        return pageConnetion;
    }

    public Boolean connectionTest(CommonConnectionDto commonConnectionDto) {
        AssertUtil.isNotEmpty((String)commonConnectionDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((String)commonConnectionDto.getConnectionClassify(), (String)"\u8fde\u63a5\u5206\u7c7b\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((Map)commonConnectionDto.getConnectionConfigMap(), (String)"\u8fde\u63a5\u914d\u7f6e\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        return EaiConnectionClassifyFactory.getInvokeClassify(commonConnectionDto.getConnectionClassify()).connectionTest(commonConnectionDto);
    }

    public Boolean checkUniqueConnectionNameEn(String connectionNameEn, Long connectionId) {
        List commonConnections;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CommonConnection::getConnectionNameEn, (Object)connectionNameEn);
        if (HussarUtils.isNotEmpty((Object)connectionId)) {
            queryWrapper.ne(CommonConnection::getId, (Object)connectionId);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonConnections = this.commonConnectionService.list((Wrapper)queryWrapper)))) {
            throw new BaseException("\u8fde\u63a5\u6807\u8bc6\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
        }
        return true;
    }
}

