/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.CanvasInfoDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl.EaiCanvasInfoServiceImpl")
public class EaiCanvasInfoServiceImpl
implements EaiCanvasInfoService {
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private ICommonLogicService eaiCommonLogicService;
    @Resource
    IEaiCanvaParamsConvertService eaiCanvaParamsConvertService;

    @HussarTransactional
    public Boolean saveCanvasInfo(CanvasInfoDto canvasInfoDto) {
        CommonLogic commonLogic = (CommonLogic)this.eaiCommonLogicService.getById((Serializable)canvasInfoDto.getLogicId());
        if (ToolUtil.isEmpty((Object)commonLogic)) {
            throw new BaseException("\u516c\u5171\u903b\u8f91\u83b7\u53d6\u5931\u8d25");
        }
        CanvasInfo canvasInfo = this.dtoToModel(canvasInfoDto);
        long canvasId = commonLogic.getCanvasId();
        if (ToolUtil.isNotEmpty((Object)canvasId) && canvasId != 0L) {
            canvasInfo.setId(Long.valueOf(commonLogic.getCanvasId()));
        }
        if (this.canvasInfoService.saveOrUpdate((Object)canvasInfo)) {
            commonLogic.setCanvasId(canvasInfo.getId().longValue());
            commonLogic.setLogicTest(canvasInfoDto.getLogicTest());
            if (HussarUtils.isNotEmpty((Object)canvasInfoDto.getInParams()) && HussarUtils.isNotEmpty((Object)canvasInfoDto.getInParams().getBody())) {
                commonLogic.setInParams(this.eaiCanvaParamsConvertService.convertInParamsStr(commonLogic.getApplicationCode(), commonLogic.getLogicCode(), canvasInfoDto.getInParams().getBody().getItems()));
            } else {
                commonLogic.setInParams("[]");
            }
            commonLogic.setOutParams(this.eaiCanvaParamsConvertService.convertOutParams(canvasInfoDto.getOutParams()));
            return this.eaiCommonLogicService.updateById((Object)commonLogic);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    private CanvasInfo dtoToModel(CanvasInfoDto canvasInfoDto) {
        CanvasInfo canvasInfo = new CanvasInfo();
        canvasInfo.setCanvasContent(canvasInfoDto.getCanvasInfo());
        canvasInfo.setCanvasResources(JSONObject.toJSONString((Object)canvasInfoDto.getRelateFiles()));
        canvasInfo.setApiCodes(JSONObject.toJSONString((Object)canvasInfoDto.getApiEventrelates()));
        return canvasInfo;
    }
}

