/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpBodyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpBodyVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.dto.CommonConnectionDto;
import com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.factory.EaiConnectionClassifyFactory;
import com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.manager.ICommonConnectionManagerService;
import com.jxdinfo.hussar.eai.common.enums.resources.EaiConnectionClassifyEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.manager.impl.CommonConnectionManagerAppServiceImpl")
@Lazy(value=false)
public class CommonConnectionManagerAppServiceImpl
implements ICommonConnectionManagerService {
    private static final String APP_AUTH_CONFIG = "authParams";
    @Resource
    private IHttpAuthenticationService eaiHttpTemplateAuthService;
    @Resource
    private IEaiApplicationAuthService applicationAuthService;

    public void afterPropertiesSet() throws BaseException {
        EaiConnectionClassifyFactory.registerClassify(EaiConnectionClassifyEnum.CLASSIFY_APP.getClassifyCode(), this);
    }

    @Override
    public Boolean connectionTest(CommonConnectionDto commonConnectionDto) {
        AssertUtil.isNotNull(commonConnectionDto.getConnectionConfigMap().get(APP_AUTH_CONFIG), (String)"\u9274\u6743\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        ApiResponse eaiHttpTemplateVoApiResponse = this.eaiHttpTemplateAuthService.httpAuthVerfiyDetail(commonConnectionDto.getClassifyChild(), Boolean.valueOf(true));
        if (!eaiHttpTemplateVoApiResponse.isSuccess()) {
            throw new BaseException("\u67e5\u8be2\u9274\u6743\u9a8c\u8bc1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!");
        }
        if (null == eaiHttpTemplateVoApiResponse.getData()) {
            throw new BaseException("\u9274\u6743\u9a8c\u8bc1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a!");
        }
        List connectionAuthsMap = (List)commonConnectionDto.getConnectionConfigMap().get(APP_AUTH_CONFIG);
        List appAuth = this.applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)commonConnectionDto.getClassifyChild()));
        if (connectionAuthsMap.size() != appAuth.size()) {
            throw new BaseException("\u7f3a\u5c11\u9274\u6743\u53c2\u6570");
        }
        ArrayList connectionAuths = Lists.newArrayListWithCapacity((int)10);
        connectionAuthsMap.forEach(authMap -> {
            EaiHttpParamsDto paramsDto = new EaiHttpParamsDto();
            paramsDto.setParamsId(Long.valueOf((String)authMap.get("paramsId")));
            paramsDto.setParamsName((String)authMap.get("paramsName"));
            paramsDto.setParamsNameEn((String)authMap.get("paramsNameEn"));
            paramsDto.setParamsValue((String)authMap.get("paramsValue"));
            paramsDto.setParamsFrom("2");
            connectionAuths.add(paramsDto);
        });
        EaiHttpTemplateVo authConfigVo = (EaiHttpTemplateVo)eaiHttpTemplateVoApiResponse.getData();
        AssertUtil.isNotNull((Object)authConfigVo, (String)"\u9274\u6743\u9a8c\u8bc1\u914d\u7f6e\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        HttpAuthVerifyDto authVerifyDto = new HttpAuthVerifyDto();
        authVerifyDto.setAuthParams((List)connectionAuths);
        authVerifyDto.setHttpUrl(authConfigVo.getAuthVerify().getHttpUrl());
        authVerifyDto.setHttpMethod(authConfigVo.getAuthVerify().getHttpMethod());
        authVerifyDto.setApplicationCode(authConfigVo.getApplicationCode());
        if (null != authConfigVo.getEaiHttpParams()) {
            EaiHttpBodyVo httpBodyVo;
            List httpQueryParamVo;
            List httpHeaderVo = authConfigVo.getEaiHttpParams().getHttpHeader();
            if (CollectionUtil.isNotEmpty((Collection)httpHeaderVo)) {
                ArrayList httpHeaderDto = Lists.newArrayListWithCapacity((int)10);
                httpHeaderVo.forEach(hVo -> {
                    EaiHttpParamsDto hDto = new EaiHttpParamsDto();
                    BeanUtil.copy((Object)hVo, (Object)hDto);
                    httpHeaderDto.add(hDto);
                });
                authVerifyDto.setHttpHeader((List)httpHeaderDto);
            }
            if (CollectionUtil.isNotEmpty((Collection)(httpQueryParamVo = authConfigVo.getEaiHttpParams().getHttpQueryParam()))) {
                ArrayList httpQueryParamDto = Lists.newArrayListWithCapacity((int)10);
                httpQueryParamVo.forEach(qVo -> {
                    EaiHttpParamsDto queryDto = new EaiHttpParamsDto();
                    BeanUtil.copy((Object)qVo, (Object)queryDto);
                    httpQueryParamDto.add(queryDto);
                });
                authVerifyDto.setHttpQueryParam((List)httpQueryParamDto);
            }
            if (null != (httpBodyVo = authConfigVo.getEaiHttpParams().getHttpBody())) {
                EaiHttpBodyDto httpBodyDto = new EaiHttpBodyDto();
                httpBodyDto.setContentType(httpBodyVo.getContentType());
                if (CollectionUtil.isNotEmpty((Collection)httpBodyVo.getBodyParam())) {
                    ArrayList bodyDtos = Lists.newArrayListWithCapacity((int)10);
                    httpBodyVo.getBodyParam().forEach(bVo -> {
                        EaiHttpParamsDto bodyDto = new EaiHttpParamsDto();
                        BeanUtil.copy((Object)bVo, (Object)bodyDto);
                        bodyDtos.add(bodyDto);
                    });
                    httpBodyDto.setBodyParam((List)bodyDtos);
                }
                authVerifyDto.setHttpBody(httpBodyDto);
            }
        }
        authVerifyDto.setCallSpecificaList(authConfigVo.getCallSpecificaList());
        ApiResponse eaiApiResponseVoApiResponse = this.eaiHttpTemplateAuthService.httpAuthVerify(authVerifyDto);
        if (!eaiApiResponseVoApiResponse.isSuccess()) {
            return false;
        }
        if (null == eaiApiResponseVoApiResponse.getData()) {
            return false;
        }
        return true;
    }
}

