/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.api.canvas.runtime.dto.EaiHttpParams;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiHttpInvokeService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpBodyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.manager.EaiResponseServiceManager;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl.HttpInvokeServiceImpl")
public class HttpInvokeServiceImpl
extends EaiResponseServiceManager
implements EaiHttpInvokeService {
    private static final Logger log = LoggerFactory.getLogger(HttpInvokeServiceImpl.class);
    @Resource
    IHttpAuthenticationService httpAuthenticationService;
    @Resource
    private IEaiApplicationAuthService applicationAuthService;

    public ApiResponse<Object> getResponse(EaiHttpParams eaiHttpParams) throws Exception {
        AssertUtil.isNotNull((Object)eaiHttpParams, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3anull");
        HttpAuthVerifyDto authVerifyDto = this.formatParams(eaiHttpParams);
        ApiResponse authResponse = this.httpAuthenticationService.httpAuthVerify(authVerifyDto);
        return this.getResp((ApiResponse<EaiApiResponseVo>)authResponse);
    }

    private HttpAuthVerifyDto formatParams(EaiHttpParams eaiHttpParams) {
        HttpAuthVerifyDto authVerifyDto = new HttpAuthVerifyDto();
        authVerifyDto.setApplicationCode(eaiHttpParams.getApplicationCode());
        authVerifyDto.setHttpUrl(eaiHttpParams.getHttpUrl());
        authVerifyDto.setHttpMethod(eaiHttpParams.getHttpMethod());
        List<EaiHttpParamsDto> headers = this.toEaiHttpParamsDtos(eaiHttpParams.getHttpHeader());
        Map headerMaps = TempHttpCode.getAllParams();
        if (HussarUtils.isNotEmpty((Object)headerMaps)) {
            LambdaQueryWrapper authWrapper = new LambdaQueryWrapper();
            authWrapper.eq(EaiApplicationAuth::getApplicationCode, (Object)eaiHttpParams.getApplicationCode());
            List applicationAuths = this.applicationAuthService.list((Wrapper)authWrapper);
            authVerifyDto.setAuthParams(this.toEaiHttpParamsDtos(applicationAuths, headerMaps));
        }
        authVerifyDto.setHttpHeader(headers);
        List<EaiHttpParamsDto> query = this.toEaiHttpParamsDtos(eaiHttpParams.getHttpQueryParam());
        authVerifyDto.setHttpQueryParam(query);
        authVerifyDto.setHttpBody(this.toEaiHttpBodyDto(eaiHttpParams.getHttpBody(), eaiHttpParams.getContentType()));
        authVerifyDto.setHasCache(HussarUtils.isEmpty((Object)eaiHttpParams.getHasCache()) || eaiHttpParams.getHasCache() != false);
        return authVerifyDto;
    }

    private EaiHttpBodyDto toEaiHttpBodyDto(Object body, int contentType) {
        EaiHttpBodyDto dto = new EaiHttpBodyDto();
        dto.setContentType(String.valueOf(contentType));
        Map<Object, Object> data = new HashMap();
        try {
            data = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)body), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            dto.setBodyParam(this.toEaiHttpParamsDtos(data));
            return dto;
        }
        catch (Exception e) {
            log.error("json parse", (Throwable)e);
            if (EaiContentType.APPLICATION_JSON.getType() != contentType) {
                data.put(null, body);
                dto.setBodyParam(this.toEaiHttpParamsDtos(data));
                return dto;
            }
            throw new BaseException("\u65e0\u6cd5\u89e3\u6790body\u53c2\u6570");
        }
    }

    private List<EaiHttpParamsDto> toEaiHttpParamsDtos(List<EaiApplicationAuth> applicationAuths, Map<String, Object> headerMaps) {
        ArrayList<EaiHttpParamsDto> list = new ArrayList<EaiHttpParamsDto>();
        applicationAuths.forEach(eaiHttpParam -> {
            EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
            eaiHttpParamsDto.setParamsNameEn(eaiHttpParam.getParamsNameEn());
            eaiHttpParamsDto.setParamsId(eaiHttpParam.getParamsId());
            eaiHttpParamsDto.setParamsFrom("2");
            headerMaps.forEach((k, v) -> {
                if (k.equals(eaiHttpParam.getParamsNameEn())) {
                    eaiHttpParamsDto.setParamsValue(String.valueOf(v));
                }
            });
            list.add(eaiHttpParamsDto);
        });
        return list;
    }

    private List<EaiHttpParamsDto> toEaiHttpParamsDtos(Map data) {
        if (HussarUtils.isNotEmpty((Object)data)) {
            ArrayList<EaiHttpParamsDto> dtos = new ArrayList<EaiHttpParamsDto>(data.size());
            data.forEach((k, v) -> {
                EaiHttpParamsDto dto = new EaiHttpParamsDto();
                dto.setParamsNameEn(String.valueOf(k));
                dto.setKeyValue(v);
                dtos.add(dto);
            });
            return dtos;
        }
        return null;
    }
}

