/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.api.canvas.runtime.dto.EaiApiInvokeParams;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiApiInvokeService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.manager.EaiResponseServiceManager;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IConnectionVersionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl.EaiApiInvokeServiceImpl")
public class EaiApiInvokeServiceImpl
extends EaiResponseServiceManager
implements EaiApiInvokeService {
    @Resource
    IConnectionVersionService connectionVersionService;
    private static final String AUTH_PARAMS = "authParams";
    private static final String AUTH_PARAMS_K = "paramsNameEn";
    private static final String AUTH_PARAMS_V = "paramsValue";
    @Resource
    IHttpAuthenticationService authenticationService;

    public ApiResponse<Object> getResponse(EaiApiInvokeParams eaiApiInvokeParams) throws Exception {
        Long connId;
        AssertUtil.isNotNull((Object)eaiApiInvokeParams, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3anull");
        AssertUtil.isNotNull((Object)eaiApiInvokeParams.getApiId(), (String)"\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        HttpAuthVerifyDto authVerifyDto = this.eaiParamsChangeService.getApiTestDto(eaiApiInvokeParams.getHttpBody(), String.valueOf(eaiApiInvokeParams.getApiId()));
        if (HussarUtils.isEmpty((Object)authVerifyDto)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u63a5\u53e3\u4fe1\u606f");
        }
        ArrayList<EaiHttpParamsDto> authParams = new ArrayList<EaiHttpParamsDto>();
        if (HussarUtils.isNotEmpty((Object)eaiApiInvokeParams.getHttpHeader())) {
            authParams.addAll(this.toEaiHttpParamsDtos(eaiApiInvokeParams.getHttpHeader()));
        }
        if (HussarUtils.isNotEmpty((Object)(connId = eaiApiInvokeParams.getConnId()))) {
            ConnectionVersion connectionVersion = (ConnectionVersion)this.connectionVersionService.getById((Serializable)connId);
            if (HussarUtils.isEmpty((Object)connectionVersion)) {
                throw new BaseException("\u672a\u67e5\u8be2\u5230\u8fde\u63a5\u4fe1\u606f");
            }
            String config = connectionVersion.getConnectionConfig();
            Map map = (Map)JSON.parseObject((String)config, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            List key = (List)JSON.parseObject((String)JSON.toJSONString(map.get(AUTH_PARAMS)), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            HashMap<String, Object> authMap = new HashMap<String, Object>(key.size());
            key.forEach(chlid -> authMap.put(String.valueOf(chlid.get(AUTH_PARAMS_K)), chlid.get(AUTH_PARAMS_V)));
            authParams.addAll(this.toEaiHttpParamsDtos(authMap));
            authVerifyDto.setAuthParams(authParams);
        }
        authVerifyDto.setHasCache(HussarUtils.isEmpty((Object)eaiApiInvokeParams.getHasCache()) || eaiApiInvokeParams.getHasCache() != false);
        ApiResponse response = this.authenticationService.apiInvoke(authVerifyDto);
        return this.getResp((ApiResponse<EaiApiResponseVo>)response, eaiApiInvokeParams.getApiId());
    }

    private List<EaiHttpParamsDto> toEaiHttpParamsDtos(Map<String, Object> map) {
        ArrayList<EaiHttpParamsDto> list = new ArrayList<EaiHttpParamsDto>(map.size());
        map.forEach((k, v) -> {
            EaiHttpParamsDto dto = new EaiHttpParamsDto();
            dto.setParamsNameEn(k);
            dto.setKeyValue(v);
            list.add(dto);
        });
        return list;
    }
}

