/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiParamItem;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiTestDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.logicresource.dto.CanvasDebugDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.EaiApiCanvasConvertService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiApiParamMappingEnum;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.common.util.WebSocketUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl.EaiApiCanvasConvertServiceImpl")
public class EaiApiCanvasConvertServiceImpl
implements EaiApiCanvasConvertService {
    private static final String RESULT_STR = "result";
    private static final String LEVEL_STR = "level";
    private static final String ERROR_STR = "error";
    private static final String LOGS_STR = "logs";
    private static final String MESSAGE_STR = "message";
    private static final String BODY_STR = "body";
    private static final String OBJECT_STR = "Object";
    private static final String EXCEPTION_MESSAGE_STR = "exceptionMessage";
    @Resource
    private ICanvasInfoService eaiCanvasInfoService;
    @Resource
    IEaiApiInfoService eaiApiInfoService;
    @Resource
    EaiCanvasRuntimeService canvasRuntimeService;
    @Resource
    protected IHttpAuthenticationService eaiHttpTemplateAuthService;
    @Resource
    private IEaiEditApiService iEaiEditApiService;
    private final ExecutorService threadPoolExecutor = Executors.newSingleThreadExecutor();

    private CanvasDebugDto convetTestParams(ApiTestDto apiTestDto, ApiInfo apiInfo, EditApi editApi) {
        CanvasInfo canvasInfo = (CanvasInfo)this.eaiCanvasInfoService.getById((Serializable)editApi.getCanvasId());
        CanvasDebugDto canvasDebugDto = new CanvasDebugDto();
        canvasDebugDto.setCode(apiInfo.getApiCode());
        canvasDebugDto.setCanvas(canvasInfo.getCanvasContent());
        canvasDebugDto.setResourceEnum(EaiResourcesEnum.API);
        canvasDebugDto.setName(apiInfo.getApiName());
        canvasDebugDto.setApplicationCode(apiInfo.getApplicationCode());
        Map<String, Object> map = this.headerToMap(apiTestDto.getHeader());
        canvasDebugDto.setHttpHeader(map);
        EaiParamsConvertDto dto = ParamsConvertUtil.toEaiParamsConvertDto((String)editApi.getInParams());
        if (HussarUtils.isNotEmpty((Object)dto.getBody()) && HussarUtils.isNotEmpty((Object)dto.getBody().getItems())) {
            EaiParamsItems body = dto.getBody();
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == body.getType().intValue() && OBJECT_STR.equals(body.getValue())) {
                canvasDebugDto.setHttpBody(JSONObject.parseObject((String)JSON.toJSONString((Object)apiTestDto.getBody())).get((Object)BODY_STR));
            }
        } else {
            canvasDebugDto.setHttpBody(apiTestDto.getBody());
        }
        canvasDebugDto.setId(apiInfo.getId());
        return canvasDebugDto;
    }

    public ApiResponse<EaiApiResponseVo> convetTest(ApiTestDto apiTestDto, HttpAuthVerifyDto authVerifyDto) {
        ApiInfo apiInfo = (ApiInfo)this.eaiApiInfoService.getById((Serializable)apiTestDto.getApiId());
        if (HussarUtils.isNotEmpty((Object)apiInfo)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(EditApi::getApiId, (Object)apiTestDto.getApiId());
            EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)editApi.getCanvasId())) {
                AssertUtil.isNotEmpty((String)apiTestDto.getContentType(), (String)"\u5185\u5bb9\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isNotEmpty((String)apiTestDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isNotEmpty((String)apiTestDto.getHttpUrl(), (String)"\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isNotEmpty((String)apiTestDto.getHttpMethod(), (String)"\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                TempHttpCode.removeAll();
                return this.eaiHttpTemplateAuthService.httpAuthVerify(authVerifyDto);
            }
            CanvasDebugDto canvasDebugDto = this.convetTestParams(apiTestDto, apiInfo, editApi);
            ApiResponse apiResponse = null;
            try {
                apiResponse = this.canvasRuntimeService.runWithDebug(canvasDebugDto);
            }
            catch (BaseException e) {
                throw new BaseException(e.getMessage());
            }
            catch (Exception ex) {
                throw new BaseException("");
            }
            finally {
                TempHttpCode.removeAll();
            }
            if (apiResponse.isSuccess()) {
                if (HussarUtils.isNotEmpty((Object)apiResponse.getData())) {
                    JSONObject debugResult = JSON.parseObject((String)JSON.toJSONString((Object)apiResponse.getData()));
                    EaiApiResponseVo apiResponseVo = new EaiApiResponseVo();
                    EaiApiResponse apiResponse1 = new EaiApiResponse();
                    Object obj = debugResult.get((Object)RESULT_STR);
                    apiResponse1.setBody(obj);
                    if (HussarUtils.isNotEmpty((Object)apiTestDto.getServiceId()) && HussarUtils.isNotEmpty((Object)debugResult.get((Object)LOGS_STR))) {
                        JSONArray logs = debugResult.getJSONArray(LOGS_STR);
                        this.threadPoolExecutor.execute(() -> logs.forEach(log -> {
                            JSONObject l = JSON.parseObject((String)JSON.toJSONString((Object)log));
                            String level = l.getString(LEVEL_STR);
                            WebSocketUtil.senMsg((String)apiTestDto.getServiceId(), (String)l.getString(MESSAGE_STR), (String)level, null);
                        }));
                    }
                    if (HussarUtils.isNotEmpty((Object)debugResult.getJSONObject(ERROR_STR))) {
                        apiResponse1.setException(new Throwable(debugResult.getJSONObject(ERROR_STR).getString(EXCEPTION_MESSAGE_STR)));
                        apiResponseVo.setOuturlResponse(apiResponse1);
                        apiResponseVo.setOuturlRequestParams(this.requestParamsPackage(authVerifyDto));
                        return ApiResponse.success((Object)apiResponseVo, (String)"\u9a8c\u8bc1\u5931\u8d25");
                    }
                    apiResponseVo.setOuturlResponse(apiResponse1);
                    apiResponseVo.setOuturlRequestParams(this.requestParamsPackage(authVerifyDto));
                    apiResponseVo.setEscapeResponse((Object)ApiResponse.success((Object)obj));
                    return ApiResponse.success((Object)apiResponseVo);
                }
                return ApiResponse.success((Object)new EaiApiResponseVo());
            }
            throw new BaseException(apiResponse.getMsg());
        }
        throw new BaseException("\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38,\u672a\u77e5\u53c2\u6570\u5f02\u5e38");
    }

    private Map<String, Object> headerToMap(List<ApiParamItem> apiParamItems) {
        if (HussarUtils.isEmpty(apiParamItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(apiParamItems.size());
        apiParamItems.forEach(apiParamItem -> map.put(apiParamItem.getName(), apiParamItem.getValue()));
        return map;
    }

    private Map<String, Object> dtoHeaderToMap(List<EaiHttpParamsDto> apiParamItems) {
        if (HussarUtils.isEmpty(apiParamItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(apiParamItems.size());
        apiParamItems.forEach(apiParamItem -> map.put(apiParamItem.getParamsNameEn(), apiParamItem.getKeyValue()));
        return map;
    }

    public Map<String, Object> requestParamsPackage(HttpAuthVerifyDto authVerifyDto) {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("contentType", authVerifyDto.getHttpBody().getContentType());
        requestMap.put(EaiApiParamMappingEnum.HEADER.getKey(), this.dtoHeaderToMap(authVerifyDto.getHttpHeader()));
        requestMap.put(EaiApiParamMappingEnum.QUERY.getKey(), this.dtoHeaderToMap(authVerifyDto.getHttpQueryParam()));
        List list = authVerifyDto.getHttpBody().getBodyParam();
        if (HussarUtils.isNotEmpty((Object)list) && HussarUtils.isEmpty((Object)((EaiHttpParamsDto)list.get(0)).getParamsNameEn())) {
            List str = list.stream().map(EaiHttpParamsDto::getKeyValue).collect(Collectors.toList());
            requestMap.put(EaiApiParamMappingEnum.BODY.getKey(), str);
        } else {
            requestMap.put(EaiApiParamMappingEnum.BODY.getKey(), this.dtoHeaderToMap(list));
        }
        return requestMap;
    }
}

