/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiLogicRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl.DebugResourceLoader;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.EaiLogicSource;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ILogicSourceService;
import com.jxdinfo.hussar.logic.engine.api.DebugRuntimePool;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.bean.DebugResult;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl.EaiLogicRuntimeServiceImpl")
public class EaiLogicRuntimeServiceImpl
implements EaiLogicRuntimeService {
    @Autowired
    LogicRuntime logicRuntime;
    @Autowired
    DebugRuntimePool debugRuntimePool;
    @Autowired
    private ILogicSourceService eaiLogicSourceService;
    @Autowired
    DebugResourceLoader debugResourceLoader;

    public ApiResponse<Object> run(String className, Object ... args) {
        AssertUtil.isNotEmpty((String)className, (String)"\u672a\u67e5\u8be2\u5230\u6307\u5b9a\u7c7b\u540d");
        ApiResponse response = ApiResponse.success();
        response.setData(this.logicRuntime.runWithConvert(className, args));
        return response;
    }

    public ApiResponse<Object> debug(String className, Object ... args) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiLogicSource::getSourceCode, (Object)className);
        EaiLogicSource source = (EaiLogicSource)this.eaiLogicSourceService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)source)) {
            throw new BaseException("\u672a\u751f\u6210\u4ee3\u7801");
        }
        DebugResult debugResult = this.debugRuntimePool.compileAndDebugWithConvert(source.getSourceContent(), className, Level.TRACE, (ResourceLoader)this.debugResourceLoader, args);
        if (HussarUtils.isNotEmpty((Object)debugResult)) {
            return ApiResponse.success((Object)debugResult);
        }
        return ApiResponse.fail((String)"\u672a\u83b7\u53d6\u8c03\u8bd5\u4fe1\u606f");
    }
}

