/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiCanvasResourceService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiGenerateService;
import com.jxdinfo.hussar.eai.common.constant.logic.EaiLogicConstant;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.canvas.runtime.service.impl.EaiGenerateServiceImpl")
public class EaiGenerateServiceImpl
implements EaiGenerateService {
    @Resource
    private EaiCanvasResourceService resourceService;
    private static final String APP_CODE = "applicationCode";

    public String generatedClassName(String category, String type, Long id, String version, Boolean isPublished) {
        ApiResponse obj = null;
        boolean env = isPublished;
        if (isPublished.booleanValue()) {
            obj = this.resourceService.getById(category, type, isPublished, id);
        } else {
            try {
                obj = this.resourceService.getById(category, type, isPublished, id);
            }
            catch (Exception e) {
                obj = this.resourceService.getById(category, type, isPublished, id);
                env = true;
            }
        }
        if (obj.isSuccess()) {
            JSONObject object = JSONObject.parseObject((String)JSON.toJSONString((Object)obj.getData()));
            if ("open".equals(category)) {
                if (env) {
                    version = object.getString(this.getVersion(type));
                }
                return EaiLogicConstant.getOpenPackageName((String)object.getString(APP_CODE), (EaiResourcesEnum)EaiResourcesEnum.getByType((String)type), (String)object.getString(this.getCodeName(type)), (String)version);
            }
            if ("integration".equals(category)) {
                return EaiLogicConstant.getIntegrationPackageName((String)object.getString(APP_CODE), (EaiResourcesEnum)EaiResourcesEnum.getByType((String)type), (String)object.getString(this.getCodeName(type)));
            }
        }
        throw new BaseException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
    }

    private String getVersion(String type) {
        if (EaiResourcesEnum.STRUCTURE.getType().equals(type)) {
            return "structureVersion";
        }
        if (EaiResourcesEnum.CONSTANT.getType().equals(type)) {
            return "constantVersion";
        }
        if (EaiResourcesEnum.LINK.getType().equals(type)) {
            return "connVersion";
        }
        if (EaiResourcesEnum.API.getType().equals(type)) {
            return "apiVersion";
        }
        if (EaiResourcesEnum.LOGIC.getType().equals(type)) {
            return "logicVersion";
        }
        if (EaiResourcesEnum.AUTH.getType().equals(type)) {
            return "";
        }
        if (EaiResourcesEnum.EVENTS.getType().equals(type)) {
            return "eventVersion";
        }
        throw new BaseException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
    }

    private String getCodeName(String type) {
        if (EaiResourcesEnum.STRUCTURE.getType().equals(type)) {
            return "structureCode";
        }
        if (EaiResourcesEnum.CONSTANT.getType().equals(type)) {
            return "constantNameEn";
        }
        if (EaiResourcesEnum.LINK.getType().equals(type)) {
            return "connectionNameEn";
        }
        if (EaiResourcesEnum.API.getType().equals(type)) {
            return "apiCode";
        }
        if (EaiResourcesEnum.LOGIC.getType().equals(type)) {
            return "logicCode";
        }
        if (EaiResourcesEnum.AUTH.getType().equals(type)) {
            return "paramsNameEn";
        }
        if (EaiResourcesEnum.EVENTS.getType().equals(type)) {
            return "eventCode";
        }
        throw new BaseException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
    }
}

