/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.logicresource.dto.CanvasDebugDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiLogicRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl.EaiLogicConfig;
import com.jxdinfo.hussar.eai.common.constant.logic.EaiLogicConstant;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.EaiCanvasUtil;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.logic.generator.service.LogicGenerateService;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasMetadata;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl.EaiCanvasRuntimeServiceImpl")
public class EaiCanvasRuntimeServiceImpl
implements EaiCanvasRuntimeService {
    @Resource
    private LogicGenerateService logicGenerateService;
    @Resource
    private EaiLogicConfig eaiLogicConfig;
    @Resource
    private EaiLogicRuntimeService eaiLogicRuntimeService;
    @Autowired
    SourceService sourceService;
    private static final Integer RANDOM_BOND = 999;
    private static final String PARAMS = "params";
    private static final String FILES = "files";
    private static final String DEBUG_CLASS_NAME = "className";

    public ApiResponse<Object> runWithDebug(CanvasDebugDto canvasDebugDto) {
        String resourceEn = canvasDebugDto.getResourcesEnum();
        if (HussarUtils.isNotEmpty((Object)resourceEn)) {
            canvasDebugDto.setResourceEnum(EaiResourcesEnum.getByType((String)resourceEn.toLowerCase()));
        }
        String canvas = canvasDebugDto.getCanvas();
        canvasDebugDto.setCanvas(canvas);
        Map<String, Object> map = this.generateCanvas(canvasDebugDto);
        if (HussarUtils.isEmpty(map)) {
            throw new BaseException("\u751f\u6210\u4ee3\u7801\u5f02\u5e38");
        }
        Object obj = map.get(FILES);
        if (HussarUtils.isEmpty((Object)obj)) {
            throw new BaseException("\u4ee3\u7801\u751f\u6210\u5f02\u5e38");
        }
        List list = (List)JSON.parseObject((String)JSON.toJSONString((Object)obj), (TypeReference)new TypeReference<List<LogicGenerateFile>>(){}, (Feature[])new Feature[0]);
        String debugClass = String.valueOf(map.get(DEBUG_CLASS_NAME));
        this.sourceService.saveOrUpdateDev(debugClass, ((LogicGenerateFile)list.get(0)).getContent());
        Object body = canvasDebugDto.getHttpBody();
        if (HussarUtils.isNotEmpty((Object)body)) {
            Map bodyMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)body), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            List params = map.get(PARAMS) == null ? null : (List)map.get(PARAMS);
            ArrayList b = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)params)) {
                params.forEach(param -> {
                    if (bodyMap.containsKey(param)) {
                        b.add(bodyMap.get(param));
                    }
                });
            }
            return this.eaiLogicRuntimeService.debug(debugClass, b.toArray());
        }
        return this.eaiLogicRuntimeService.debug(debugClass, null);
    }

    private Map<String, Object> generateCanvas(CanvasDebugDto canvasDebugDto) {
        LogicCanvasComponent canvasComponent = (LogicCanvasComponent)JSONObject.parseObject((String)canvasDebugDto.getCanvas(), LogicCanvasComponent.class);
        LogicGenerateSource generateSource = new LogicGenerateSource();
        generateSource.setRoot(canvasComponent);
        Random rand = new Random();
        Integer randNum = rand.nextInt(RANDOM_BOND);
        String v = String.format("debug_%s_%s", canvasDebugDto.getCode(), randNum);
        List list = EaiCanvasUtil.setOpenModules((String)canvasDebugDto.getApplicationCode(), (String)canvasDebugDto.getResourceEnum().getType(), (String)v);
        generateSource.setModules(list);
        LogicCanvasMetadata canvasMetadata = new LogicCanvasMetadata();
        canvasMetadata.setId(String.valueOf(canvasDebugDto.getId()));
        canvasMetadata.setName(canvasDebugDto.getCode());
        canvasMetadata.setDesc(canvasDebugDto.getName());
        canvasMetadata.setVersion(v);
        generateSource.setMeta(canvasMetadata);
        LogicGenerateResult logicGenerateResult = this.logicGenerateService.generate(generateSource, this.eaiLogicConfig.initConfigure(true, canvasDebugDto.getApplicationCode(), v));
        if (HussarUtils.isNotEmpty((Object)logicGenerateResult)) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            List params = logicGenerateResult.getParameterNames();
            List files = logicGenerateResult.getFiles();
            map.put(PARAMS, params);
            map.put(FILES, files);
            String debugClass = EaiLogicConstant.getOpenPackageName((String)canvasDebugDto.getApplicationCode(), (EaiResourcesEnum)canvasDebugDto.getResourceEnum(), (String)canvasDebugDto.getCode(), (String)v);
            map.put(DEBUG_CLASS_NAME, debugClass);
            return map;
        }
        return null;
    }
}

