/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.dto.EaiPublishCommonResources;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.logicresource.service.EaiLogicSourceService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasConvertService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.dto.EaiCanvasConvertDto;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.dto.GenerateDto;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.manager.EaiCanvasCodeGenerateManager;
import com.jxdinfo.hussar.eai.common.constant.logic.EaiLogicConstant;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.StructureQuoteIdPattern;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl.EaiCanvasConvertServiceImpl")
public class EaiCanvasConvertServiceImpl
extends EaiCanvasCodeGenerateManager
implements EaiCanvasConvertService {
    @Resource
    private ICommonStructureService structureService;
    @Resource
    private ICommonConnectionService commonConnectionService;
    @Resource
    private ICommonLogicService commonLogicService;
    @Resource
    private ICommonConstantService commonConstantService;
    @Resource
    private EaiLogicSourceService eaiLogicSourceService;
    @Resource
    ICanvasInfoService canvasInfoService;

    public Map<Long, String> generatedCode(List<CanvasInfo> canvasInfos, Map<Long, EaiApiVersion> editApis, String applicationCode, String version) {
        if (HussarUtils.isEmpty(canvasInfos)) {
            return null;
        }
        HashMap<Long, String> result = new HashMap<Long, String>(canvasInfos.size());
        canvasInfos.forEach(canvasInfo -> {
            EaiApiVersion apiVersion = (EaiApiVersion)editApis.get(canvasInfo.getId());
            if (HussarUtils.isNotEmpty((Object)apiVersion)) {
                String name = this.generateCanvas(canvasInfo.getCanvasContent(), apiVersion, applicationCode, version);
                result.put(apiVersion.getApiVersionId(), name);
            }
        });
        return result;
    }

    private String generateCanvas(String canvas, EaiApiVersion apiVersion, String appCode, String version) {
        GenerateDto dto = new GenerateDto();
        dto.setAppCode(appCode);
        dto.setCanvas(canvas);
        dto.setDesc(apiVersion.getApiName());
        dto.setId(String.valueOf(apiVersion.getApiVersionId()));
        dto.setName(apiVersion.getApiCode());
        dto.setType(EaiResourcesEnum.API);
        dto.setVersion(version);
        LogicGenerateResult logicGenerateResult = this.generateResult(dto);
        String className = null;
        ArrayList<String> result = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)logicGenerateResult)) {
            List params = logicGenerateResult.getParameterNames();
            List files = logicGenerateResult.getFiles();
            className = EaiLogicConstant.getOpenPackageName((String)appCode, (EaiResourcesEnum)EaiResourcesEnum.API, (String)apiVersion.getApiCode(), (String)version);
            String clazz = null;
            if (HussarUtils.isNotEmpty((Object)files)) {
                clazz = ((LogicGenerateFile)files.get(0)).getContent();
            }
            this.eaiLogicSourceService.saveProdCode(className, clazz);
            result.add(className);
            result.addAll(params);
        }
        return JSON.toJSONString(result);
    }

    public EaiPublishCommonResources getCommonResourcesByCanvas(CanvasInfo canvas, Map<String, Integer> resourceMap, String version) {
        HashMap<Long, Long> constIdsMaps = new HashMap<Long, Long>();
        HashMap<Long, Long> structIdsMaps = new HashMap<Long, Long>();
        HashMap<Long, Long> connIdsMaps = new HashMap<Long, Long>();
        HashMap<Long, Long> logicIdsMaps = new HashMap<Long, Long>();
        return this.getResourcesInfo(canvas, resourceMap, version, constIdsMaps, structIdsMaps, connIdsMaps, logicIdsMaps);
    }

    private String canvasId(Long id, String type) {
        return String.format("%s:%s", type, id);
    }

    private String logicId(Long id, String type) {
        return String.format("%s\":\"%s", type, id);
    }

    private ConnectionVersion toConnectionVersion(CommonConnection commonConnection, String appVersion) {
        ConnectionVersion connectionVersion = new ConnectionVersion();
        BeanUtil.copyProperties((Object)commonConnection, (Object)connectionVersion);
        connectionVersion.setId(IdGenerateUtils.getId());
        connectionVersion.setConnVersion(appVersion);
        connectionVersion.setConnectionId(commonConnection.getId());
        return connectionVersion;
    }

    private ConstantVersion toConstantVersion(CommonConstant commonConstant, String version) {
        ConstantVersion constantVersion = new ConstantVersion();
        BeanUtil.copyProperties((Object)commonConstant, (Object)constantVersion);
        constantVersion.setId(IdGenerateUtils.getId());
        constantVersion.setConstantVersion(version);
        constantVersion.setConstantId(commonConstant.getId());
        return constantVersion;
    }

    private StructureVersion toStructVersion(CommonStructure commonStructure, String version, Map<Long, Long> idMaps) {
        StructureVersion structureVersion = new StructureVersion();
        BeanUtil.copyProperties((Object)commonStructure, (Object)structureVersion);
        String value = StructureQuoteIdPattern.replaceIds((String)commonStructure.getStructureValues(), idMaps);
        structureVersion.setStructureValues(value);
        structureVersion.setId(idMaps.get(commonStructure.getId()));
        structureVersion.setStructureVersion(version);
        structureVersion.setStructureId(commonStructure.getId());
        return structureVersion;
    }

    private EaiPublishCommonResources getResourcesInfo(CanvasInfo canvas, Map<String, Integer> resourceMap, String version, Map<Long, Long> constIdsMaps, Map<Long, Long> structIdsMaps, Map<Long, Long> connIdsMaps, Map<Long, Long> logicIdsMaps) {
        List<CommonStructure> commonStructures;
        EaiPublishCommonResources resources = new EaiPublishCommonResources();
        ArrayList<ConstantVersion> constantVersions = new ArrayList<ConstantVersion>();
        ArrayList<StructureVersion> structureVersions = new ArrayList<StructureVersion>();
        ArrayList<ConnectionVersion> connectionVersions = new ArrayList<ConnectionVersion>();
        ArrayList logicVersions = new ArrayList();
        ArrayList constIds = new ArrayList();
        ArrayList structIds = new ArrayList();
        ArrayList connIds = new ArrayList();
        ArrayList logicIds = new ArrayList();
        resourceMap.forEach((k, v) -> {
            if (v != null && v > 0) {
                String[] str = k.split(":");
                if (EaiResourcesEnum.CONSTANT.getType().equals(str[0])) {
                    constIds.add(Long.valueOf(str[1]));
                }
                if (EaiResourcesEnum.STRUCTURE.getType().equals(str[0])) {
                    structIds.add(Long.valueOf(str[1]));
                }
                if (EaiResourcesEnum.LINK.getType().equals(str[0])) {
                    connIds.add(Long.valueOf(str[1]));
                }
                if (EaiResourcesEnum.LOGIC.getType().equals(str[0])) {
                    logicIds.add(Long.valueOf(str[1]));
                }
            }
        });
        String canvasConstant = canvas.getCanvasContent();
        if (!logicIds.isEmpty()) {
            List commonLogics = this.commonLogicService.listByIds(logicIds);
            for (CommonLogic commonLogic : commonLogics) {
                EaiCanvasConvertDto canvasConvertDto = new EaiCanvasConvertDto();
                canvasConvertDto.setCommonLogic(commonLogic);
                canvasConvertDto.setVersion(version);
                canvasConvertDto.setConnIds(connIdsMaps);
                canvasConvertDto.setLogicIds(logicIdsMaps);
                canvasConvertDto.setConstIds(constIdsMaps);
                canvasConvertDto.setStructIds(structIdsMaps);
                LogicVersion logicVersion = this.toLogicVersion(canvasConvertDto, resources);
                this.filCanvas(canvas, logicVersion.getLogicId(), logicVersion.getId(), EaiResourcesEnum.LOGIC.getType());
                canvasConstant = canvasConstant.replace(String.valueOf(logicVersion.getLogicId()), String.valueOf(logicVersion.getId()));
                canvas.setCanvasContent(canvasConstant);
                logicIdsMaps.put(logicVersion.getLogicId(), logicVersion.getId());
            }
        }
        if (!constIds.isEmpty()) {
            List commonConstants = this.commonConstantService.listByIds(constIds);
            for (CommonConstant commonConstant : commonConstants) {
                ConstantVersion constantVersion = this.toConstantVersion(commonConstant, version);
                this.filCanvas(canvas, commonConstant.getId(), constantVersion.getId(), EaiResourcesEnum.CONSTANT.getType());
                this.transFormResource(canvasConstant, commonConstant.getId(), constantVersion.getId());
                canvas.setCanvasContent(canvasConstant);
                constIdsMaps.put(commonConstant.getId(), constantVersion.getId());
                constantVersions.add(constantVersion);
            }
            if (HussarUtils.isNotEmpty((Object)resources.getInsertConstants())) {
                resources.getInsertConstants().addAll(constantVersions);
            } else {
                resources.setInsertConstants(constantVersions);
            }
        }
        if (!structIds.isEmpty() && HussarUtils.isNotEmpty((Object)(commonStructures = this.structureService.listByIds(structIds)))) {
            List child;
            Object childs;
            ArrayList list = new ArrayList();
            commonStructures.forEach(commonStructure -> {
                String values = commonStructure.getStructureValues();
                List ids = StructureQuoteIdPattern.getIds((String)values);
                if (HussarUtils.isNotEmpty((Object)ids)) {
                    list.addAll(ids);
                }
            });
            if (HussarUtils.isNotEmpty(list) && HussarUtils.isNotEmpty((Object)(childs = this.structureService.listByIds(child = list.stream().distinct().collect(Collectors.toList()))))) {
                commonStructures.addAll((Collection<CommonStructure>)childs);
            }
            commonStructures = commonStructures.stream().distinct().collect(Collectors.toList());
            HashMap<Long, Long> idMaps = new HashMap<Long, Long>();
            commonStructures.forEach(commonStructure -> idMaps.put(commonStructure.getId(), IdGenerateUtils.getId()));
            for (CommonStructure commonStructure2 : commonStructures) {
                StructureVersion structureVersion = this.toStructVersion(commonStructure2, version, idMaps);
                this.filCanvas(canvas, commonStructure2.getId(), structureVersion.getId(), EaiResourcesEnum.STRUCTURE.getType());
                canvasConstant = this.transFormResource(canvasConstant, commonStructure2.getId(), structureVersion.getId());
                canvas.setCanvasContent(canvasConstant);
                structIdsMaps.put(commonStructure2.getId(), structureVersion.getId());
                structureVersions.add(structureVersion);
            }
            if (HussarUtils.isNotEmpty((Object)resources.getInsertStructures())) {
                resources.getInsertStructures().addAll(structureVersions);
            } else {
                resources.setInsertStructures(structureVersions);
            }
        }
        if (!connIds.isEmpty()) {
            List commonConnections = this.commonConnectionService.listByIds(connIds);
            for (CommonConnection commonConnection : commonConnections) {
                ConnectionVersion connectionVersion = this.toConnectionVersion(commonConnection, version);
                this.filCanvas(canvas, commonConnection.getId(), connectionVersion.getId(), EaiResourcesEnum.LINK.getType());
                canvasConstant = this.transFormResource(canvasConstant, commonConnection.getId(), connectionVersion.getId());
                canvas.setCanvasContent(canvasConstant);
                connIdsMaps.put(commonConnection.getId(), connectionVersion.getId());
                connectionVersions.add(connectionVersion);
            }
        }
        return resources;
    }

    private LogicVersion toLogicVersion(EaiCanvasConvertDto canvasConvertDto, EaiPublishCommonResources parentResources) {
        CommonLogic commonLogic = canvasConvertDto.getCommonLogic();
        String version = canvasConvertDto.getVersion();
        Map<Long, Long> constIds = canvasConvertDto.getConnIds();
        Map<Long, Long> structIds = canvasConvertDto.getStructIds();
        Map<Long, Long> connIds = canvasConvertDto.getConnIds();
        Map<Long, Long> logicIds = canvasConvertDto.getLogicIds();
        CanvasInfo canvas = (CanvasInfo)this.canvasInfoService.getById((Serializable)Long.valueOf(commonLogic.getCanvasId()));
        String resource = canvas.getCanvasResources();
        String constant = canvas.getCanvasContent();
        LogicVersion logicVersion = new LogicVersion();
        BeanUtil.copyProperties((Object)commonLogic, (Object)logicVersion);
        logicVersion.setId(IdGenerateUtils.getId());
        logicVersion.setLogicVersion(version);
        logicVersion.setLogicId(commonLogic.getId());
        String content = canvas.getCanvasContent();
        logicIds.put(commonLogic.getId(), logicVersion.getId());
        Long canvasId = IdGenerateUtils.getId();
        canvas.setId(canvasId);
        this.filCanvas(canvas, commonLogic.getId(), logicVersion.getId(), EaiResourcesEnum.LOGIC.getType());
        content = this.transFormResource(content, commonLogic.getId(), logicVersion.getId());
        canvas.setCanvasContent(content);
        logicVersion.setLogicClassify(EaiCategoryEnum.OPEN.getCode());
        if (HussarUtils.isNotEmpty(structIds)) {
            String versionIn = null;
            String versionOut = null;
            for (Map.Entry<Long, Long> entry : structIds.entrySet()) {
                versionIn = commonLogic.getInParams().replace(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                versionOut = commonLogic.getOutParams().replace(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            logicVersion.setInParams(versionIn);
            logicVersion.setOutParams(versionOut);
        }
        logicVersion.setCanvasId(canvasId.longValue());
        return logicVersion;
    }

    private void filChild(String constant, String resource, Map<String, Integer> resourceMap, Map<Long, Long> constIds, Map<Long, Long> structIds, Map<Long, Long> connIds, Map<Long, Long> logicIds, Map<String, Integer> childResourceMap) {
        for (Map.Entry<String, Integer> entry : resourceMap.entrySet()) {
            String k = entry.getKey();
            Integer v = entry.getValue();
            if (v == null || v <= 0) continue;
            String[] str = k.split(":");
            Long id = Long.valueOf(str[1]);
            if (constIds.containsKey(id) || structIds.containsKey(id) || connIds.containsKey(id) || logicIds.containsKey(id)) {
                resource = this.transFormResource(resource, id, constIds);
                constant = this.transFormResource(constant, id, constIds);
                continue;
            }
            childResourceMap.put(k, v);
        }
    }

    private String transFormResource(String resource, Long id, Map<Long, Long> resourceIds) {
        return resource.replace(String.valueOf(id), String.valueOf(resourceIds.get(id)));
    }

    private String transFormResource(String resource, Long id, Long newId) {
        return resource.replace(String.valueOf(id), String.valueOf(newId));
    }

    private void filCanvas(CanvasInfo canvas, Long oldId, Long newId, String type) {
        String canvasResources = canvas.getCanvasResources();
        if (HussarUtils.isNotEmpty((Object)canvasResources)) {
            JSONObject object = JSON.parseObject((String)canvasResources);
            HashMap map = new HashMap();
            object.forEach((k, v) -> {
                if (k.equals(this.canvasId(oldId, type))) {
                    map.put(this.canvasId(newId, type), Integer.valueOf(String.valueOf(v)));
                } else {
                    map.put(k, Integer.valueOf(String.valueOf(v)));
                }
            });
            canvas.setCanvasResources(JSON.toJSONString(map));
        }
    }
}

