/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl;

import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiGenerateService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl.EaiStructureGenerateSourceManager;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateConfigure;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateResult;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateSource;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureClassNameResolver;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureGenerateService;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl.EaiStructureClassResolverImpl")
public class EaiStructureClassResolverImpl
implements EaiStructureClassNameResolver {
    @Resource
    private EaiGenerateService eaiGenerateService;
    @Autowired
    SourceService sourceService;
    @Resource
    private EaiStructureGenerateSourceManager structureGenerateSourceManager;
    @Resource
    EaiStructureClassNameResolver eaiStructureClassNameResolver;
    @Resource
    private EaiStructureGenerateService eaiStructureGenerateService;

    public String resolveStructureClassName(String structureId, EaiStructureGenerateConfigure configure) {
        String[] strings = structureId.trim().split(":");
        Boolean isPublish = configure.getDebug() == false;
        String type = strings[0];
        Long id = Long.valueOf(strings[strings.length - 1]);
        String className = this.eaiGenerateService.generatedClassName(configure.getEaiInfo().getEnvironmentCategory(), type, id, configure.getEaiInfo().getApplicationVersion(), isPublish);
        if (configure.getDebug().booleanValue() || !this.hasCode(className, isPublish).booleanValue()) {
            LogicGenerateConfigure logicGenerateConfigure = new LogicGenerateConfigure();
            logicGenerateConfigure.setEaiInfo(configure.getEaiInfo());
            logicGenerateConfigure.setDebug(configure.getDebug());
            EaiStructureGenerateSource eaiStructureGenerateSource = this.structureGenerateSourceManager.generateStructureCode(id, type, logicGenerateConfigure);
            EaiStructureGenerateConfigure structConfig = new EaiStructureGenerateConfigure();
            structConfig.setDebug(configure.getDebug());
            structConfig.setEaiInfo(configure.getEaiInfo());
            structConfig.setStructureResolver(this.eaiStructureClassNameResolver);
            structConfig.setPrefixPackage("com.jxdinfo.hussar.eai.generated");
            EaiStructureGenerateResult result = this.eaiStructureGenerateService.generateStructureCode(eaiStructureGenerateSource, structConfig);
            this.saveCode(className, result.getContent(), isPublish);
        }
        return className;
    }

    private void saveCode(String className, String result, Boolean isPublish) {
        if (!isPublish.booleanValue()) {
            this.sourceService.saveOrUpdateDev(className, result);
        } else {
            this.sourceService.saveOrUpdateProd(className, result);
        }
    }

    private Boolean hasCode(String className, Boolean isPublish) {
        Optional logicSourceEntity = null;
        logicSourceEntity = isPublish != false ? this.sourceService.getProdByCode(className) : this.sourceService.getProdByCode(className);
        return HussarUtils.isNotEmpty((Object)logicSourceEntity);
    }
}

