/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.logic.generator.resolver.LogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.structure.eai.LogicEaiContextInfo;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationLanguage;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationPlatform;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationRuntime;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class EaiLogicConfig {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private LogicBackendExternalResolver logicBackendExternalResolver;

    public LogicGenerateConfigure initConfigure(Boolean isDebug, String appCode, String appVersion) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode);
        SysApplication application = (SysApplication)this.sysApplicationService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)application)) {
            throw new BaseException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        LogicGenerateConfigure configure = new LogicGenerateConfigure();
        configure.setBackendExternalResolver(this.logicBackendExternalResolver);
        configure.setBackendPrefixPackage("com.jxdinfo.hussar.eai.generated");
        configure.setLanguage(LogicGenerationLanguage.JAVA);
        configure.setPlatform(LogicGenerationPlatform.EAI_PLATFORM);
        configure.setRuntime(LogicGenerationRuntime.ENGINE);
        configure.setDebug(isDebug);
        LogicEaiContextInfo eaiInfo = new LogicEaiContextInfo();
        eaiInfo.setEnvironmentCategory("open");
        eaiInfo.setApplicationCode(appCode);
        eaiInfo.setApplicationName(application.getAppName());
        eaiInfo.setApplicationVersion(application.getAppVersion());
        eaiInfo.setApplicationDescription(application.getAppDescribe());
        if (HussarUtils.isNotEmpty((Object)appVersion)) {
            eaiInfo.setApplicationVersion(appVersion);
        }
        configure.setEaiInfo(eaiInfo);
        return configure;
    }
}

