/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiCanvasResourceService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiGenerateService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl.EaiStructureGenerateSourceManager;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.EaiCanvasUtil;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.logic.generator.resolver.LogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.service.LogicGenerateService;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateConfigure;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateResult;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateSource;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureClassNameResolver;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureGenerateService;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasMetadata;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasVariable;
import com.jxdinfo.hussar.logic.structure.eai.LogicEaiContextInfo;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.logic.structure.resolve.logic.LogicReference;
import com.jxdinfo.hussar.logic.structure.resolve.logic.LogicReferenceCategory;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.canvas.logicresources.serevice.impl.LogicBackendExternalResolver")
public class EaiLogicBackendExternalResolverImpl
implements LogicBackendExternalResolver {
    @Resource
    private EaiCanvasResourceService resourceService;
    @Resource
    private EaiGenerateService eaiGenerateService;
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private EaiStructureGenerateSourceManager structureGenerateSourceManager;
    @Resource
    private EaiStructureGenerateService eaiStructureGenerateService;
    @Resource
    EaiStructureClassNameResolver eaiStructureClassNameResolver;
    @Autowired
    SourceService sourceService;
    @Resource
    private LogicGenerateService logicGenerateService;

    public String resolveCustomType(String customTypeName, LogicGenerateConfigure configure) {
        if (customTypeName.startsWith("com.jxdinfo.hussar.eai.generated")) {
            return customTypeName;
        }
        LogicEaiContextInfo eaiContextInfo = configure.getEaiInfo();
        String category = eaiContextInfo.getEnvironmentCategory();
        String version = eaiContextInfo.getApplicationVersion();
        if (HussarUtils.isNotEmpty((Object)customTypeName)) {
            String[] strings = customTypeName.trim().split(":");
            Boolean isPublish = configure.getDebug() == false;
            String type = strings[0];
            Long id = Long.valueOf(strings[strings.length - 1]);
            String className = this.eaiGenerateService.generatedClassName(category, type, id, version, isPublish);
            if (EaiResourcesEnum.STRUCTURE.getType().equals(type)) {
                return this.structureGenerate(className, id, type, configure, isPublish);
            }
            return className;
        }
        throw new BaseException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
    }

    private String structureGenerate(String className, Long id, String type, LogicGenerateConfigure configure, Boolean isPublish) {
        Optional entity = isPublish != false ? this.sourceService.getProdByCode(className) : this.sourceService.getDevByCode(className);
        if (entity.isPresent() && HussarUtils.isNotEmpty((Object)((LogicSourceEntity)entity.get()).getSourceId())) {
            return className;
        }
        EaiStructureGenerateSource eaiStructureGenerateSource = this.structureGenerateSourceManager.generateStructureCode(id, type, configure);
        EaiStructureGenerateConfigure structConfig = new EaiStructureGenerateConfigure();
        structConfig.setDebug(configure.getDebug());
        structConfig.setEaiInfo(configure.getEaiInfo());
        structConfig.setStructureResolver(this.eaiStructureClassNameResolver);
        structConfig.setPrefixPackage("com.jxdinfo.hussar.eai.generated");
        EaiStructureGenerateResult result = this.eaiStructureGenerateService.generateStructureCode(eaiStructureGenerateSource, structConfig);
        this.saveCode(className, result.getContent(), isPublish);
        return className;
    }

    private void saveCode(String className, String result, Boolean isPublish) {
        if (!isPublish.booleanValue()) {
            this.sourceService.saveOrUpdateDev(className, result);
        } else {
            this.sourceService.saveOrUpdateProd(className, result);
        }
    }

    public LogicReference resolveLogic(String logicId, LogicGenerateConfigure configure) {
        LogicEaiContextInfo eaiContextInfo = configure.getEaiInfo();
        String category = eaiContextInfo.getEnvironmentCategory();
        String version = eaiContextInfo.getApplicationVersion();
        String appCode = eaiContextInfo.getApplicationCode();
        String[] strings = logicId.trim().split(":");
        Boolean isPublish = configure.getDebug() == false;
        String id = strings[strings.length - 1];
        ApiResponse obj = null;
        Boolean env = isPublish;
        if (isPublish.booleanValue()) {
            obj = this.resourceService.getById(category, EaiResourcesEnum.LOGIC.getType(), isPublish, Long.valueOf(id));
        } else {
            try {
                obj = this.resourceService.getById(category, EaiResourcesEnum.LOGIC.getType(), isPublish, Long.valueOf(id));
            }
            catch (Exception e) {
                obj = this.resourceService.getById(category, EaiResourcesEnum.LOGIC.getType(), Boolean.valueOf(isPublish == false), Long.valueOf(id));
                env = true;
            }
        }
        if (obj.isSuccess()) {
            String envCategory;
            JSONObject result = JSONObject.parseObject((String)JSON.toJSONString((Object)obj.getData()));
            String inParams = result.getString("inParams");
            String outParams = result.getString("outParams");
            if (env.booleanValue() && !category.equals(envCategory = EaiCategoryEnum.getByCode((String)result.getString("logicClassify")).getName())) {
                throw new BaseException("\u672a\u67e5\u8be2\u5230\u5f15\u7528\u7684\u903b\u8f91\u8d44\u6e90");
            }
            String logicCode = result.getString("logicCode");
            String logicName = result.getString("logicName");
            LogicReference logicReference = new LogicReference();
            logicReference.setCategory(LogicReferenceCategory.BACKEND);
            logicReference.setId(id);
            logicReference.setName(logicCode);
            logicReference.setTitle(logicName);
            logicReference.setParams(this.getInfo(inParams, category, version, configure, env));
            logicReference.setResult(this.getInfo(outParams, category, version, configure, env));
            List list = EaiCanvasUtil.setModules((String)category, (String)appCode, (String)EaiResourcesEnum.LOGIC.getType(), (String)version);
            logicReference.setModules(list);
            String className = this.eaiGenerateService.generatedClassName(category, EaiResourcesEnum.LOGIC.getType(), Long.valueOf(id), version, isPublish);
            Optional entity = this.sourceService.getDevByCode(className);
            if (!isPublish.booleanValue() || !entity.isPresent()) {
                LogicGenerateConfigure logicConfigure = new LogicGenerateConfigure();
                BeanUtil.copyProperties((Object)configure, (Object)logicConfigure);
                this.generateLogic(className, version, logicConfigure, result, list, isPublish);
            }
            return logicReference;
        }
        return null;
    }

    private void generateLogic(String className, String version, LogicGenerateConfigure configure, JSONObject result, List<String> list, Boolean isPublish) {
        Long canvasId = result.getLong("canvasId");
        CanvasInfo canvasInfo = (CanvasInfo)this.canvasInfoService.getById((Serializable)canvasId);
        LogicCanvasComponent canvasComponent = (LogicCanvasComponent)JSONObject.parseObject((String)canvasInfo.getCanvasContent(), LogicCanvasComponent.class);
        LogicGenerateSource generateSource = new LogicGenerateSource();
        generateSource.setRoot(canvasComponent);
        generateSource.setModules(list);
        LogicCanvasMetadata canvasMetadata = new LogicCanvasMetadata();
        canvasMetadata.setId(String.valueOf(canvasInfo.getId()));
        canvasMetadata.setName(result.getString("logicCode"));
        canvasMetadata.setDesc(result.getString("logicName"));
        canvasMetadata.setVersion(version);
        generateSource.setMeta(canvasMetadata);
        LogicGenerateResult logicGenerateResult = this.logicGenerateService.generate(generateSource, configure);
        if (HussarUtils.isNotEmpty((Object)logicGenerateResult)) {
            List files = logicGenerateResult.getFiles();
            if (!isPublish.booleanValue()) {
                this.sourceService.saveOrUpdateDev(className, ((LogicGenerateFile)files.get(0)).getContent());
            } else {
                this.sourceService.saveOrUpdateProd(className, ((LogicGenerateFile)files.get(0)).getContent());
            }
        }
    }

    private List<LogicCanvasVariable> getInfo(String params, String category, String version, LogicGenerateConfigure configure, Boolean isPublished) {
        ArrayList<LogicCanvasVariable> list = new ArrayList<LogicCanvasVariable>();
        if (HussarUtils.isNotEmpty((Object)params)) {
            List eaiParamsItems = ParamsConvertUtil.toEaiParamsItems((String)params);
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() != ((EaiParamsItems)eaiParamsItems.get(0)).getType().intValue() && EaiDataType.DATA_TYPE_LIST.getType() != ((EaiParamsItems)eaiParamsItems.get(0)).getType().intValue()) {
                eaiParamsItems = ((EaiParamsItems)eaiParamsItems.get(0)).getItems();
            }
            eaiParamsItems.forEach(eaiParamsItem -> {
                LogicCanvasVariable variable = new LogicCanvasVariable();
                variable.setId(eaiParamsItem.getQuoteStructureId());
                variable.setName(eaiParamsItem.getMappingName());
                variable.setType(this.formatType((EaiParamsItems)eaiParamsItem, category, version, configure, isPublished));
                variable.setHasDefault(Boolean.valueOf(false));
                variable.setDescription(eaiParamsItem.getMark());
                list.add(variable);
            });
        }
        return list;
    }

    public Object formatType(EaiParamsItems paramsItem, String category, String version, LogicGenerateConfigure configure, Boolean isPublished) {
        if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getType().intValue()) {
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getItemType().intValue()) {
                String className = this.eaiGenerateService.generatedClassName(category, EaiResourcesEnum.STRUCTURE.getType(), Long.valueOf(Long.parseLong(paramsItem.getQuoteStructureId())), version, isPublished);
                className = this.structureGenerate(className, Long.valueOf(paramsItem.getQuoteStructureId()), EaiResourcesEnum.STRUCTURE.getType(), configure, isPublished);
                return this.listType(className);
            }
            if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getItemType().intValue()) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add("list");
                for (EaiParamsItems item : ((EaiParamsItems)paramsItem.getItems().get(0)).getItems()) {
                    Object childType = this.formatType(item, category, version, configure, isPublished);
                    list.add(childType);
                }
                return list;
            }
            return this.listType(EaiDataType.getEaiDataType((Integer)paramsItem.getItemType()).getCode().toLowerCase());
        }
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getType().intValue()) {
            String className = this.eaiGenerateService.generatedClassName(category, EaiResourcesEnum.STRUCTURE.getType(), Long.valueOf(Long.parseLong(paramsItem.getQuoteStructureId())), version, isPublished);
            return this.structureGenerate(className, Long.valueOf(paramsItem.getQuoteStructureId()), EaiResourcesEnum.STRUCTURE.getType(), configure, isPublished);
        }
        return EaiDataType.getEaiDataType((Integer)paramsItem.getType()).getCode().toLowerCase();
    }

    private String[] listType(String type) {
        return new String[]{"list", type};
    }
}

