/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.resourcerelation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.dto.EaiRelationResource;
import com.jxdinfo.hussar.eai.atomicenhancements.api.resourcerelation.service.EaiAppStatusEnhancementsService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.resourcerelation.service.EaiResourceRelationEnhancementsService;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.resourcerelation.service.impl.EaiResourceRelationEnhancementsServiceImpl")
public class EaiResourceRelationEnhancementsServiceImpl
implements EaiResourceRelationEnhancementsService {
    @Resource
    ICommonConnectionService commonConnectionService;
    @Resource
    ICommonLogicService commonLogicService;
    @Resource
    EaiAppStatusEnhancementsService eaiAppStatusEnhancementsService;
    @Resource
    ICommonStructureService commonStructureService;
    @Resource
    IEaiApiInfoService apiInfoService;
    @Resource
    IEaiEditApiService eaiEditApiService;
    @Resource
    ICanvasInfoService canvasInfoService;

    public List<EaiRelationResource> resourcesConnection(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CommonConnection commonConnection = (CommonConnection)this.commonConnectionService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)commonConnection)) {
            throw new HussarException("\u516c\u5171\u8fde\u63a5\u4e0d\u5b58\u5728\uff01\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(commonConnection.getId());
        return this.resourcesLogics(commonConnection.getApplicationCode(), ids);
    }

    public List<EaiRelationResource> resourcesApi(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u4e0d\u5b58\u5728\uff01\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(apiInfo.getId());
        return this.eaiAppStatusEnhancementsService.resourcesApis(apiInfo.getApplicationCode(), ids);
    }

    public List<EaiRelationResource> resourcesLogic(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CommonLogic commonLogic = (CommonLogic)this.commonLogicService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)commonLogic)) {
            throw new HussarException("\u516c\u5171\u903b\u8f91\u4e0d\u5b58\u5728\uff01\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(commonLogic.getId());
        return this.resourcesLogics(commonLogic.getApplicationCode(), ids);
    }

    public List<EaiRelationResource> resourcesCommonStructure(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ArrayList<EaiRelationResource> relationResources = new ArrayList<EaiRelationResource>();
        CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)Long.valueOf(id));
        if (HussarUtils.isNotEmpty((Object)commonStructure)) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(commonStructure.getId());
            List<EaiRelationResource> list = this.logic(commonStructure.getApplicationCode(), id);
            this.getResource(relationResources, list);
            List<EaiRelationResource> apilist = this.resourcesLogics(commonStructure.getApplicationCode(), ids);
            this.getResource(relationResources, apilist);
            List<EaiRelationResource> connList = this.connection(commonStructure.getApplicationCode(), id);
            if (HussarUtils.isNotEmpty(connList)) {
                relationResources.addAll(connList);
            }
        }
        return relationResources;
    }

    private List<EaiRelationResource> logic(String applicationCode, String id) {
        ArrayList<EaiRelationResource> eaiRelationResources = new ArrayList<EaiRelationResource>();
        LambdaQueryWrapper canvasInfoLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().like(CanvasInfo::getCanvasResources, (Object)String.format("%%%s%%", id));
        List canvasInfoList = this.canvasInfoService.list((Wrapper)canvasInfoLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)canvasInfoList)) {
            List ids = canvasInfoList.stream().map(CanvasInfo::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonLogic::getApplicationCode, (Object)applicationCode)).in(CommonLogic::getCanvasId, ids);
            List commonLogicList = this.commonLogicService.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)commonLogicList)) {
                for (CommonLogic commonLogic : commonLogicList) {
                    EaiRelationResource eaiRelationResource = new EaiRelationResource();
                    eaiRelationResource.setName(commonLogic.getLogicName());
                    eaiRelationResource.setType(EaiResourcesEnum.LOGIC.getType());
                    eaiRelationResource.setNameEn(commonLogic.getLogicCode());
                    eaiRelationResources.add(eaiRelationResource);
                }
            }
        }
        return eaiRelationResources;
    }

    private List<EaiRelationResource> connection(String applicationCode, String id) {
        ArrayList<EaiRelationResource> eaiRelationResources = new ArrayList<EaiRelationResource>();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)applicationCode);
        List commonConnections = this.commonConnectionService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)commonConnections)) {
            for (CommonConnection commonConnection : commonConnections) {
                String config = commonConnection.getConnectionConfig();
                if (!HussarUtils.isNotEmpty((Object)config) || !config.contains(id)) continue;
                EaiRelationResource eaiRelationResource = new EaiRelationResource();
                eaiRelationResource.setName(commonConnection.getConnectionName());
                eaiRelationResource.setType(EaiResourcesEnum.LINK.getType());
                eaiRelationResource.setNameEn(commonConnection.getConnectionNameEn());
                eaiRelationResources.add(eaiRelationResource);
            }
        }
        return eaiRelationResources;
    }

    private void getResource(List<EaiRelationResource> relationResources, List<EaiRelationResource> apiList) {
        if (HussarUtils.isNotEmpty(apiList)) {
            for (EaiRelationResource eaiRelationResource : apiList) {
                if (relationResources.contains(eaiRelationResource)) continue;
                relationResources.add(eaiRelationResource);
            }
        }
    }

    private void addApiToResult(List<ApiInfo> apiInfoList, List<EaiRelationResource> result) {
        if (HussarUtils.isNotEmpty(apiInfoList)) {
            apiInfoList.forEach(apiInfo -> {
                EaiRelationResource eaiRelationResource = new EaiRelationResource();
                eaiRelationResource.setType(EaiResourcesEnum.API.getType());
                eaiRelationResource.setName(apiInfo.getApiName());
                eaiRelationResource.setNameEn(apiInfo.getApiCode());
                result.add(eaiRelationResource);
            });
        }
    }

    public List<EaiRelationResource> resourcesLogics(String applicationCode, List<Long> ids) {
        ArrayList<EaiRelationResource> result = new ArrayList<EaiRelationResource>();
        List<ApiInfo> apiInfoList = this.findCanvasApiScope(applicationCode, ids);
        this.addApiToResult(apiInfoList, result);
        List<CommonLogic> commonLogicList = this.findCanvasLogicScope(applicationCode, ids);
        this.addLogicToResult(commonLogicList, result);
        return result;
    }

    private void addLogicToResult(List<CommonLogic> commonLogicList, List<EaiRelationResource> result) {
        if (HussarUtils.isNotEmpty(commonLogicList)) {
            commonLogicList.forEach(commonLogic -> {
                EaiRelationResource eaiRelationResource = new EaiRelationResource();
                eaiRelationResource.setType(EaiResourcesEnum.LOGIC.getType());
                eaiRelationResource.setName(commonLogic.getLogicName());
                eaiRelationResource.setNameEn(commonLogic.getLogicCode());
                result.add(eaiRelationResource);
            });
        }
    }

    private List<ApiInfo> findCanvasApiScope(String applicationCode, List<Long> ids) {
        List allApi = this.apiInfoService.list((Wrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)applicationCode));
        List allEditApi = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)allApi)) {
            List allApiIds = allApi.stream().map(ApiInfo::getId).collect(Collectors.toList());
            allEditApi = this.eaiEditApiService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EditApi::getApiId, allApiIds));
        }
        if (ToolUtil.isEmpty(allEditApi)) {
            return new ArrayList<ApiInfo>();
        }
        ArrayList<Long> canvasIds = new ArrayList<Long>();
        HashMap<Long, Long> canvasApiMap = new HashMap<Long, Long>();
        for (EditApi editApi : allEditApi) {
            Long canvasId = editApi.getCanvasId();
            if (!ToolUtil.isNotEmpty((Object)canvasId) || canvasId == 0L) continue;
            canvasIds.add(canvasId);
            canvasApiMap.put(canvasId, editApi.getApiId());
        }
        List<Long> apiIdList = this.findCanvasApi(canvasIds, canvasApiMap, ids);
        List<Object> apiInfoList = new ArrayList<ApiInfo>();
        if (ToolUtil.isNotEmpty(apiIdList)) {
            apiInfoList = this.apiInfoService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(ApiInfo::getId, apiIdList));
        }
        return apiInfoList;
    }

    private List<CommonLogic> findCanvasLogicScope(String applicationCode, List<Long> ids) {
        List allLogic = this.commonLogicService.list((Wrapper)new LambdaQueryWrapper().eq(CommonLogic::getApplicationCode, (Object)applicationCode));
        if (ToolUtil.isEmpty((Object)allLogic)) {
            return new ArrayList<CommonLogic>();
        }
        return this.findCanvasLogic(allLogic, ids);
    }

    private List<CommonLogic> findCanvasLogic(List<CommonLogic> logicList, List<Long> ids) {
        List canvasIds = logicList.stream().map(CommonLogic::getCanvasId).filter(ToolUtil::isNotEmpty).collect(Collectors.toList());
        List canvasInfoList = new ArrayList();
        if (ToolUtil.isNotEmpty(canvasIds)) {
            canvasInfoList = this.canvasInfoService.listByIds(canvasIds);
        }
        if (ToolUtil.isEmpty(canvasInfoList)) {
            return new ArrayList<CommonLogic>();
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        block0: for (CanvasInfo canvasInfo : canvasInfoList) {
            for (Long id : ids) {
                if (!canvasInfo.getCanvasResources().contains(String.valueOf(id))) continue;
                idList.add(canvasInfo.getId());
                continue block0;
            }
        }
        if (ToolUtil.isNotEmpty(idList)) {
            return this.commonLogicService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(CommonLogic::getCanvasId, idList));
        }
        return new ArrayList<CommonLogic>();
    }

    private List<Long> findCanvasApi(List<Long> canvasIds, Map<Long, Long> canvasApiMap, List<Long> ids) {
        List canvasInfoList = new ArrayList();
        if (ToolUtil.isNotEmpty(canvasIds)) {
            canvasInfoList = this.canvasInfoService.listByIds(canvasIds);
        }
        if (ToolUtil.isEmpty(canvasInfoList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        block0: for (CanvasInfo canvasInfo : canvasInfoList) {
            for (Long id : ids) {
                if (!HussarUtils.isNotEmpty((Object)canvasInfo.getCanvasResources()) || !canvasInfo.getCanvasResources().contains(String.valueOf(id))) continue;
                Long apiId = canvasApiMap.get(canvasInfo.getId());
                if (!ToolUtil.isNotEmpty((Object)apiId)) continue block0;
                idList.add(apiId);
                continue block0;
            }
        }
        return idList;
    }
}

