/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishBaseResources;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishResourceFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishCanvasService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasConvertService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.publish.dto.EaiPublishEnhancementResources;
import com.jxdinfo.hussar.eai.atomicenhancements.api.publish.service.CanvasExtraResourceIdService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.publish.service.EaiAddEnhancementResourcesService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.publish.service.EaiCommonENResourcesIdMapService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.publish.service.impl.EaiPublishCanvasServiceImpl")
public class EaiPublishCanvasServiceImpl
implements EaiPublishCanvasService {
    @Resource
    private EaiCanvasConvertService canvasConvertService;
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private EaiAddEnhancementResourcesService eaiAddEnhancementResourcesService;
    @Resource
    private EaiCommonENResourcesIdMapService eaiCommonENResourcesIdMapService;
    @Resource
    private List<CanvasExtraResourceIdService> canvasExtraResourceIdServices;

    public Map<Long, Long> publishCanvas(CommonResourcesIdMap commonResources, Map<Long, Long> map, String appVersion) {
        List<CanvasInfo> canvas = null;
        HashMap<Long, Long> result = new HashMap<Long, Long>(map.size());
        HashMap<Long, Long> canvasIdMap = new HashMap<Long, Long>(map.size());
        if (HussarUtils.isEmpty(map)) {
            return result;
        }
        canvas = new ArrayList(map.size());
        EaiPublishEnhancementResources publishEnhancementResources = new EaiPublishEnhancementResources();
        for (Map.Entry<Long, Long> editApi : map.entrySet()) {
            Long resourceId = editApi.getKey();
            Long canvasId = editApi.getValue();
            CanvasInfo canvasInfo = (CanvasInfo)this.canvasInfoService.getById((Serializable)canvasId);
            Long id = EngineUtil.getId();
            canvasInfo.setId(id);
            result.put(resourceId, id);
            canvasIdMap.put(canvasId, id);
            String resources = canvasInfo.getCanvasResources();
            if (!HussarUtils.isNotEmpty((Object)resources)) continue;
            Map resourceMap = (Map)JSON.parseObject((String)resources, (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]);
            EaiPublishEnhancementResources resourcesByCanvas = this.canvasConvertService.getCommonResourcesByCanvas(commonResources, canvasInfo, resourceMap, appVersion);
            this.eaiAddEnhancementResourcesService.addResources((EaiPublishBaseResources)publishEnhancementResources, (EaiPublishBaseResources)resourcesByCanvas);
            if (!HussarUtils.isNotEmpty((Object)resourcesByCanvas) || !HussarUtils.isNotEmpty((Object)resourcesByCanvas.getCanvas())) continue;
            List canvasInfos = resourcesByCanvas.getCanvas();
            CanvasInfo canva = (CanvasInfo)canvasInfos.get(canvasInfos.size() - 1);
            if (HussarUtils.isNotEmpty((Object)commonResources.getCanvasMap())) {
                commonResources.getCanvasMap().put(canvasId, id);
            } else {
                HashMap<Long, Long> map1 = new HashMap<Long, Long>();
                map1.put(canvasId, id);
                commonResources.setCanvasMap(map1);
            }
            if (canvasInfos.size() > 1) {
                List logicCanvas = canvasInfos.subList(0, canvasInfos.size() - 1);
                for (CanvasInfo logicCanva : logicCanvas) {
                    if (canvas.contains(logicCanva)) continue;
                    canvas.add(logicCanva);
                }
            }
            if (canvas.contains(canva)) continue;
            canvas.add(canva);
        }
        if (HussarUtils.isNotEmpty((Object)publishEnhancementResources)) {
            IPublishResourceFactory.getService((String)"default_logic").publishCommonResources((EaiPublishBaseResources)publishEnhancementResources, appVersion);
            this.eaiCommonENResourcesIdMapService.toCommonResourcesIdMap((EaiPublishBaseResources)publishEnhancementResources, commonResources);
        }
        if (HussarUtils.isNotEmpty(canvas)) {
            if (HussarUtils.isNotEmpty(this.canvasExtraResourceIdServices)) {
                for (CanvasExtraResourceIdService canvasExtraResourceIdService : this.canvasExtraResourceIdServices) {
                    canvas = canvasExtraResourceIdService.replaceIds(canvas, commonResources);
                }
            }
            this.canvasInfoService.saveBatch(canvas);
        }
        if (HussarUtils.isNotEmpty(canvasIdMap)) {
            if (HussarUtils.isNotEmpty((Object)commonResources.getCanvasMap())) {
                commonResources.getCanvasMap().putAll(canvasIdMap);
            } else {
                commonResources.setCanvasMap(canvasIdMap);
            }
        }
        return result;
    }
}

