/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.copyresources;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EaiApiClassification;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiClassificationService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.ApiInfoEditVo;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.dto.CodeDto;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.dto.CopyParams;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.factory.CopyResourceServiceFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.service.CopyNumService;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.service.CopyResourceService;
import com.jxdinfo.hussar.eai.common.annotation.EaiAuthCheck;
import com.jxdinfo.hussar.eai.common.annotation.EaiAuthResourceType;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.EaiCounterUtil;
import com.jxdinfo.hussar.eai.common.util.ResourcesNumUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.copyresources.CopyApiServiceImpl")
public class CopyApiServiceImpl
implements CopyResourceService<ApiInfoEditVo> {
    private static final String API_TO_API = "api_default_api";
    @Resource
    private IEaiApiInfoService apiInfoService;
    @Resource
    private IEaiEditApiService eaiEditApiService;
    @Resource
    private CopyNumService copyNumService;
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private IEaiApiClassificationService classificationService;

    @EaiAuthCheck(paramName="id", paramType="id", sourceType=EaiAuthResourceType.API)
    public ApiResponse<ApiInfoEditVo> copyResult(CopyParams copyParams) {
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)Long.valueOf(copyParams.getId()));
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiInfo.getId());
        EditApi editApi = (EditApi)this.eaiEditApiService.getOne((Wrapper)queryWrapper);
        String apiCode = apiInfo.getApiCode();
        String apiName = apiInfo.getApiName();
        String applicationCode = apiInfo.getApplicationCode();
        CodeDto codeDto = this.checkCode(apiCode, applicationCode, true);
        String newApiCode = String.format("%s_%d", codeDto.getCode(), codeDto.getNum());
        CodeDto nameDto = this.checkCode(apiName, applicationCode, false);
        String newApiName = String.format("%s_%d", nameDto.getCode(), nameDto.getNum());
        EaiCounterUtil.getInstanceReduceQueue((String)String.format("%s_%s", codeDto.getCode(), EaiResourcesEnum.API.getType()));
        EaiCounterUtil.getInstanceReduceQueue((String)String.format("%s_%s", nameDto.getCode(), EaiResourcesEnum.API.getType()));
        ApiInfoEditVo apiInfoEditVo = this.apiInfoEditVo(apiInfo, editApi, newApiCode, newApiName);
        return ApiResponse.success((Object)apiInfoEditVo);
    }

    private ApiInfoEditVo apiInfoEditVo(ApiInfo apiInfo, EditApi editApi, String newApiCode, String newApiName) {
        ApiInfoEditVo apiInfoEditVo = new ApiInfoEditVo();
        BeanUtil.copyProperties((Object)editApi, (Object)apiInfoEditVo);
        apiInfoEditVo.setName(newApiName);
        apiInfoEditVo.setDesc(newApiCode);
        Long classificId = apiInfo.getClassificId();
        apiInfoEditVo.setClassificId(classificId);
        if (HussarUtils.isNotEmpty((Object)classificId) && 0L != classificId) {
            EaiApiClassification classification = (EaiApiClassification)this.classificationService.getById((Serializable)classificId);
            apiInfoEditVo.setClassificName(classification.getClassificName());
        } else {
            apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
        }
        apiInfoEditVo.setParentId(Long.valueOf(0L));
        apiInfoEditVo.setRemark(apiInfo.getRemark());
        apiInfoEditVo.setApiPath(this.getApiPath(newApiCode, apiInfo.getApplicationCode()));
        apiInfoEditVo.setApiCode(newApiCode);
        apiInfoEditVo.setTestState("0");
        apiInfoEditVo.setPublicState("1");
        apiInfoEditVo.setApiState("0");
        apiInfoEditVo.setApplicationCode(apiInfo.getApplicationCode());
        apiInfoEditVo.setApiType(apiInfo.getApiType());
        apiInfoEditVo.setApiName(newApiName);
        apiInfoEditVo.setId(null);
        return apiInfoEditVo;
    }

    private String getApiPath(String apiCode, String applicationCode) {
        return String.format("/%s/api/%s", applicationCode, apiCode);
    }

    private CodeDto checkCode(String apiCode, String applicationCode, boolean isCode) {
        String code = ResourcesNumUtil.getName((String)apiCode);
        CodeDto result = this.copyNumService.getNum(apiCode, this.getNumFromList(code, isCode), EaiResourcesEnum.API.getType());
        apiCode = result.getCode();
        long num = result.getNum();
        String newApiCode = String.format("%s_%d", apiCode, num);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ApiInfo::getApiCode, (Object)applicationCode);
        if (isCode) {
            queryWrapper.eq(ApiInfo::getApiCode, (Object)newApiCode);
        } else {
            queryWrapper.eq(ApiInfo::getApiName, (Object)newApiCode);
        }
        long b = this.apiInfoService.count((Wrapper)queryWrapper);
        boolean checkCode = b < 1L;
        result.setChecked(checkCode);
        while (!checkCode) {
            result = this.checkCode(apiCode, applicationCode, isCode);
            checkCode = result.getChecked();
        }
        return result;
    }

    private Long getNumFromList(String code, boolean isCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (isCode) {
            queryWrapper.like(ApiInfo::getApiCode, (Object)code);
        } else {
            queryWrapper.like(ApiInfo::getApiName, (Object)code);
        }
        Long num = 0L;
        List apiInfos = this.apiInfoService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)apiInfos)) {
            List<Object> list = new ArrayList();
            list = isCode ? apiInfos.stream().map(ApiInfo::getApiCode).collect(Collectors.toList()) : apiInfos.stream().map(ApiInfo::getApiName).collect(Collectors.toList());
            num = ResourcesNumUtil.getMaxNum(list);
        }
        return num;
    }

    public void afterPropertiesSet() throws Exception {
        CopyResourceServiceFactory.registerCopyResourceService((String)API_TO_API, (CopyResourceService)this);
    }
}

