/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.service.impl;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.IEaiDynamicDataSourceService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.exception.DynamicDatasourceException;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.datasource.util.DynamicDatasourceUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.service.impl.eaiDynamicDataSourceServiceImpl")
public class EaiDynamicDataSourceServiceImpl
implements IEaiDynamicDataSourceService {
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private DynamicDatasourceService dynamicDataSourceService;
    @Autowired
    private DynamicDataSourceProperties dataSourceProperties;
    private static final String ERR_MSG_EMPTY_DATASOURCE = "\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25";
    private static final String ERR_MSG_EMPTY_CONN_NAME = "\u6570\u636e\u6e90name\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25";
    private static final String ERR_MSG_EMPTY_USERNAME = "\u6570\u636e\u6e90username\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25";
    private static final String ERR_MSG_EMPTY_PASSWORD = "\u6570\u636e\u6e90password\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25";
    private static final String ERR_MSG_EMPTY_JDBC_URL = "\u6570\u636e\u6e90url\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25";
    private static final String ERR_MSG_EMPTY_DRIVER_CLASS = "\u6570\u636e\u6e90\u9a71\u52a8\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25";

    public void saveDynamicDatasource(SysDataSource sysDataSource) {
        SysDataSourceDto dataSourceById = this.datasourceService.getDataSourceById(sysDataSource.getId());
        DynamicDataSourceDto dynamicDatasourceDto = this.getDynamicDatasourceDto(dataSourceById);
        this.dynamicDataSourceService.removeDynamicDatasource(sysDataSource.getConnName());
        this.dynamicDataSourceService.addDynamicDatasource(dynamicDatasourceDto);
    }

    private DynamicDataSourceDto getDynamicDatasourceDto(SysDataSourceDto dataSource) {
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource), (String)ERR_MSG_EMPTY_DATASOURCE);
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getConnName()), (String)ERR_MSG_EMPTY_CONN_NAME);
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getUserName()), (String)ERR_MSG_EMPTY_USERNAME);
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getPassword()), (String)ERR_MSG_EMPTY_PASSWORD);
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getJdbcUrl()), (String)ERR_MSG_EMPTY_JDBC_URL);
        DynamicDatasourceException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSource.getDriverClass()), (String)ERR_MSG_EMPTY_DRIVER_CLASS);
        DynamicDataSourceDto dynamicDataSourceDto = new DynamicDataSourceDto();
        dynamicDataSourceDto.setPoolName(dataSource.getConnName());
        dynamicDataSourceDto.setDriverClassName(dataSource.getDriverClass());
        dynamicDataSourceDto.setUrl(dataSource.getJdbcUrl());
        dynamicDataSourceDto.setUserName(dataSource.getUserName());
        dynamicDataSourceDto.setPassword(dataSource.getPassword());
        if (dataSource.getLazyEnable() != null && dataSource.getLazyEnable().equals(0)) {
            dynamicDataSourceDto.setLazyEnable(Boolean.valueOf(false));
        }
        if (HussarUtils.isNotEmpty((Object)dataSource.getCurrentSchema())) {
            dynamicDataSourceDto.setSchemaName(dataSource.getCurrentSchema());
        }
        DruidConfig druid = DynamicDatasourceUtils.createDataSourceDruid((DynamicDataSourceProperties)this.dataSourceProperties, (String)dataSource.getProperties());
        dynamicDataSourceDto.setDruidConfig(druid);
        return dynamicDataSourceDto;
    }
}

