/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConnectionVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpBodyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpBodyVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.dto.CommonConnectionDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.factory.EaiAppConnectionFactory;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.EaiCommomAppConnectionExtendService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.EaiWebserviceConnectionService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.IEaiAppConnectionExtendService;
import com.jxdinfo.hussar.eai.common.enums.app.EaiAppConnectionEnum;
import com.jxdinfo.hussar.eai.datapacket.business.api.service.IEaiDataPacketBusinessService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.service.impl.EaiAppConnectionApplicationServiceImpl")
public class EaiAppConnectionApplicationServiceImpl
extends EaiCommomAppConnectionExtendService
implements IEaiAppConnectionExtendService {
    @Resource
    private ICommonConnectionService commonConnectionService;
    @Resource
    private IHttpAuthenticationService eaiHttpTemplateAuthService;
    @Resource
    private IEaiApplicationAuthService applicationAuthService;
    @Resource
    private DatasourceService datasourceService;
    @Resource
    private IEaiDataPacketBusinessService eaiDataPacketBusinessService;
    @Resource
    EaiWebserviceConnectionService eaiWebserviceConnectionService;
    @Resource
    IEaiHttpTemplateService eaiHttpTemplateService;

    public void afterPropertiesSet() throws Exception {
        EaiAppConnectionFactory.registerAppConnection((String)(EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_APP.getClassify() + "_" + EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_APP.getClassifyChild()), (IEaiAppConnectionExtendService)this);
    }

    public boolean saveConnection(CommonConnectionDto commonConnectionDto) {
        CommonConnection commonConnection = this.getCommonConnection(commonConnectionDto);
        return this.commonConnectionService.save((Object)commonConnection);
    }

    @HussarTransactional
    public boolean updateConnection(CommonConnectionDto commonConnectionDto) {
        CommonConnection oldConnection = (CommonConnection)this.commonConnectionService.getById((Serializable)commonConnectionDto.getId());
        AssertUtil.isNotNull((Object)oldConnection, (String)"\u672a\u67e5\u8be2\u5230\u8fde\u63a5\u4fe1\u606f\uff01");
        CommonConnection commonConnection = this.getCommonConnection(commonConnectionDto);
        commonConnection.setEditBy(commonConnectionDto.getEditBy());
        this.commonConnectionService.updateById((Object)commonConnection);
        boolean result = this.commonConnectionService.updateById((Object)commonConnection);
        if (EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassify().equals(oldConnection.getConnectionClassify())) {
            if (this.eaiDataPacketBusinessService.checkConnSyncStatus(commonConnection.getId())) {
                throw new BaseException("\u8bf7\u7b49\u5f85\u6570\u636e\u5305\u540c\u6b65\u7ed3\u675f\u540e\u518d\u4fee\u6539\u8fde\u63a5\uff01");
            }
            this.eaiDataPacketBusinessService.syncDeleteDataPacket(oldConnection, "\u6570\u636e\u6e90\u5173\u8054\u6570\u636e\u5305\u5df2\u4e0a\u67b6\u8d44\u4ea7\u5e02\u573a\uff0c\u5982\u4ecd\u9700\u8c03\u6574\uff0c\u8bf7\u5148\u4e0b\u67b6\u76f8\u5173\u6570\u636e\u5305\uff01");
            String connectionConfig = oldConnection.getConnectionConfig();
            if (HussarUtils.isNotBlank((CharSequence)connectionConfig)) {
                SysDataSource data = (SysDataSource)JSON.parseObject((String)connectionConfig, SysDataSource.class);
                this.datasourceService.deleteDataSource((List)Lists.newArrayList((Object[])new String[]{data.getId() + ""}));
            }
        }
        return result;
    }

    public CommonConnectionVo getConnectionById(CommonConnection commonConnection) {
        return this.getCommonConnectionVo(commonConnection);
    }

    public Boolean connectionTest(CommonConnectionDto commonConnectionDto) {
        AssertUtil.isNotNull(commonConnectionDto.getConnectionConfigMap().get("authParams"), (String)"\u9274\u6743\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        List connectionAuthsMap = (List)commonConnectionDto.getConnectionConfigMap().get("authParams");
        List appAuth = this.applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)commonConnectionDto.getClassifyChild()));
        if (connectionAuthsMap.size() != appAuth.size()) {
            throw new BaseException("\u7f3a\u5c11\u9274\u6743\u53c2\u6570");
        }
        ArrayList connectionAuths = Lists.newArrayListWithCapacity((int)10);
        connectionAuthsMap.forEach(authMap -> {
            EaiHttpParamsDto paramsDto = new EaiHttpParamsDto();
            paramsDto.setParamsId(Long.valueOf((String)authMap.get("paramsId")));
            paramsDto.setParamsName((String)authMap.get("paramsName"));
            paramsDto.setParamsNameEn((String)authMap.get("paramsNameEn"));
            paramsDto.setParamsValue((String)authMap.get("paramsValue"));
            paramsDto.setParamsFrom("2");
            connectionAuths.add(paramsDto);
        });
        Boolean httpConn = this.httpConnectionTest(commonConnectionDto, connectionAuths);
        Boolean wsConn = this.eaiWebserviceConnectionService.webserviceConnectionTest(commonConnectionDto.getApplicationCode(), (List)connectionAuths);
        return httpConn != false && wsConn != false;
    }

    public Boolean httpConnectionTest(CommonConnectionDto commonConnectionDto, List<EaiHttpParamsDto> connectionAuths) {
        ApiResponse escapeResponse;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)commonConnectionDto.getClassifyChild())).isNull(EaiHttpTemplate::getTemplateType);
        EaiHttpTemplate eaiHttpTemplate = (EaiHttpTemplate)this.eaiHttpTemplateService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)eaiHttpTemplate) || "0".equals(eaiHttpTemplate.getHttpType())) {
            return true;
        }
        ApiResponse eaiHttpTemplateVoApiResponse = this.eaiHttpTemplateAuthService.httpAuthVerfiyDetail(commonConnectionDto.getClassifyChild(), Boolean.valueOf(true));
        if (!eaiHttpTemplateVoApiResponse.isSuccess()) {
            throw new BaseException("\u67e5\u8be2\u9274\u6743\u9a8c\u8bc1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!");
        }
        if (null == eaiHttpTemplateVoApiResponse.getData()) {
            throw new BaseException("\u9274\u6743\u9a8c\u8bc1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a!");
        }
        EaiHttpTemplateVo authConfigVo = (EaiHttpTemplateVo)eaiHttpTemplateVoApiResponse.getData();
        AssertUtil.isNotNull((Object)authConfigVo, (String)"\u9274\u6743\u9a8c\u8bc1\u914d\u7f6e\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        HttpAuthVerifyDto authVerifyDto = new HttpAuthVerifyDto();
        authVerifyDto.setTokenVerifys(connectionAuths);
        authVerifyDto.setHttpUrl(authConfigVo.getAuthVerify().getHttpUrl());
        authVerifyDto.setHttpUrlType(authConfigVo.getAuthVerify().getHttpUrlType());
        authVerifyDto.setHttpMethod(authConfigVo.getAuthVerify().getHttpMethod());
        authVerifyDto.setApplicationCode(authConfigVo.getApplicationCode());
        if (null != authConfigVo.getEaiHttpParams()) {
            EaiHttpBodyVo httpBodyVo;
            List httpQueryParamVo;
            List httpHeaderVo = authConfigVo.getEaiHttpParams().getHttpHeaderForStruct();
            if (CollectionUtil.isNotEmpty((Collection)httpHeaderVo)) {
                authVerifyDto.setHttpHeaderForStruct(httpHeaderVo);
            }
            if (CollectionUtil.isNotEmpty((Collection)(httpQueryParamVo = authConfigVo.getEaiHttpParams().getHttpQueryParamForStruct()))) {
                authVerifyDto.setHttpQueryParamForStruct(httpQueryParamVo);
            }
            if (null != (httpBodyVo = authConfigVo.getEaiHttpParams().getHttpBody())) {
                EaiHttpBodyDto httpBodyDto = new EaiHttpBodyDto();
                httpBodyDto.setContentType(httpBodyVo.getContentType());
                if (CollectionUtil.isNotEmpty((Collection)httpBodyVo.getBodyParamForStruct())) {
                    httpBodyDto.setAuthHTTPBodyParams(httpBodyVo.getBodyParamForStruct());
                }
                authVerifyDto.setHttpBody(httpBodyDto);
            }
        }
        authVerifyDto.setCallSpecificaList(authConfigVo.getCallSpecificaList());
        ApiResponse eaiApiResponseVoApiResponse = this.eaiHttpTemplateAuthService.httpAuthVerifyPre(authVerifyDto, true);
        if (!eaiApiResponseVoApiResponse.isSuccess()) {
            return false;
        }
        if (null == eaiApiResponseVoApiResponse.getData()) {
            return false;
        }
        if (null != ((EaiApiResponseVo)eaiApiResponseVoApiResponse.getData()).getEscapeResponse() && !(escapeResponse = (ApiResponse)((EaiApiResponseVo)eaiApiResponseVoApiResponse.getData()).getEscapeResponse()).isSuccess()) {
            return false;
        }
        return true;
    }

    public Boolean deleteConnection(CommonConnection commonConnection) {
        return this.commonConnectionService.deleteConnection(commonConnection.getId());
    }
}

