/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.api.canvas.runtime.dto.EaiHttpParams;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiHttpInvokeService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpBodyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.manager.EaiResponseServiceManager;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.integration.support.common.formdata.MultipartFormData;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import jdk.nashorn.api.scripting.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl.HttpInvokeServiceImpl")
public class HttpInvokeServiceImpl
extends EaiResponseServiceManager
implements EaiHttpInvokeService {
    private static final Logger log = LoggerFactory.getLogger(HttpInvokeServiceImpl.class);
    @Resource
    IHttpAuthenticationService authenticationService;
    @Resource
    private IEaiApplicationAuthService applicationAuthService;
    private static final String DEBUG = "DEBUG:%s";

    public ApiResponse<Object> getResponse(EaiHttpParams eaiHttpParams) throws Exception {
        AssertUtil.isNotNull((Object)eaiHttpParams, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3anull");
        HttpAuthVerifyDto authVerifyDto = this.formatParams(eaiHttpParams);
        ApiResponse authResponse = null;
        if (eaiHttpParams.getDebug().booleanValue()) {
            authVerifyDto.setHasCache(true);
            authResponse = this.authenticationService.httpAuthVerify(authVerifyDto, false);
        } else {
            authResponse = this.authenticationService.apiInvoke(authVerifyDto);
        }
        return this.getResp((ApiResponse<EaiApiResponseVo>)authResponse);
    }

    private HttpAuthVerifyDto formatParams(EaiHttpParams eaiHttpParams) {
        String key;
        List<EaiApplicationAuth> applicationAuths = this.getEaiApplicationAuth(eaiHttpParams.getApplicationCode());
        HttpAuthVerifyDto authVerifyDto = new HttpAuthVerifyDto();
        authVerifyDto.setApplicationCode(eaiHttpParams.getApplicationCode());
        authVerifyDto.setHttpUrl(eaiHttpParams.getHttpUrl());
        authVerifyDto.setHttpMethod(eaiHttpParams.getHttpMethod());
        List<EaiHttpParamsDto> headers = this.toEaiHttpParamsDtos(eaiHttpParams.getHttpHeader());
        Map headerMaps = TempHttpCode.getAllParams();
        if (eaiHttpParams.getDebug().booleanValue() && headerMaps.containsKey(key = String.format("eai:api:debug:token:%s", eaiHttpParams.getApplicationCode()))) {
            authVerifyDto.setDebugCacheKey(String.valueOf(headerMaps.get(key)));
            headerMaps.remove(key);
        }
        if (HussarUtils.isNotEmpty((Object)headerMaps)) {
            LambdaQueryWrapper authWrapper = new LambdaQueryWrapper();
            authWrapper.eq(EaiApplicationAuth::getApplicationCode, (Object)eaiHttpParams.getApplicationCode());
            authVerifyDto.setTokenVerifys(this.toEaiHttpParamsDtos(applicationAuths, headerMaps));
        }
        authVerifyDto.setHttpHeader(headers);
        List<EaiHttpParamsDto> query = this.toEaiHttpParamsDtos(eaiHttpParams.getHttpQueryParam());
        authVerifyDto.setHttpQueryParam(query);
        authVerifyDto.setHttpBody(this.toEaiHttpBodyDto(eaiHttpParams.getHttpBody(), eaiHttpParams.getContentType()));
        return authVerifyDto;
    }

    private EaiHttpBodyDto toEaiHttpBodyDto(Object body, int contentType) {
        Map<String, Object> data;
        EaiHttpBodyDto dto;
        block10: {
            dto = new EaiHttpBodyDto();
            dto.setContentType(String.valueOf(contentType));
            data = new HashMap<String, Object>();
            if (EaiContentType.FORM_DATA.getType() == contentType) {
                this.getRequestParamsByKeyValue(body, data);
            } else {
                try {
                    if (body instanceof List) {
                        data.put(null, body);
                        break block10;
                    }
                    if (body instanceof String) {
                        if (contentType == EaiContentType.APPLICATION_JSON.getType()) {
                            try {
                                JSONObject jsonObject = JSONObject.parseObject((String)((String)body));
                                data.put(null, jsonObject);
                                break block10;
                            }
                            catch (Exception e) {
                                throw new HussarException("\u8f93\u5165\u7684\u5b57\u7b26\u4e32\u4e0d\u662f\u6709\u6548\u7684JSON\u5bf9\u8c61\uff0c\u8bf7\u786e\u4fdd\u8f93\u5165\u7684\u662f\u6b63\u786e\u7684JSON\u683c\u5f0f\u5b57\u7b26\u4e32\u3002", (Throwable)e);
                            }
                        }
                        data.put(null, body);
                        break block10;
                    }
                    data = HttpInvokeServiceImpl.structureToMap(body);
                }
                catch (Exception e) {
                    log.error("json parse", (Throwable)e);
                    if (EaiContentType.APPLICATION_JSON.getType() != contentType) {
                        data.put(null, body);
                    }
                    throw new BaseException("\u65e0\u6cd5\u89e3\u6790body\u53c2\u6570");
                }
            }
        }
        dto.setBodyParam(this.toEaiHttpParamsDtos(data));
        return dto;
    }

    private void getRequestParamsByKeyValue(Object body, Map<String, Object> data) {
        if (body instanceof MultipartFormData) {
            MultipartFormData formData = (MultipartFormData)body;
            for (Map.Entry entry : formData.toMap().entrySet()) {
                String key = (String)entry.getKey();
                Collection value = (Collection)entry.getValue();
                if (!CollectionUtil.isNotEmpty((Collection)value)) continue;
                if (value.size() == 1) {
                    data.put(key, value.iterator().next());
                    continue;
                }
                data.put(key, new ArrayList(value));
            }
        } else {
            throw new BaseException("ContentType\u4e3amultipart/form-data\uff0c\u5165\u53c2body\u7c7b\u578b\u5f02\u5e38\uff01");
        }
    }

    private static Map<String, Object> structureToMap(Object data) {
        HashMap<String, Object> map = new HashMap();
        if (data instanceof JSObject) {
            for (String key : ((JSObject)data).keySet()) {
                Object value = ((JSObject)data).getMember(key);
                map.put(key, value);
            }
        } else {
            map = (Map)HussarIntegrationJsonUtils.Contextual.convert((Object)data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return map;
    }

    private List<EaiHttpParamsDto> toEaiHttpParamsDtos(List<EaiApplicationAuth> applicationAuths, Map<String, Object> headerMaps) {
        ArrayList<EaiHttpParamsDto> list = new ArrayList<EaiHttpParamsDto>();
        applicationAuths.forEach(eaiHttpParam -> {
            EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
            eaiHttpParamsDto.setParamsNameEn(eaiHttpParam.getParamsNameEn());
            eaiHttpParamsDto.setParamsId(eaiHttpParam.getParamsId());
            eaiHttpParamsDto.setParamsFrom("2");
            headerMaps.forEach((k, v) -> {
                if (k.equals(eaiHttpParam.getParamsNameEn())) {
                    eaiHttpParamsDto.setParamsValue(ParamsConvertUtil.convertToString((Object)v, (String)eaiHttpParam.getParamsType()));
                }
            });
            list.add(eaiHttpParamsDto);
        });
        return list;
    }

    private List<EaiHttpParamsDto> toEaiHttpParamsDtos(Map data) {
        if (HussarUtils.isNotEmpty((Object)data)) {
            ArrayList<EaiHttpParamsDto> dtos = new ArrayList<EaiHttpParamsDto>(data.size());
            data.forEach((k, v) -> {
                EaiHttpParamsDto dto = new EaiHttpParamsDto();
                dto.setParamsNameEn(k == null ? null : String.valueOf(k));
                dto.setKeyValue(v);
                dtos.add(dto);
            });
            return dtos;
        }
        return null;
    }

    private List<EaiApplicationAuth> getEaiApplicationAuth(String appCode) {
        LambdaQueryWrapper queryWrapper1 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)appCode);
        return this.applicationAuthService.list((Wrapper)queryWrapper1);
    }
}

